/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SimpleMessageOverlay
extends Shell
implements ControlListener {
    private static final int DEFAULT_AUTO_DISMISS_MILLIS = 4000;
    private static final int MAX_MESSAGE_LENGTH = 210;
    private static final int MAX_TOOLTIP_LINE_LENGTH = 60;
    private final SimpleInstallerDialog dialog;
    private final Type type;
    private final ControlRelocator controlRelocator;
    private final boolean dismissAutomatically;
    private final Runnable action;
    private StyledText text;
    private boolean firstShown = true;

    public SimpleMessageOverlay(SimpleInstallerDialog dialog, Type type, ControlRelocator controlRelocator, boolean dismissAutomatically) {
        this(dialog, type, controlRelocator, dismissAutomatically, null);
    }

    public SimpleMessageOverlay(SimpleInstallerDialog dialog, Type type, ControlRelocator controlRelocator, boolean dismissAutomatically, final Runnable action) {
        super((Shell)dialog, 8);
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null!");
        }
        if (controlRelocator == null) {
            throw new IllegalArgumentException("Control relocator must not be null!");
        }
        this.dialog = dialog;
        this.type = type;
        this.controlRelocator = controlRelocator;
        this.dismissAutomatically = dismissAutomatically;
        this.action = action;
        this.setBackground(type.backgroundColor);
        this.setBackgroundMode(2);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 22;
        layout.marginRight = 18;
        layout.marginTop = 3;
        layout.marginBottom = 3;
        this.setLayout((Layout)layout);
        this.text = new StyledText((Composite)this, 72);
        this.text.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).create());
        this.text.setFont(SimpleInstallerDialog.getDefaultFont());
        this.text.setForeground(type.foregroundColor);
        if (action != null) {
            Display display = this.getDisplay();
            this.text.setCursor(display.getSystemCursor(21));
            this.text.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    SimpleMessageOverlay.this.dialog.clearMessage();
                    try {
                        action.run();
                    }
                    catch (Exception ex) {
                        SetupInstallerPlugin.INSTANCE.log(ex);
                    }
                }
            });
        }
        dialog.addControlListener(this);
        ImageHoverButton closeButton = new ImageHoverButton((Composite)this, 8, type.closeImg, type.closeImgHover);
        closeButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 1).indent(0, 12).create());
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleMessageOverlay.this.dialog.clearMessage();
            }
        });
        controlRelocator.relocate((Control)this);
        ParentShellRelocator parentShellRelocator = new ParentShellRelocator(dialog);
        this.addMouseMoveListener(parentShellRelocator);
        this.addMouseListener((MouseListener)parentShellRelocator);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SimpleMessageOverlay.this.getParent().removeControlListener((ControlListener)SimpleMessageOverlay.this);
            }
        });
    }

    public Runnable getAction() {
        return this.action;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDismissAutomatically() {
        return this.dismissAutomatically;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.firstShown && visible && this.dismissAutomatically) {
            this.firstShown = false;
            final Display display = this.getDisplay();
            Thread dismissThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    display.asyncExec(new Runnable(){

                        public void run() {
                            SimpleMessageOverlay.this.dialog.clearMessage();
                        }
                    });
                }
            });
            dismissThread.setDaemon(true);
            dismissThread.start();
        }
    }

    protected void checkSubclass() {
    }

    public void setMessage(String message) {
        String tmp = message;
        String actionLabel = this.action instanceof RunnableWithLabel ? ((RunnableWithLabel)this.action).getLabel() : null;
        int actionLabelStartIndex = Integer.MIN_VALUE;
        int actionLabelLength = Integer.MIN_VALUE;
        if (actionLabel != null) {
            tmp = String.valueOf(tmp) + " " + actionLabel;
            actionLabelStartIndex = message.length() + 1;
            actionLabelLength = actionLabel.length();
        }
        if (tmp.length() > 210) {
            if (actionLabel != null) {
                try {
                    tmp = StringUtil.shorten((String)message, (int)(210 - actionLabel.length() - 1), (boolean)false);
                    actionLabelStartIndex = tmp.length() + 1;
                    tmp = String.valueOf(tmp) + " " + actionLabel;
                    actionLabelLength = actionLabel.length();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    tmp = StringUtil.shorten((String)message, (int)210, (boolean)false);
                    actionLabelStartIndex = Integer.MIN_VALUE;
                    actionLabelLength = Integer.MIN_VALUE;
                }
            } else {
                tmp = StringUtil.shorten((String)message, (int)210, (boolean)false);
            }
            String wrapText = StringUtil.wrapText((String)message, (int)60, (boolean)true);
            wrapText = this.ensureMaxLineLength(message, wrapText, 60);
            this.text.setToolTipText(wrapText);
        } else {
            this.text.setToolTipText(null);
        }
        this.text.setText(tmp);
        if (actionLabelStartIndex >= 0) {
            StyleRange range = new StyleRange(actionLabelStartIndex, actionLabelLength, this.type.foregroundColor, this.type.backgroundColor);
            range.underline = true;
            this.text.setStyleRange(range);
        }
        this.layout();
    }

    private String ensureMaxLineLength(String originalText, String wrappedText, int maxLineLength) {
        String[] lines;
        String[] stringArray;
        if (wrappedText.contains(StringUtil.NL)) {
            stringArray = wrappedText.split(StringUtil.NL);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = wrappedText;
        }
        String[] stringArray3 = lines = stringArray;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray3[n2];
            if (line.length() > maxLineLength) {
                wrappedText = StringUtil.wrapText((String)originalText, (int)maxLineLength, (boolean)false);
                break;
            }
            ++n2;
        }
        return wrappedText;
    }

    public void controlResized(ControlEvent e) {
        if (!this.isDisposed()) {
            this.controlRelocator.relocate((Control)this);
        }
    }

    public void controlMoved(ControlEvent e) {
        if (!this.isDisposed()) {
            this.controlRelocator.relocate((Control)this);
        }
    }

    public static interface ControlRelocator {
        public void relocate(Control var1);
    }

    private class ParentShellRelocator
    extends MouseAdapter
    implements MouseMoveListener {
        private Shell shellToMove;
        private boolean move;
        private Point lastPosition;

        public ParentShellRelocator(Shell shellToMove) {
            this.shellToMove = shellToMove;
        }

        public void mouseDown(MouseEvent e) {
            this.move = true;
            this.lastPosition = SimpleMessageOverlay.this.toDisplay(e.x, e.y);
        }

        public void mouseUp(MouseEvent e) {
            this.move = false;
        }

        public void mouseMove(MouseEvent e) {
            if (this.move) {
                Point currentPosition = SimpleMessageOverlay.this.toDisplay(e.x, e.y);
                int deltaX = currentPosition.x - this.lastPosition.x;
                int deltaY = currentPosition.y - this.lastPosition.y;
                this.lastPosition = currentPosition;
                Point currentShellLocation = this.shellToMove.getLocation();
                int newX = currentShellLocation.x + deltaX;
                int newY = currentShellLocation.y + deltaY;
                this.shellToMove.setLocation(newX, newY);
            }
        }
    }

    public static interface RunnableWithLabel
    extends Runnable {
        public String getLabel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ERROR(SetupInstallerPlugin.getColor((int)249, (int)54, (int)50), AbstractSimpleDialog.COLOR_WHITE, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/close_message.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/close_message_hover.png")),
        SUCCESS(SetupInstallerPlugin.getColor((int)58, (int)195, (int)4), AbstractSimpleDialog.COLOR_WHITE, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/close_message.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/close_message_hover.png")),
        WARNING(SetupInstallerPlugin.getColor((int)240, (int)173, (int)78), AbstractSimpleDialog.COLOR_WHITE, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/close_message.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/close_message_hover.png"));

        public final Color backgroundColor;
        public final Color foregroundColor;
        public final Image closeImg;
        public final Image closeImgHover;

        private Type(Color backgroundColor, Color foregroundColor, Image closeImg, Image closeImgHover) {
            this.backgroundColor = backgroundColor;
            this.foregroundColor = foregroundColor;
            this.closeImg = closeImg;
            this.closeImgHover = closeImgHover;
        }
    }
}

