/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.ui.SelfCommitContext;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UICallback;
import org.eclipse.oomph.util.ExceptionHandler;
import org.eclipse.oomph.util.IRunnable;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfUpdate {
    public static final String SELF_HOSTING = "Self Hosting";

    public static String getProductVersion() {
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        Profile profile = agent.getCurrentProfile();
        if (profile == null || profile.isSelfHosting()) {
            return SELF_HOSTING;
        }
        String firstBuildID = null;
        int highestBuildID = 0;
        BundleContext bundleContext = SetupInstallerPlugin.INSTANCE.getBundleContext();
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            String buildID;
            Bundle bundle = bundleArray[n2];
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName.startsWith("org.eclipse.oomph") && (buildID = OomphPlugin.getBuildID((Bundle)bundle)) != null) {
                if (firstBuildID == null) {
                    firstBuildID = buildID;
                }
                try {
                    int id = Integer.parseInt(buildID);
                    if (id > highestBuildID) {
                        highestBuildID = id;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n2;
        }
        String buildID = highestBuildID != 0 ? Integer.toString(highestBuildID) : firstBuildID;
        Iterator iterator = P2Util.asIterable((IQueryResult)profile.query(QueryUtil.createIUQuery((String)"org.eclipse.oomph.setup.installer.product"), null)).iterator();
        if (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            Version version = iu.getVersion();
            String label = buildID != null && version.getSegmentCount() > 3 ? version.getSegment(0) + "." + version.getSegment(1) + "." + version.getSegment(2) : version.toString();
            if (buildID != null) {
                label = String.valueOf(label) + " Build " + buildID;
            }
            return label;
        }
        return null;
    }

    public static ProfileTransaction.Resolution resolve(User user, IProgressMonitor monitor) throws CoreException {
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        Profile profile = agent.getCurrentProfile();
        ProfileTransaction transaction = profile.change();
        SelfCommitContext commitContext = new SelfCommitContext(user);
        transaction = commitContext.migrateProfile(transaction);
        return transaction.resolve((ProfileTransaction.CommitContext)commitContext, monitor);
    }

    public static void update(Shell shell, final ProfileTransaction.Resolution resolution, final Runnable successRunnable, final ExceptionHandler<CoreException> exceptionHandler, final Runnable finalRunnable) {
        String shellText = shell.getText();
        if (!StringUtil.isEmpty((String)shellText)) {
            shellText = String.valueOf(shellText) + " ";
        }
        final UICallback callback = new UICallback(shell, String.valueOf(shellText) + "Update");
        callback.runInProgressDialog(false, new IRunnable(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                boolean originalBetterMirrorSelection = CachingRepositoryManager.enableBetterMirrorSelection();
                try {
                    try {
                        resolution.commit(monitor);
                        callback.execInUI(true, new Runnable(){

                            public void run() {
                                callback.information(false, "Updates were installed. Press OK to restart.");
                                if (successRunnable != null) {
                                    successRunnable.run();
                                }
                            }
                        });
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        CachingRepositoryManager.setBetterMirrorSelection((boolean)originalBetterMirrorSelection);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                    }
                    catch (CoreException ex) {
                        block12: {
                            if (exceptionHandler != null) {
                                exceptionHandler.handleException((Throwable)ex);
                                break block12;
                            }
                            ErrorDialog.open((Throwable)ex);
                        }
                        CachingRepositoryManager.setBetterMirrorSelection((boolean)originalBetterMirrorSelection);
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                    }
                }
                finally {
                    CachingRepositoryManager.setBetterMirrorSelection((boolean)originalBetterMirrorSelection);
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                }
            }
        });
    }
}

