/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.WorkbenchSettingsTransfer;

public class WorkbenchLayoutSettingsTransfer
extends WorkbenchSettingsTransfer {
    @Override
    public IStatus transferSettings(IPath newWorkspaceRoot) {
        try {
            File workbenchModel;
            IPath currentLocation = this.getNewWorkbenchStateLocation(Platform.getLocation());
            File workspaceFile = this.createFileAndDirectories(newWorkspaceRoot);
            if (workspaceFile == null) {
                return new Status(4, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.WorkbenchSettings_CouldNotCreateDirectories);
            }
            File deltas = new File(currentLocation.toOSString(), "deltas.xml");
            if (deltas.exists()) {
                byte[] bytes = new byte[8192];
                FileInputStream inputStream = new FileInputStream(deltas);
                FileOutputStream outputStream = new FileOutputStream(new File(workspaceFile, "deltas.xml"));
                int read = inputStream.read(bytes, 0, 8192);
                while (read != -1) {
                    outputStream.write(bytes, 0, read);
                    read = inputStream.read(bytes, 0, 8192);
                }
                inputStream.close();
                outputStream.close();
            }
            if ((workbenchModel = new File(currentLocation.toOSString(), "workbench.xmi")).exists()) {
                byte[] bytes = new byte[8192];
                FileInputStream inputStream = new FileInputStream(workbenchModel);
                FileOutputStream outputStream = new FileOutputStream(new File(workspaceFile, "workbench.xmi"));
                int read = inputStream.read(bytes, 0, 8192);
                while (read != -1) {
                    outputStream.write(bytes, 0, read);
                    read = inputStream.read(bytes, 0, 8192);
                }
                inputStream.close();
                outputStream.close();
            }
        }
        catch (IOException e) {
            return new Status(4, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.Workbench_problemsSavingMsg, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private File createFileAndDirectories(IPath newWorkspaceRoot) {
        IPath newWorkspaceLocation = this.getNewWorkbenchStateLocation(newWorkspaceRoot);
        File workspaceFile = new File(newWorkspaceLocation.toOSString());
        if (!workspaceFile.exists() && !workspaceFile.mkdirs()) {
            return null;
        }
        return workspaceFile;
    }

    @Override
    public String getName() {
        return WorkbenchMessages.WorkbenchLayoutSettings_Name;
    }

    @Override
    protected IPath getNewWorkbenchStateLocation(IPath newWorkspaceRoot) {
        return newWorkspaceRoot.append((IPath)new Path(".metadata/.plugins/org.eclipse.e4.workbench"));
    }
}

