/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.FileDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class WorkspaceUndoUtil {
    private static ObjectUndoContext tasksUndoContext;
    private static ObjectUndoContext bookmarksUndoContext;
    private static ObjectUndoContext problemsUndoContext;

    public static IUndoContext getWorkspaceUndoContext() {
        return WorkbenchPlugin.getDefault().getOperationSupport().getUndoContext();
    }

    public static IUndoContext getTasksUndoContext() {
        if (tasksUndoContext == null) {
            tasksUndoContext = new ObjectUndoContext(new Object(), "Tasks Context");
            tasksUndoContext.addMatch(WorkspaceUndoUtil.getWorkspaceUndoContext());
        }
        return tasksUndoContext;
    }

    public static IUndoContext getBookmarksUndoContext() {
        if (bookmarksUndoContext == null) {
            bookmarksUndoContext = new ObjectUndoContext(new Object(), "Bookmarks Context");
            bookmarksUndoContext.addMatch(WorkspaceUndoUtil.getWorkspaceUndoContext());
        }
        return bookmarksUndoContext;
    }

    public static IUndoContext getProblemsUndoContext() {
        if (problemsUndoContext == null) {
            problemsUndoContext = new ObjectUndoContext(new Object(), "Problems Context");
            problemsUndoContext.addMatch(WorkspaceUndoUtil.getWorkspaceUndoContext());
        }
        return problemsUndoContext;
    }

    public static IAdaptable getUIInfoAdapter(final Shell shell) {
        return new IAdaptable(){

            public <T> T getAdapter(Class<T> clazz) {
                if (clazz == Shell.class) {
                    return clazz.cast(shell);
                }
                return null;
            }
        };
    }

    private WorkspaceUndoUtil() {
    }

    static ResourceDescription[] delete(IResource[] resourcesToDelete, IProgressMonitor mon, IAdaptable uiInfo, boolean deleteContent) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)resourcesToDelete.length);
        ArrayList<CoreException> exceptions = new ArrayList<CoreException>();
        boolean forceOutOfSyncDelete = false;
        ResourceDescription[] returnedResourceDescriptions = new ResourceDescription[resourcesToDelete.length];
        subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_DeleteResourcesProgress);
        int i = 0;
        while (i < resourcesToDelete.length) {
            IResource resource = resourcesToDelete[i];
            try {
                returnedResourceDescriptions[i] = WorkspaceUndoUtil.delete(resource, (IProgressMonitor)subMonitor.split(1), uiInfo, forceOutOfSyncDelete, deleteContent);
            }
            catch (CoreException e) {
                if (resource.getType() == 1) {
                    IStatus[] children = e.getStatus().getChildren();
                    if (children.length == 1 && children[0].getCode() == 274) {
                        int result = WorkspaceUndoUtil.queryDeleteOutOfSync(resource, uiInfo);
                        if (result == 2) {
                            WorkspaceUndoUtil.delete(resource, (IProgressMonitor)subMonitor.split(1), uiInfo, true, deleteContent);
                        } else if (result == 4) {
                            forceOutOfSyncDelete = true;
                            WorkspaceUndoUtil.delete(resource, (IProgressMonitor)subMonitor.split(1), uiInfo, forceOutOfSyncDelete, deleteContent);
                        } else {
                            if (result == 1) {
                                throw new OperationCanceledException();
                            }
                            exceptions.add(e);
                        }
                    } else {
                        exceptions.add(e);
                    }
                }
                exceptions.add(e);
            }
            ++i;
        }
        IStatus result = WorkspaceUndoUtil.createResult(exceptions);
        if (!result.isOK()) {
            throw new CoreException(result);
        }
        return returnedResourceDescriptions;
    }

    static ResourceDescription[] copy(IResource[] resources, IPath destination, List<IResource> resourcesAtDestination, IProgressMonitor monitor, IAdaptable uiInfo, boolean pathIncludesName) throws CoreException {
        return WorkspaceUndoUtil.copy(resources, destination, resourcesAtDestination, monitor, uiInfo, pathIncludesName, false, false, null);
    }

    static ResourceDescription[] copy(IResource[] resources, IPath destination, List<IResource> resourcesAtDestination, IProgressMonitor monitor, IAdaptable uiInfo, boolean pathIncludesName, boolean createVirtual, boolean createLinks, String relativeToVariable) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)resources.length);
        subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        ArrayList<ResourceDescription> overwrittenResources = new ArrayList<ResourceDescription>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource[] members;
            IFolder folder;
            ResourceDescription[] deleted;
            IResource source = iResourceArray[n2];
            SubMonitor iterationProgress = subMonitor.split(1).setWorkRemaining(100);
            IPath destinationPath = pathIncludesName ? destination : destination.append(source.getName());
            IWorkspaceRoot workspaceRoot = WorkspaceUndoUtil.getWorkspaceRoot();
            IResource existing = workspaceRoot.findMember(destinationPath);
            if (source.getType() == 2 && existing != null) {
                if (source.isLinked() && existing.isLinked() || source.isVirtual() && existing.isVirtual() || !source.isLinked() && !existing.isLinked() && !source.isVirtual() && !existing.isVirtual()) {
                    IResource[] children = ((IContainer)source).members();
                    if (source.isLinked() && source.getLocation().equals((Object)existing.getLocation())) {
                        children = WorkspaceUndoUtil.filterNonLinkedResources(children);
                    }
                    ResourceDescription[] overwritten = WorkspaceUndoUtil.copy(children, destinationPath, resourcesAtDestination, (IProgressMonitor)iterationProgress, uiInfo, false, createVirtual, createLinks, relativeToVariable);
                    overwrittenResources.addAll(Arrays.asList(overwritten));
                } else {
                    deleted = WorkspaceUndoUtil.delete(new IResource[]{existing}, (IProgressMonitor)iterationProgress.split(1), uiInfo, false);
                    iterationProgress.setWorkRemaining(100);
                    if ((createLinks || createVirtual) && !source.isLinked() && !source.isVirtual()) {
                        folder = workspaceRoot.getFolder(destinationPath);
                        if (createVirtual) {
                            folder.create(8192, true, (IProgressMonitor)iterationProgress.split(1));
                            members = ((IContainer)source).members();
                            if (members.length > 0) {
                                overwrittenResources.addAll(Arrays.asList(WorkspaceUndoUtil.copy(members, destinationPath, resourcesAtDestination, (IProgressMonitor)iterationProgress.split(99), uiInfo, false, createVirtual, createLinks, relativeToVariable)));
                            }
                        } else {
                            folder.createLink(WorkspaceUndoUtil.createRelativePath(source.getLocationURI(), relativeToVariable, (IResource)folder), 0, (IProgressMonitor)iterationProgress.split(100));
                        }
                    } else {
                        source.copy(destinationPath, 32, (IProgressMonitor)iterationProgress.split(100));
                    }
                    resourcesAtDestination.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember(destinationPath));
                    overwrittenResources.addAll(Arrays.asList(deleted));
                }
            } else if (existing != null) {
                if ((createLinks || createVirtual) && !source.isLinked()) {
                    deleted = WorkspaceUndoUtil.delete(new IResource[]{existing}, (IProgressMonitor)iterationProgress.split(1), uiInfo, false);
                    iterationProgress.setWorkRemaining(100);
                    if (source.getType() == 1) {
                        IFile file = workspaceRoot.getFile(destinationPath);
                        file.createLink(WorkspaceUndoUtil.createRelativePath(source.getLocationURI(), relativeToVariable, (IResource)file), 0, (IProgressMonitor)iterationProgress.split(100));
                    } else {
                        folder = workspaceRoot.getFolder(destinationPath);
                        if (createVirtual) {
                            folder.create(8192, true, (IProgressMonitor)iterationProgress.split(1));
                            members = ((IContainer)source).members();
                            if (members.length > 0) {
                                overwrittenResources.addAll(Arrays.asList(WorkspaceUndoUtil.copy(members, destinationPath, resourcesAtDestination, (IProgressMonitor)iterationProgress.split(99), uiInfo, false, createVirtual, createLinks, relativeToVariable)));
                            }
                        } else {
                            folder.createLink(WorkspaceUndoUtil.createRelativePath(source.getLocationURI(), relativeToVariable, (IResource)folder), 0, (IProgressMonitor)iterationProgress.split(100));
                        }
                    }
                    resourcesAtDestination.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember(destinationPath));
                    overwrittenResources.addAll(Arrays.asList(deleted));
                } else if (source.isLinked() == existing.isLinked()) {
                    overwrittenResources.add(WorkspaceUndoUtil.copyOverExistingResource(source, existing, (IProgressMonitor)iterationProgress.split(100), uiInfo, false));
                    resourcesAtDestination.add(existing);
                } else {
                    deleted = WorkspaceUndoUtil.delete(new IResource[]{existing}, (IProgressMonitor)iterationProgress.split(1), uiInfo, false);
                    source.copy(destinationPath, 32, (IProgressMonitor)iterationProgress.split(99));
                    resourcesAtDestination.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember(destinationPath));
                    overwrittenResources.addAll(Arrays.asList(deleted));
                }
            } else {
                IPath parentPath = destination;
                if (pathIncludesName) {
                    parentPath = destination.removeLastSegments(1);
                }
                IContainer generatedParent = WorkspaceUndoUtil.generateContainers(parentPath);
                if ((createLinks || createVirtual) && !source.isLinked()) {
                    if (source.getType() == 1) {
                        IFile file = workspaceRoot.getFile(destinationPath);
                        file.createLink(WorkspaceUndoUtil.createRelativePath(source.getLocationURI(), relativeToVariable, (IResource)file), 0, (IProgressMonitor)iterationProgress.split(100));
                    } else {
                        IFolder folder2 = workspaceRoot.getFolder(destinationPath);
                        if (createVirtual) {
                            folder2.create(8192, true, (IProgressMonitor)iterationProgress.split(1));
                            IResource[] members2 = ((IContainer)source).members();
                            if (members2.length > 0) {
                                overwrittenResources.addAll(Arrays.asList(WorkspaceUndoUtil.copy(members2, destinationPath, resourcesAtDestination, (IProgressMonitor)iterationProgress.split(99), uiInfo, false, createVirtual, createLinks, relativeToVariable)));
                            }
                        } else {
                            folder2.createLink(WorkspaceUndoUtil.createRelativePath(source.getLocationURI(), relativeToVariable, (IResource)folder2), 0, (IProgressMonitor)iterationProgress.split(100));
                        }
                    }
                } else {
                    source.copy(destinationPath, 32, (IProgressMonitor)iterationProgress.split(100));
                }
                if (generatedParent == null) {
                    resourcesAtDestination.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember(destinationPath));
                } else {
                    resourcesAtDestination.add((IResource)generatedParent);
                }
            }
            ++n2;
        }
        return overwrittenResources.toArray(new ResourceDescription[overwrittenResources.size()]);
    }

    private static URI createRelativePath(URI locationURI, String relativeVariable, IResource resource) {
        IPath result;
        if (relativeVariable == null) {
            return locationURI;
        }
        IPath location = URIUtil.toPath((URI)locationURI);
        try {
            result = URIUtil.toPath((URI)resource.getPathVariableManager().convertToRelative(URIUtil.toURI((IPath)location), true, relativeVariable));
        }
        catch (CoreException coreException) {
            return locationURI;
        }
        return URIUtil.toURI((IPath)result);
    }

    static ResourceDescription[] move(IResource[] resources, IPath destination, List<IResource> resourcesAtDestination, List<IPath> reverseDestinations, IProgressMonitor mon, IAdaptable uiInfo, boolean pathIncludesName) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)resources.length);
        subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_MovingResources);
        ArrayList<ResourceDescription> overwrittenResources = new ArrayList<ResourceDescription>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceDescription[] deleted;
            IResource resource = iResourceArray[n2];
            SubMonitor iterationProgress = subMonitor.split(1);
            IPath destinationPath = pathIncludesName ? destination : destination.append(resource.getName());
            IWorkspaceRoot workspaceRoot = WorkspaceUndoUtil.getWorkspaceRoot();
            IResource existing = workspaceRoot.findMember(destinationPath);
            if (resource.getType() == 2 && existing != null) {
                if (resource.isLinked() == existing.isLinked()) {
                    IResource[] children = ((IContainer)resource).members();
                    if (resource.isLinked() && resource.getLocation().equals((Object)existing.getLocation())) {
                        children = WorkspaceUndoUtil.filterNonLinkedResources(children);
                    }
                    ResourceDescription[] overwritten = WorkspaceUndoUtil.move(children, destinationPath, resourcesAtDestination, reverseDestinations, (IProgressMonitor)iterationProgress.split(90), uiInfo, false);
                    overwrittenResources.addAll(Arrays.asList(overwritten));
                    WorkspaceUndoUtil.delete(resource, (IProgressMonitor)iterationProgress.split(10), uiInfo, false, false);
                } else {
                    deleted = WorkspaceUndoUtil.delete(new IResource[]{existing}, (IProgressMonitor)iterationProgress.split(10), uiInfo, false);
                    reverseDestinations.add(resource.getFullPath());
                    resource.move(destinationPath, 34, (IProgressMonitor)iterationProgress.split(90));
                    resourcesAtDestination.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember(destinationPath));
                    overwrittenResources.addAll(Arrays.asList(deleted));
                }
            } else if (existing != null) {
                if (resource.isLinked() == existing.isLinked()) {
                    reverseDestinations.add(resource.getFullPath());
                    overwrittenResources.add(WorkspaceUndoUtil.copyOverExistingResource(resource, existing, (IProgressMonitor)iterationProgress.split(100), uiInfo, true));
                    resourcesAtDestination.add(existing);
                } else {
                    deleted = WorkspaceUndoUtil.delete(new IResource[]{existing}, (IProgressMonitor)iterationProgress.split(1), uiInfo, false);
                    reverseDestinations.add(resource.getFullPath());
                    resource.move(destinationPath, 34, (IProgressMonitor)iterationProgress.split(99));
                    resourcesAtDestination.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember(destinationPath));
                    overwrittenResources.addAll(Arrays.asList(deleted));
                }
            } else {
                reverseDestinations.add(resource.getFullPath());
                IPath parentPath = destination;
                if (pathIncludesName) {
                    parentPath = destination.removeLastSegments(1);
                }
                IContainer generatedParent = WorkspaceUndoUtil.generateContainers(parentPath);
                resource.move(destinationPath, 34, (IProgressMonitor)iterationProgress.split(100));
                if (generatedParent == null) {
                    resourcesAtDestination.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember(destinationPath));
                } else {
                    resourcesAtDestination.add((IResource)generatedParent);
                }
            }
            ++n2;
        }
        return overwrittenResources.toArray(new ResourceDescription[overwrittenResources.size()]);
    }

    private static IResource[] filterNonLinkedResources(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.isLinked()) {
                result.add(resource);
            }
            ++n2;
        }
        return result.toArray(new IResource[0]);
    }

    static IResource[] recreate(ResourceDescription[] resourcesToRecreate, IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)resourcesToRecreate.length);
        ArrayList<CoreException> exceptions = new ArrayList<CoreException>();
        IResource[] resourcesToReturn = new IResource[resourcesToRecreate.length];
        subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CreateResourcesProgress);
        int i = 0;
        while (i < resourcesToRecreate.length) {
            try {
                resourcesToReturn[i] = resourcesToRecreate[i].createResource((IProgressMonitor)subMonitor.split(1));
            }
            catch (CoreException e) {
                exceptions.add(e);
            }
            ++i;
        }
        IStatus result = WorkspaceUndoUtil.createResult(exceptions);
        if (!result.isOK()) {
            throw new CoreException(result);
        }
        return resourcesToReturn;
    }

    static ResourceDescription delete(IResource resourceToDelete, IProgressMonitor monitor, IAdaptable uiInfo, boolean forceOutOfSyncDelete, boolean deleteContent) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        ResourceDescription resourceDescription = ResourceDescription.fromResource(resourceToDelete);
        if (resourceToDelete.getType() == 4) {
            subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_DeleteResourcesProgress);
            IProject project = (IProject)resourceToDelete;
            project.delete(deleteContent, forceOutOfSyncDelete, (IProgressMonitor)subMonitor);
        } else {
            subMonitor.setWorkRemaining(2);
            monitor.setTaskName(UndoMessages.AbstractResourcesOperation_DeleteResourcesProgress);
            int updateFlags = forceOutOfSyncDelete ? 3 : 2;
            resourceToDelete.delete(updateFlags, (IProgressMonitor)subMonitor.split(1));
            resourceDescription.recordStateFromHistory(resourceToDelete, (IProgressMonitor)subMonitor.split(1));
        }
        return resourceDescription;
    }

    private static ResourceDescription copyOverExistingResource(IResource source, IResource existing, IProgressMonitor monitor, IAdaptable uiInfo, boolean deleteSourceFile) throws CoreException {
        if (!(source instanceof IFile) || !(existing instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)source;
        IFile existingFile = (IFile)existing;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress, (int)(deleteSourceFile ? 3 : 2));
        if (file != null && WorkspaceUndoUtil.validateEdit(file, existingFile, WorkspaceUndoUtil.getShell(uiInfo))) {
            FileDescription fileDescription = new FileDescription(existingFile);
            existingFile.setContents(file.getContents(), 2, (IProgressMonitor)subMonitor.split(1));
            fileDescription.recordStateFromHistory((IResource)existingFile, (IProgressMonitor)subMonitor.split(1));
            if (deleteSourceFile) {
                file.delete(2, (IProgressMonitor)subMonitor.split(1));
            }
            return fileDescription;
        }
        return null;
    }

    private static IContainer generateContainers(IPath path) throws CoreException {
        if (path.segmentCount() == 0) {
            return null;
        }
        Object container = WorkspaceUndoUtil.getWorkspaceRoot().findMember(path);
        if (container != null) {
            return null;
        }
        container = path.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        ContainerDescription containerDescription = ContainerDescription.fromContainer((IContainer)container);
        container = containerDescription.createResourceHandle();
        containerDescription.createExistentResourceFromHandle((IResource)container, (IProgressMonitor)new NullProgressMonitor());
        return (IContainer)container;
    }

    private static int queryDeleteOutOfSync(IResource resource, IAdaptable uiInfo) {
        Shell shell = WorkspaceUndoUtil.getShell(uiInfo);
        MessageDialog dialog = new MessageDialog(shell, UndoMessages.AbstractResourcesOperation_deletionMessageTitle, null, NLS.bind((String)UndoMessages.AbstractResourcesOperation_outOfSyncQuestion, (Object)resource.getName()), 3, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        shell.getDisplay().syncExec(() -> ((MessageDialog)dialog).open());
        int result = dialog.getReturnCode();
        if (result == 0) {
            return 2;
        }
        if (result == 1) {
            return 4;
        }
        if (result == 2) {
            return 3;
        }
        return 1;
    }

    private static IStatus createResult(List<CoreException> exceptions) {
        if (exceptions.isEmpty()) {
            return Status.OK_STATUS;
        }
        int exceptionCount = exceptions.size();
        if (exceptionCount == 1) {
            return exceptions.get(0).getStatus();
        }
        CoreException[] children = exceptions.toArray(new CoreException[exceptionCount]);
        boolean outOfSync = false;
        CoreException[] coreExceptionArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            CoreException exception = coreExceptionArray[n2];
            if (exception.getStatus().getCode() == 274) {
                outOfSync = true;
                break;
            }
            ++n2;
        }
        String title = outOfSync ? UndoMessages.AbstractResourcesOperation_outOfSyncError : UndoMessages.AbstractResourcesOperation_deletionExceptionMessage;
        MultiStatus multi = new MultiStatus("org.eclipse.ui.ide", 0, title, null);
        int i = 0;
        while (i < exceptionCount) {
            CoreException exception = children[i];
            IStatus status = exception.getStatus();
            multi.add((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), (Throwable)exception));
            ++i;
        }
        return multi;
    }

    private static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return WorkspaceUndoUtil.getWorkspace().getRoot();
    }

    private static boolean validateEdit(IFile source, IFile destination, Shell shell) {
        if (destination.isReadOnly()) {
            IWorkspace workspace = WorkspaceUndoUtil.getWorkspace();
            IStatus status = source.isReadOnly() ? workspace.validateEdit(new IFile[]{source, destination}, (Object)shell) : workspace.validateEdit(new IFile[]{destination}, (Object)shell);
            return status.isOK();
        }
        return true;
    }

    public static Shell getShell(IAdaptable uiInfo) {
        Shell shell = (Shell)Adapters.adapt((Object)uiInfo, Shell.class);
        if (shell != null) {
            return shell;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

