/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.card;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.cnf.UnitClauses;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.UnitPropagationListener;

public class AtLeast
implements Propagatable,
Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int maxUnsatisfied;
    private int counter;
    protected final int[] lits;
    protected final ILits voc;

    public AtLeast(ILits voc, IVecInt ps, int degree) {
        this.maxUnsatisfied = ps.size() - degree;
        this.voc = voc;
        this.counter = 0;
        this.lits = new int[ps.size()];
        ps.moveTo(this.lits);
    }

    protected static int niceParameters(UnitPropagationListener s, ILits voc, IVecInt ps, int deg) throws ContradictionException {
        if (ps.size() < deg) {
            throw new ContradictionException();
        }
        int degree = deg;
        int i = 0;
        while (i < ps.size()) {
            if (voc.isUnassigned(ps.get(i))) {
                ++i;
                continue;
            }
            if (voc.isSatisfied(ps.get(i))) {
                --degree;
            }
            ps.delete(i);
        }
        ps.sortUnique();
        if (ps.size() == degree) {
            i = 0;
            while (i < ps.size()) {
                if (!s.enqueue(ps.get(i))) {
                    throw new ContradictionException();
                }
                ++i;
            }
            return 0;
        }
        if (ps.size() < degree) {
            throw new ContradictionException();
        }
        return degree;
    }

    public static Constr atLeastNew(UnitPropagationListener s, ILits voc, IVecInt ps, int n) throws ContradictionException {
        int degree = AtLeast.niceParameters(s, voc, ps, n);
        if (degree == 0) {
            return new UnitClauses(ps);
        }
        AtLeast constr = new AtLeast(voc, ps, degree);
        constr.register();
        return constr;
    }

    public void remove(UnitPropagationListener upl) {
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            this.voc.watches(q ^ 1).remove(this);
            ++n2;
        }
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        this.voc.watch(p, this);
        if (this.counter == this.maxUnsatisfied) {
            return false;
        }
        ++this.counter;
        this.voc.undos(p).push(this);
        if (this.counter == this.maxUnsatisfied) {
            int[] nArray = this.lits;
            int n = this.lits.length;
            int n2 = 0;
            while (n2 < n) {
                int q = nArray[n2];
                if (this.voc.isUnassigned(q) && !s.enqueue(q, this)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean simplify() {
        return false;
    }

    public void undo(int p) {
        --this.counter;
    }

    public void calcReason(int p, IVecInt outReason) {
        int c = p == -1 ? -1 : 0;
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            if (this.voc.isFalsified(q)) {
                outReason.push(q ^ 1);
                if (++c > this.maxUnsatisfied) {
                    return;
                }
            }
            ++n2;
        }
    }

    public boolean learnt() {
        return false;
    }

    public double getActivity() {
        return 0.0;
    }

    public void setActivity(double d) {
    }

    public void incActivity(double claInc) {
    }

    public boolean locked() {
        return true;
    }

    public void setLearnt() {
        throw new UnsupportedOperationException();
    }

    public void register() {
        this.counter = 0;
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            this.voc.watch(q ^ 1, this);
            if (this.voc.isFalsified(q)) {
                ++this.counter;
                this.voc.undos(q ^ 1).push(this);
            }
            ++n2;
        }
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int i) {
        return this.lits[i];
    }

    public void rescaleBy(double d) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener s) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraintIfNeeded(UnitPropagationListener s) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        stb.append("Card (" + this.lits.length + ") : ");
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int lit = nArray[n2];
            stb.append(" + ");
            stb.append(Lits.toString(lit));
            stb.append("[");
            stb.append(this.voc.valueToString(lit));
            stb.append("@");
            stb.append(this.voc.getLevel(lit));
            stb.append("]  ");
            ++n2;
        }
        stb.append(">= ");
        stb.append(this.size() - this.maxUnsatisfied);
        return stb.toString();
    }

    public void forwardActivity(double claInc) {
    }

    public boolean canBePropagatedMultipleTimes() {
        return true;
    }

    public Constr toConstraint() {
        return this;
    }

    public void calcReasonOnTheFly(int p, IVecInt trail, IVecInt outReason) {
        int c = p == -1 ? -1 : 0;
        VecInt vlits = new VecInt(this.lits);
        IteratorInt it = trail.iterator();
        while (it.hasNext()) {
            int q = it.next();
            if (!vlits.contains(q ^ 1)) continue;
            outReason.push(q);
            if (++c <= this.maxUnsatisfied) continue;
            return;
        }
    }
}

