/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public abstract class AbstractUIPlugin
extends Plugin {
    private static final String FN_DIALOG_SETTINGS = "dialog_settings.xml";
    private static final String KEY_DEFAULT_DIALOG_SETTINGS_ROOTURL = "default_dialog_settings_rootUrl";
    private IDialogSettings dialogSettings;
    private ScopedPreferenceStore preferenceStore;
    private ImageRegistry imageRegistry;
    private BundleListener bundleListener;

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    public IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.loadDialogSettings();
        }
        return this.dialogSettings;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.imageRegistry);
        }
        return this.imageRegistry;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }

    @Deprecated
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Deprecated
    protected void initializeDefaultPreferences(IPreferenceStore store) {
    }

    @Deprecated
    protected void initializeDefaultPluginPreferences() {
        this.loadPreferenceStore();
        this.initializeDefaultPreferences(this.getPreferenceStore());
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    protected void loadDialogSettings() {
        this.dialogSettings = this.createEmptySettings();
        boolean loaded = this.loadDialogSettingsFromWorkspace();
        if (!loaded) {
            loaded = this.loadDefaultDialogSettingsFromProduct();
        }
        if (!loaded) {
            this.loadDefaultDialogSettingsFromBundle();
        }
    }

    private boolean loadDefaultDialogSettingsFromProduct() {
        block18: {
            URL url;
            String rootUrl = PlatformUI.getPreferenceStore().getString(KEY_DEFAULT_DIALOG_SETTINGS_ROOTURL);
            if (rootUrl == null || rootUrl.isEmpty()) {
                return false;
            }
            String bundlePart = String.valueOf(this.getBundle().getSymbolicName()) + "/" + FN_DIALOG_SETTINGS;
            String fullUrl = rootUrl.endsWith("/") ? String.valueOf(rootUrl) + bundlePart : String.valueOf(rootUrl) + "/" + bundlePart;
            try {
                url = new URL(fullUrl);
            }
            catch (MalformedURLException e) {
                this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), "Failed to load dialog settings from: " + fullUrl, (Throwable)e));
                return false;
            }
            try {
                url = FileLocator.resolve((URL)url);
            }
            catch (IOException e2) {
                if (WorkbenchPlugin.DEBUG) {
                    this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), "Failed to load dialog settings from: " + fullUrl, (Throwable)e2));
                }
                return false;
            }
            Throwable e2 = null;
            Object var6_10 = null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            try {
                this.dialogSettings.load((Reader)reader);
                if (reader == null) break block18;
            }
            catch (Throwable e2) {
                try {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw e2;
                    }
                    catch (Throwable throwable) {
                        if (e2 == null) {
                            e2 = throwable;
                        } else if (e2 != throwable) {
                            e2.addSuppressed(throwable);
                        }
                        throw e2;
                    }
                }
                catch (IOException e3) {
                    this.dialogSettings = this.createEmptySettings();
                    this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), "Failed to load dialog settings from: " + url, (Throwable)e3));
                    return false;
                }
            }
            reader.close();
        }
        return true;
    }

    private boolean loadDialogSettingsFromWorkspace() {
        IPath dataLocation = this.getStateLocationOrNull();
        if (dataLocation == null) {
            return false;
        }
        String readWritePath = dataLocation.append(FN_DIALOG_SETTINGS).toOSString();
        File settingsFile = new File(readWritePath);
        if (settingsFile.exists()) {
            try {
                this.dialogSettings.load(readWritePath);
            }
            catch (IOException e) {
                this.dialogSettings = this.createEmptySettings();
                this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), "Failed to load dialog settings from: " + settingsFile, (Throwable)e));
            }
            return true;
        }
        return false;
    }

    private void loadDefaultDialogSettingsFromBundle() {
        Bundle bundle = this.getBundle();
        URL dsURL = BundleUtility.find(bundle, FN_DIALOG_SETTINGS);
        if (dsURL == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(dsURL.openStream(), StandardCharsets.UTF_8));){
                this.dialogSettings.load((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.getLog().log((IStatus)new Status(4, bundle.getSymbolicName(), "Failed to load dialog settings from: " + dsURL, (Throwable)e));
            this.dialogSettings = this.createEmptySettings();
        }
    }

    private DialogSettings createEmptySettings() {
        return new DialogSettings("Workbench");
    }

    @Deprecated
    protected void loadPreferenceStore() {
    }

    protected void refreshPluginActions() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Display.getDefault().asyncExec(() -> WWinPluginAction.refreshActionList());
    }

    protected void saveDialogSettings() {
        if (this.dialogSettings == null) {
            return;
        }
        try {
            IPath path = this.getStateLocationOrNull();
            if (path == null) {
                return;
            }
            String readWritePath = path.append(FN_DIALOG_SETTINGS).toOSString();
            this.dialogSettings.save(readWritePath);
        }
        catch (IOException | IllegalStateException exception) {}
    }

    @Deprecated
    protected void savePreferenceStore() {
        this.savePluginPreferences();
    }

    @Deprecated
    public void startup() throws CoreException {
        super.startup();
    }

    @Deprecated
    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final BundleContext fc = context;
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == AbstractUIPlugin.this.getBundle() && event.getType() == 2) {
                    if (AbstractUIPlugin.this.getBundle().getState() == 32) {
                        AbstractUIPlugin.this.refreshPluginActions();
                    }
                    try {
                        fc.removeBundleListener((BundleListener)this);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        };
        context.addBundleListener(this.bundleListener);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.bundleListener != null) {
                context.removeBundleListener(this.bundleListener);
            }
            this.saveDialogSettings();
            this.savePreferenceStore();
            this.preferenceStore = null;
            if (this.imageRegistry != null) {
                this.imageRegistry.dispose();
            }
            this.imageRegistry = null;
        }
        finally {
            super.stop(context);
        }
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String pluginId, String imageFilePath) {
        ImageDescriptor imageDescriptor;
        if (pluginId == null || imageFilePath == null) {
            throw new IllegalArgumentException();
        }
        IWorkbench workbench = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench() : null;
        ImageDescriptor imageDescriptor2 = imageDescriptor = workbench == null ? null : workbench.getSharedImages().getImageDescriptor(imageFilePath);
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (!BundleUtility.isReady(bundle)) {
            return null;
        }
        return ResourceLocator.imageDescriptorFromBundle((String)pluginId, (String)imageFilePath).orElse(null);
    }

    private IPath getStateLocationOrNull() {
        try {
            return this.getStateLocation();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }
}

