/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.touchpoint.natives.ClosedBackupStoreException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.osgi.util.NLS;

public class BackupStore
implements IBackupStore {
    private static final String BACKUP_FILE_EXTENSION = ".p2bu";
    private static final String ROOTCHAR = "_";
    private final File backupRoot;
    private final String backupName;
    private final String dummyName;
    private ServerSocket socket = null;
    private long backupCounter;
    private long restoreCounter;
    private boolean closed;
    private final Map<String, String> renamedInPlace = new HashMap<String, String>();
    private static long msCounter = 0L;

    public BackupStore() {
        this(null, BACKUP_FILE_EXTENSION);
    }

    public BackupStore(File buParentDirectory, String prefix) {
        if (buParentDirectory == null) {
            buParentDirectory = new File(System.getProperty("java.io.tmpdir"));
        }
        this.backupRoot = buParentDirectory;
        String unique = this.genUnique();
        this.dummyName = String.valueOf(prefix) + "d_" + unique;
        this.backupName = String.valueOf(prefix) + ROOTCHAR + unique;
        this.backupCounter = 0L;
        this.restoreCounter = 0L;
        this.closed = false;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getBackupName() {
        return this.backupName;
    }

    public File getBackupRoot() {
        return this.backupRoot;
    }

    @Override
    public boolean backup(File file) throws IOException {
        if (this.closed) {
            throw new ClosedBackupStoreException("Can not perform backup()");
        }
        if (!file.exists()) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_file_not_found, (Object)file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            return this.backupDirectory(file);
        }
        File buFile = this.getBackupFile(file = this.makeParentCanonical(file));
        if (buFile.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_directory_file_mismatch, (Object)buFile.getAbsolutePath()));
        }
        if (buFile.exists()) {
            if (file.exists() && !file.delete()) {
                throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_remove, (Object)file.getAbsolutePath()));
            }
            return false;
        }
        this.moveToBackup(file, buFile);
        return true;
    }

    protected void moveToBackup(File file, File buFile) throws IOException {
        buFile.getParentFile().mkdirs();
        if (buFile.getParentFile().exists() && !buFile.getParentFile().isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_file_directory_mismatch, (Object)buFile.getParentFile().getAbsolutePath()));
        }
        if (this.moveToBackupStore(file, buFile)) {
            ++this.backupCounter;
            return;
        }
        if (this.isEclipseExe(file)) {
            this.renameInPlace(file);
        } else {
            Util.copyStream(new FileInputStream(file), true, new FileOutputStream(buFile), true);
            ++this.backupCounter;
        }
        if (!file.delete() && file.exists()) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_delete_after_copy_0, (Object)file));
        }
    }

    private boolean isEclipseExe(File file) {
        String launcher = System.getProperty("eclipse.launcher");
        if (launcher != null) {
            String base = new File(launcher).getName();
            if (file.getName().equalsIgnoreCase(base)) {
                return true;
            }
        }
        return file.getName().equalsIgnoreCase("eclipse.exe") || file.getName().equalsIgnoreCase("eclipsec.exe");
    }

    protected boolean moveToBackupStore(File file, File buFile) {
        if (file.renameTo(buFile)) {
            if (file.exists()) {
                if (buFile.exists()) {
                    buFile.delete();
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected void renameInPlace(File file) {
        String newName = String.valueOf(file.getAbsolutePath()) + this.getTimeStamp() + BACKUP_FILE_EXTENSION;
        this.renamedInPlace.put(file.getAbsolutePath(), newName);
        file.renameTo(new File(newName));
    }

    protected String getTimeStamp() {
        return "-" + new Date().getTime();
    }

    private File getBackupFile(File file) {
        File buRoot = this.backupRoot;
        File buDir = new File(buRoot, this.backupName);
        File buFile = new File(buDir, this.makeRelativeFromRoot(file).getPath());
        return buFile;
    }

    @Override
    public void backupAll(File file) throws IOException {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if ((file = this.makeParentCanonical(file)).isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.backupAll(f);
                ++n2;
            }
        }
        this.backup(file);
    }

    @Override
    public void backupCopyAll(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if ((file = this.makeParentCanonical(file)).isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.backupCopyAll(f);
                    ++n2;
                }
            }
            if (files == null || files.length == 0) {
                this.backupDirectory(file);
                file.mkdir();
            }
        } else {
            this.backupCopy(file);
        }
    }

    @Override
    public boolean backupCopy(File file) throws IOException {
        if (this.closed) {
            throw new ClosedBackupStoreException(Messages.BackupStore_backupCopy_closed_store);
        }
        if (!file.exists()) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_file_not_found, (Object)file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_can_not_copy_directory, (Object)file.getAbsolutePath()));
        }
        File buDir = new File(this.backupRoot, this.backupName);
        File buFile = new File(buDir, this.makeRelativeFromRoot(file = this.makeParentCanonical(file)).getPath());
        if (buFile.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_directory_file_mismatch, (Object)buFile.getAbsolutePath()));
        }
        if (buFile.exists()) {
            return false;
        }
        buFile.getParentFile().getCanonicalFile().mkdirs();
        if (buFile.getParentFile().exists() && !buFile.getParentFile().isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_file_directory_mismatch, (Object)buFile.getParentFile().getAbsolutePath()));
        }
        Util.copyStream(new FileInputStream(file), true, new FileOutputStream(buFile), true);
        ++this.backupCounter;
        return true;
    }

    @Override
    public boolean backupDirectory(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_not_a_directory, (Object)file.getAbsolutePath()));
        }
        if ((file = this.makeParentCanonical(file)).list().length != 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_directory_not_empty, (Object)file.getAbsolutePath()));
        }
        File dummy = new File(file, this.dummyName);
        File buFile = this.getBackupFile(dummy = this.makeParentCanonical(dummy));
        boolean backedUp = buFile.exists();
        if (!backedUp) {
            if (this.closed) {
                throw new ClosedBackupStoreException("Can not perform backup()");
            }
            if (!dummy.createNewFile()) {
                throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_create_dummy, (Object)dummy.getAbsolutePath()));
            }
            this.moveToBackup(dummy, buFile);
        }
        if (!file.delete()) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_remove, (Object)dummy.getAbsolutePath()));
        }
        return !backedUp;
    }

    @Override
    public void restore() throws IOException {
        if (this.closed) {
            throw new ClosedBackupStoreException(Messages.BackupStore_restore_closed_store);
        }
        HashSet<File> unrestorable = new HashSet<File>();
        boolean restored = true;
        if (!this.backupRoot.exists()) {
            BackupStore.logError(NLS.bind((String)Messages.BackupStore_missing_backup_directory, (Object)this.backupRoot.getAbsolutePath()));
            restored = false;
        } else {
            this.restoreRoots(new File(this.backupRoot, this.backupName), unrestorable);
        }
        this.logUnrestorables(unrestorable);
        if (unrestorable.size() > 0) {
            restored = false;
        }
        this.close(restored);
        this.closed = true;
    }

    private void logUnrestorables(Set<File> unrestorable) {
        if (unrestorable != null && unrestorable.size() > 0) {
            for (File file : unrestorable) {
                BackupStore.logError(NLS.bind((String)Messages.BackupStore_manual_restore_needed, (Object)file.getAbsolutePath()));
            }
        }
    }

    @Override
    public void discard() {
        if (this.closed) {
            return;
        }
        this.closeSocket();
        this.removeBackups();
        this.closed = true;
    }

    private void close(boolean fullyRestored) throws IOException {
        this.closeSocket();
        if (this.backupCounter != this.restoreCounter) {
            if (!fullyRestored) {
                BackupStore.logError(NLS.bind((String)Messages.BackupStore_0_of_1_items_restored, (Object)this.restoreCounter, (Object)this.backupCounter));
            } else {
                BackupStore.logError(NLS.bind((String)Messages.BackupStore_externally_modified_0_of_1_restored, (Object)this.restoreCounter, (Object)this.backupCounter));
                fullyRestored = false;
            }
        }
        if (!fullyRestored) {
            throw new IOException(Messages.BackupStore_errors_while_restoring_see_log);
        }
        this.removeBackups();
    }

    private void closeSocket() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                BackupStore.logWarning(NLS.bind((String)Messages.BackupStore_can_not_close_tcp_port, (Object)this.socket.getLocalPort()));
            }
        }
    }

    private void removeBackups() {
        File buRoot = new File(this.backupRoot, this.backupName);
        if (!this.fullyDelete(buRoot)) {
            BackupStore.logWarning(NLS.bind((String)Messages.BackupStore_can_not_remove_bu_directory, (Object)buRoot.getAbsolutePath()));
        }
    }

    private static void logWarning(String message) {
        LogHelper.log((IStatus)BackupStore.createWarning(message));
    }

    private static IStatus createWarning(String message) {
        return new Status(2, "org.eclipse.equinox.p2.touchpoint.natives", message);
    }

    private static void logError(String message) {
        LogHelper.log((IStatus)BackupStore.createError(message));
    }

    private static IStatus createError(String message) {
        return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", message);
    }

    private boolean fullyDelete(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.fullyDelete(new File(file, child.getName()));
                ++n2;
            }
        }
        if (file.delete()) {
            return true;
        }
        return !file.exists();
    }

    /*
     * Unable to fully structure code
     */
    private void restore(File root, File buRoot, Set<File> unrestorable) {
        children = buRoot.listFiles();
        if (children == null) {
            unrestorable.add(buRoot);
            return;
        }
        var8_5 = children;
        var7_6 = children.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            block13: {
                block14: {
                    block15: {
                        child = var8_5[var6_7];
                        bu = new File(buRoot, child.getName());
                        target = new File(root, bu.getName());
                        if (!bu.isDirectory()) break block14;
                        if (target.exists() || target.mkdir()) break block15;
                        unrestorable.add(bu);
                        break block13;
                    }
                    if (!target.exists() || target.isDirectory()) ** GOTO lbl-1000
                    target.delete();
                    if (!target.mkdir()) {
                        unrestorable.add(bu);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.restore(target, bu, unrestorable);
                    }
                    break block13;
                }
                if (bu.getName().equals(this.dummyName)) {
                    ++this.restoreCounter;
                } else {
                    if (target.exists()) {
                        this.fullyDelete(target);
                    }
                    if (!bu.renameTo(target)) {
                        try {
                            Util.copyStream(new FileInputStream(bu), true, new FileOutputStream(target), true);
                            ++this.restoreCounter;
                        }
                        catch (FileNotFoundException v0) {
                            unrestorable.add(bu);
                            break block13;
                        }
                        catch (IOException v1) {
                            unrestorable.add(bu);
                            break block13;
                        }
                        if (!bu.delete()) {
                            BackupStore.logWarning(NLS.bind((String)Messages.BackupStore_can_not_delete_tmp_file, (Object)bu.getAbsolutePath()));
                        }
                    } else {
                        ++this.restoreCounter;
                    }
                }
            }
            ++var6_7;
        }
    }

    private void restoreRoots(File buRoot, Set<File> unrestorable) {
        File[] children = buRoot.listFiles();
        if (children == null) {
            unrestorable.add(buRoot);
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            File child = fileArray[n2];
            String rName = name = child.getName();
            String prefix = "";
            while (rName.startsWith(ROOTCHAR)) {
                prefix = String.valueOf(prefix) + File.separator;
                rName = rName.substring(1);
            }
            rName = prefix.length() < 1 ? String.valueOf(rName) + ":" + File.separator : String.valueOf(prefix) + rName;
            File bu = new File(buRoot, name);
            File target = new File(rName);
            if (!bu.isDirectory()) {
                unrestorable.add(bu);
            } else if (!target.exists() || !target.isDirectory()) {
                unrestorable.add(bu);
            } else {
                this.restore(target, bu, unrestorable);
            }
            ++n2;
        }
        this.restoreRenamedFiles(unrestorable);
    }

    private void restoreRenamedFiles(Set<File> unrestorable) {
        for (Map.Entry<String, String> entry : this.renamedInPlace.entrySet()) {
            File bu = new File(entry.getValue());
            if (bu.renameTo(new File(entry.getKey()))) continue;
            unrestorable.add(bu);
        }
    }

    private String genUnique() {
        long timePart = System.currentTimeMillis() << 5 | msCounter++ & 0x1FL;
        long ipPart = 0L;
        try {
            byte[] address = InetAddress.getLocalHost().getAddress();
            int i = 0;
            while (i < address.length) {
                ipPart = ipPart << 8 | (long)(address[i] & 0xFF);
                ++i;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        int port = 0;
        try {
            this.socket = new ServerSocket(0, 1, InetAddress.getByName("127.0.0.1"));
            port = this.socket.getLocalPort();
        }
        catch (IOException iOException) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException2) {}
            port = new Random().nextInt() & 0xFFFF;
        }
        long aPart = ipPart << 16 | (long)(port & 0xFFFF);
        return String.valueOf(Long.toHexString(timePart)) + ROOTCHAR + Long.toHexString(aPart);
    }

    private File makeRelativeFromRoot(File file) {
        File absolute = file.getAbsoluteFile();
        String path = absolute.getPath();
        String prefix = "";
        while (path.startsWith(File.separator)) {
            prefix = String.valueOf(prefix) + ROOTCHAR;
            path = path.substring(1);
        }
        if (prefix.length() > 0) {
            path = String.valueOf(prefix) + File.separator + path;
            return new File(path);
        }
        int idx = path.indexOf(":");
        if (idx < 1) {
            throw new InternalError("File is neither absolute nor has a drive name: " + path);
        }
        path = String.valueOf(path.substring(0, idx)) + path.substring(idx + 1);
        return new File(path);
    }

    private File makeParentCanonical(File file) throws IOException {
        return new File(file.getParentFile().getCanonicalFile(), file.getName());
    }
}

