/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.progress.ProgressMonitorFocusJobDialog;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ProjectConfiguratorExtensionManager;
import org.eclipse.ui.internal.wizards.datatransfer.RecursiveImportListener;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportJob;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportWizard;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class SmartImportJobReportDialog
extends ProgressMonitorFocusJobDialog {
    private SmartImportJob job;

    public SmartImportJobReportDialog(Shell shell) {
        super(shell);
        this.setShellStyle(144);
    }

    public Composite createDialogArea(Composite parent) {
        this.getShell().setText(DataTransferMessages.SmartImportReport_importedProjects);
        final Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(2, false));
        res.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        final Label nestedProjectsLabel = new Label(res, 0);
        nestedProjectsLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        nestedProjectsLabel.setText(NLS.bind((String)DataTransferMessages.SmartImportReport_importedProjectsWithCount, (Object)0));
        final TableViewer nestedProjectsTable = new TableViewer(res);
        nestedProjectsTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        nestedProjectsTable.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                IProject project1 = (IProject)((Map.Entry)o1).getKey();
                IProject project2 = (IProject)((Map.Entry)o2).getKey();
                return this.toString(project1).compareTo(this.toString(project2));
            }

            private String toString(IProject p) {
                IPath location = p.getLocation();
                return location == null ? "" : location.toString();
            }
        });
        nestedProjectsTable.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Map.Entry entry = (Map.Entry)element;
                return SmartImportWizard.toAbsolutePath(entry.getKey()).startsWith(SmartImportJobReportDialog.this.job.getRoot().getAbsolutePath());
            }
        }});
        nestedProjectsTable.getTable().setHeaderVisible(true);
        GridData tableLayoutData = new GridData(4, 4, true, true, 2, 1);
        tableLayoutData.heightHint = 200;
        nestedProjectsTable.getControl().setLayoutData((Object)tableLayoutData);
        TableViewerColumn projectColumn = new TableViewerColumn(nestedProjectsTable, 2816);
        projectColumn.getColumn().setWidth(200);
        projectColumn.getColumn().setText(DataTransferMessages.SmartImportReport_project);
        projectColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IProject)((Map.Entry)element).getKey()).getName();
            }
        });
        TableViewerColumn configuratorsColumn = new TableViewerColumn(nestedProjectsTable, 0);
        configuratorsColumn.getColumn().setWidth(200);
        configuratorsColumn.getColumn().setText(DataTransferMessages.SmartImportReport_natures);
        configuratorsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                StringBuilder builder = new StringBuilder();
                for (ProjectConfigurator configurator : (List)((Map.Entry)element).getValue()) {
                    builder.append(ProjectConfiguratorExtensionManager.getLabel(configurator));
                    builder.append(", ");
                }
                if (builder.length() > 0) {
                    builder.delete(builder.length() - 2, builder.length());
                }
                return builder.toString();
            }
        });
        TableViewerColumn relativePathColumn = new TableViewerColumn(nestedProjectsTable, 16384);
        relativePathColumn.getColumn().setText(DataTransferMessages.SmartImportReport_relativePath);
        relativePathColumn.getColumn().setWidth(300);
        relativePathColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IProject project = (IProject)((Map.Entry)element).getKey();
                IPath projectLocation = project.getLocation();
                if (projectLocation == null) {
                    return "?";
                }
                return projectLocation.toFile().getAbsolutePath().substring(SmartImportJobReportDialog.this.job.getRoot().getAbsolutePath().length());
            }
        });
        nestedProjectsTable.setInput(this.job.getConfiguredProjects().entrySet());
        final Label errorsLabel = new Label(res, 0);
        GridData errorLabelLayoutData = new GridData(4, 0, true, false, 2, 1);
        errorLabelLayoutData.exclude = true;
        errorsLabel.setLayoutData((Object)errorLabelLayoutData);
        errorsLabel.setText(NLS.bind((String)DataTransferMessages.SmartImportReport_importErrors, (Object)0));
        final TableViewer errorsTable = new TableViewer(res);
        errorsTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        errorsTable.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                IPath location1 = (IPath)((Map.Entry)o1).getKey();
                IPath location2 = (IPath)((Map.Entry)o2).getKey();
                return location1.toString().compareTo(location2.toString());
            }
        });
        errorsTable.getTable().setHeaderVisible(true);
        GridData errorTableLayoutData = new GridData(4, 4, true, true, 2, 1);
        errorTableLayoutData.heightHint = 100;
        errorTableLayoutData.exclude = true;
        errorsTable.getControl().setLayoutData((Object)errorTableLayoutData);
        TableViewerColumn errorRelativePathColumn = new TableViewerColumn(errorsTable, 16384);
        errorRelativePathColumn.getColumn().setText(DataTransferMessages.SmartImportReport_relativePath);
        errorRelativePathColumn.getColumn().setWidth(300);
        errorRelativePathColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Path rootLocation = new Path(SmartImportJobReportDialog.this.job.getRoot().getAbsolutePath());
                IPath projectLocation = (IPath)((Map.Entry)element).getKey();
                return projectLocation.makeRelativeTo((IPath)rootLocation).toString();
            }
        });
        TableViewerColumn errorColumn = new TableViewerColumn(errorsTable, 16384);
        errorColumn.getColumn().setText(DataTransferMessages.SmartImportReport_error);
        errorColumn.getColumn().setWidth(500);
        errorColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Exception)((Map.Entry)element).getValue()).getMessage();
            }
        });
        errorsTable.setInput(this.job.getErrors().entrySet());
        RecursiveImportListener tableReportFiller = new RecursiveImportListener(){

            @Override
            public void projectCreated(IProject project) {
                if (nestedProjectsTable.getControl().isDisposed()) {
                    return;
                }
                nestedProjectsTable.getControl().getDisplay().asyncExec(() -> {
                    if (nestedProjectsTable.getControl().isDisposed()) {
                        return;
                    }
                    nestedProjectsTable.refresh();
                    nestedProjectsTable.getTable().update();
                    nestedProjectsTable.getTable().redraw();
                    nestedProjectsLabel.setText(NLS.bind((String)DataTransferMessages.SmartImportReport_importedProjects, (Object)SmartImportJobReportDialog.this.job.getConfiguredProjects().size()));
                });
            }

            @Override
            public void projectConfigured(IProject project, ProjectConfigurator configurator) {
                if (nestedProjectsTable.getControl().isDisposed()) {
                    return;
                }
                nestedProjectsTable.getControl().getDisplay().asyncExec(() -> {
                    if (nestedProjectsTable.getControl().isDisposed()) {
                        return;
                    }
                    nestedProjectsTable.refresh();
                    nestedProjectsTable.getTable().update();
                    nestedProjectsTable.getTable().redraw();
                });
            }

            @Override
            public void errorHappened(IPath location, Exception error) {
                if (errorsTable.getControl().isDisposed()) {
                    return;
                }
                errorsTable.getControl().getDisplay().asyncExec(() -> {
                    if (errorsTable.getControl().isDisposed()) {
                        return;
                    }
                    GridData gridData = (GridData)errorsTable.getControl().getLayoutData();
                    if (gridData.exclude) {
                        gridData.exclude = false;
                        ((GridData)label.getLayoutData()).exclude = false;
                    }
                    errorsTable.refresh();
                    errorsTable.getTable().update();
                    errorsLabel.setText(NLS.bind((String)DataTransferMessages.SmartImportReport_importErrors, (Object)SmartImportJobReportDialog.this.job.getErrors().size()));
                    res.layout(true);
                });
            }
        };
        this.job.setListener(tableReportFiller);
        super.createDialogArea(parent);
        return res;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.cancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancel.setCursor(this.arrowCursor);
        this.createDetailsButton(parent);
    }

    public void show(Job jobToWatch, Shell shell) {
        if (!(jobToWatch instanceof SmartImportJob)) {
            throw new IllegalArgumentException("Job must be an instance of " + SmartImportJob.class.getSimpleName());
        }
        this.job = (SmartImportJob)jobToWatch;
        super.show((Job)this.job, shell);
    }

    public Image getImage() {
        return null;
    }
}

