/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.targlets.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.log.ProgressLogMonitor;
import org.eclipse.oomph.setup.targlets.SetupTargletsPackage;
import org.eclipse.oomph.setup.targlets.TargletTask;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.internal.core.TargletContainer;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.WorkspaceIUImporter;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.pde.TargetPlatformRunnable;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargletTaskImpl
extends SetupTaskImpl
implements TargletTask {
    private static final String TARGET_DEFINITION_NAME = "Modular Target";
    private static final String TARGLET_CONTAINER_ID = "Oomph";
    protected EList<Targlet> targlets;
    protected EList<String> targletURIs;
    protected static final String OPERATING_SYSTEM_EDEFAULT = null;
    protected String operatingSystem = OPERATING_SYSTEM_EDEFAULT;
    protected static final String WINDOWING_SYSTEM_EDEFAULT = null;
    protected String windowingSystem = WINDOWING_SYSTEM_EDEFAULT;
    protected static final String ARCHITECTURE_EDEFAULT = null;
    protected String architecture = ARCHITECTURE_EDEFAULT;
    protected static final String LOCALE_EDEFAULT = null;
    protected String locale = LOCALE_EDEFAULT;
    private ITargletContainer targletContainer;
    private ITargetDefinition targetDefinition;
    private EList<Targlet> copyTarglets;

    protected TargletTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupTargletsPackage.Literals.TARGLET_TASK;
    }

    @Override
    public EList<Targlet> getTarglets() {
        if (this.targlets == null) {
            this.targlets = new EObjectContainmentEList(Targlet.class, (InternalEObject)this, 9);
        }
        return this.targlets;
    }

    @Override
    public EList<String> getTargletURIs() {
        if (this.targletURIs == null) {
            this.targletURIs = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 10);
        }
        return this.targletURIs;
    }

    @Override
    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public void setOperatingSystem(String newOperatingSystem) {
        String oldOperatingSystem = this.operatingSystem;
        this.operatingSystem = newOperatingSystem;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldOperatingSystem, (Object)this.operatingSystem));
        }
    }

    @Override
    public String getWindowingSystem() {
        return this.windowingSystem;
    }

    @Override
    public void setWindowingSystem(String newWindowingSystem) {
        String oldWindowingSystem = this.windowingSystem;
        this.windowingSystem = newWindowingSystem;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldWindowingSystem, (Object)this.windowingSystem));
        }
    }

    @Override
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public void setArchitecture(String newArchitecture) {
        String oldArchitecture = this.architecture;
        this.architecture = newArchitecture;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldArchitecture, (Object)this.architecture));
        }
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String newLocale) {
        String oldLocale = this.locale;
        this.locale = newLocale;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldLocale, (Object)this.locale));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getTarglets()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getTarglets();
            }
            case 10: {
                return this.getTargletURIs();
            }
            case 11: {
                return this.getOperatingSystem();
            }
            case 12: {
                return this.getWindowingSystem();
            }
            case 13: {
                return this.getArchitecture();
            }
            case 14: {
                return this.getLocale();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.getTarglets().clear();
                this.getTarglets().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getTargletURIs().clear();
                this.getTargletURIs().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setOperatingSystem((String)newValue);
                return;
            }
            case 12: {
                this.setWindowingSystem((String)newValue);
                return;
            }
            case 13: {
                this.setArchitecture((String)newValue);
                return;
            }
            case 14: {
                this.setLocale((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.getTarglets().clear();
                return;
            }
            case 10: {
                this.getTargletURIs().clear();
                return;
            }
            case 11: {
                this.setOperatingSystem(OPERATING_SYSTEM_EDEFAULT);
                return;
            }
            case 12: {
                this.setWindowingSystem(WINDOWING_SYSTEM_EDEFAULT);
                return;
            }
            case 13: {
                this.setArchitecture(ARCHITECTURE_EDEFAULT);
                return;
            }
            case 14: {
                this.setLocale(LOCALE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.targlets != null && !this.targlets.isEmpty();
            }
            case 10: {
                return this.targletURIs != null && !this.targletURIs.isEmpty();
            }
            case 11: {
                return OPERATING_SYSTEM_EDEFAULT == null ? this.operatingSystem != null : !OPERATING_SYSTEM_EDEFAULT.equals(this.operatingSystem);
            }
            case 12: {
                return WINDOWING_SYSTEM_EDEFAULT == null ? this.windowingSystem != null : !WINDOWING_SYSTEM_EDEFAULT.equals(this.windowingSystem);
            }
            case 13: {
                return ARCHITECTURE_EDEFAULT == null ? this.architecture != null : !ARCHITECTURE_EDEFAULT.equals(this.architecture);
            }
            case 14: {
                return LOCALE_EDEFAULT == null ? this.locale != null : !LOCALE_EDEFAULT.equals(this.locale);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (targletURIs: ");
        result.append(this.targletURIs);
        result.append(", operatingSystem: ");
        result.append(this.operatingSystem);
        result.append(", windowingSystem: ");
        result.append(this.windowingSystem);
        result.append(", architecture: ");
        result.append(this.architecture);
        result.append(", locale: ");
        result.append(this.locale);
        result.append(')');
        return result.toString();
    }

    public Object getOverrideToken() {
        return this.createToken(TARGLET_CONTAINER_ID);
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        TargletTask targletTask = (TargletTask)overriddenSetupTask;
        this.getTarglets().addAll(targletTask.getTarglets());
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__OPERATING_SYSTEM, "operating systems");
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__WINDOWING_SYSTEM, "windowing systems");
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__ARCHITECTURE, "architectures");
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__LOCALE, "locales");
    }

    private void mergeSetting(TargletTask overriddenTargletTask, EAttribute attribute, String errorLabel) {
        String overriddenValue;
        String overridingValue = (String)this.eGet((EStructuralFeature)attribute);
        if (!ObjectUtil.equals((Object)overridingValue, (Object)(overriddenValue = (String)overriddenTargletTask.eGet((EStructuralFeature)attribute)))) {
            if (overridingValue == null) {
                this.eSet((EStructuralFeature)attribute, overriddenValue);
            } else if (overriddenValue != null) {
                this.getAnnotations().add((Object)BaseFactory.eINSTANCE.createErrorAnnotation("The " + errorLabel + " '" + overriddenValue + "' and '" + overridingValue + "' collide."));
            }
        }
    }

    public void consolidate() {
        super.consolidate();
        HashSet<String> targletNames = new HashSet<String>();
        Iterator it = this.getTarglets().iterator();
        block0: while (it.hasNext()) {
            Targlet targlet = (Targlet)it.next();
            String name = targlet.getName();
            if (StringUtil.isEmpty((String)name) || !targletNames.add(name)) {
                it.remove();
                continue;
            }
            if (!targlet.getRequirements().isEmpty() || !targlet.getSourceLocators().isEmpty()) continue;
            String activeRepositoryList = targlet.getActiveRepositoryListName();
            for (RepositoryList repositoryList : targlet.getRepositoryLists()) {
                if (!ObjectUtil.equals((Object)activeRepositoryList, (Object)repositoryList.getName()) || !repositoryList.getRepositories().isEmpty()) continue;
                it.remove();
                continue block0;
            }
        }
    }

    public boolean isNeeded(final SetupTaskContext context) throws Exception {
        this.copyTarglets = TargletFactory.eINSTANCE.copyTarglets(this.getTarglets());
        return (Boolean)TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Boolean>(){

            public Boolean run(ITargetPlatformService service) throws CoreException {
                ITargetHandle activeTargetHandle = service.getWorkspaceTargetHandle();
                TargletTaskImpl.this.targetDefinition = TargletTaskImpl.this.getTargetDefinition(context, service);
                if (TargletTaskImpl.this.targetDefinition == null) {
                    return this.hasRequirements((EList<Targlet>)TargletTaskImpl.this.copyTarglets);
                }
                TargletTaskImpl.this.targletContainer = TargletTaskImpl.this.getTargletContainer();
                if (TargletTaskImpl.this.targletContainer == null) {
                    return this.hasRequirements((EList<Targlet>)TargletTaskImpl.this.copyTarglets);
                }
                if (!this.hasRequirements((EList<Targlet>)TargletTaskImpl.this.copyTarglets) && !this.hasRequirements((EList<Targlet>)TargletTaskImpl.this.targletContainer.getTarglets())) {
                    return false;
                }
                for (Targlet targlet : TargletTaskImpl.this.copyTarglets) {
                    Targlet existingTarglet = TargletTaskImpl.this.targletContainer.getTarglet(targlet.getName());
                    if (existingTarglet != null && EcoreUtil.equals((EObject)existingTarglet, (EObject)targlet)) continue;
                    return true;
                }
                if (context.getTrigger() == Trigger.MANUAL) {
                    return true;
                }
                boolean targetNeedsActivation = true;
                if (TargletTaskImpl.this.targetDefinition.getHandle().equals(activeTargetHandle)) {
                    targetNeedsActivation = false;
                }
                boolean environmentNeedsUpdate = true;
                if (ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getOS(), (Object)TargletTaskImpl.this.getOperatingSystem()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getWS(), (Object)TargletTaskImpl.this.getWindowingSystem()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getArch(), (Object)TargletTaskImpl.this.getArchitecture()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getNL(), (Object)TargletTaskImpl.this.getLocale())) {
                    environmentNeedsUpdate = false;
                }
                if (!targetNeedsActivation && !environmentNeedsUpdate) {
                    return false;
                }
                return true;
            }

            private boolean hasRequirements(EList<Targlet> targlets) {
                for (Targlet targlet : targlets) {
                    if (targlet.getRequirements().isEmpty()) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public void perform(final SetupTaskContext context) throws Exception {
        for (Targlet targlet : this.copyTarglets) {
            for (Repository p2Repository : targlet.getActiveRepositories()) {
                context.log("Using " + p2Repository.getURL());
            }
        }
        TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Object>(){

            public Object run(ITargetPlatformService service) throws CoreException {
                EList targlets;
                if (TargletTaskImpl.this.targetDefinition == null) {
                    TargletTaskImpl.this.targetDefinition = TargletTaskImpl.this.getTargetDefinition(context, service);
                }
                if (TargletTaskImpl.this.targetDefinition == null) {
                    TargletTaskImpl.this.targetDefinition = service.newTarget();
                    TargletTaskImpl.this.targetDefinition.setName(TargletTaskImpl.TARGET_DEFINITION_NAME);
                }
                TargletTaskImpl.this.targetDefinition.setOS(TargletTaskImpl.this.getOperatingSystem());
                TargletTaskImpl.this.targetDefinition.setWS(TargletTaskImpl.this.getWindowingSystem());
                TargletTaskImpl.this.targetDefinition.setArch(TargletTaskImpl.this.getArchitecture());
                TargletTaskImpl.this.targetDefinition.setNL(TargletTaskImpl.this.getLocale());
                if (TargletTaskImpl.this.targletContainer == null) {
                    TargletTaskImpl.this.targletContainer = TargletTaskImpl.this.getTargletContainer();
                }
                if (TargletTaskImpl.this.targletContainer == null) {
                    ITargetLocation[] newLocations;
                    TargletTaskImpl.this.targletContainer = (ITargletContainer)new TargletContainer(TargletTaskImpl.TARGLET_CONTAINER_ID);
                    ITargetLocation[] oldLocations = TargletTaskImpl.this.targetDefinition.getTargetLocations();
                    if (oldLocations != null && oldLocations.length != 0) {
                        newLocations = new ITargetLocation[oldLocations.length + 1];
                        System.arraycopy(oldLocations, 0, newLocations, 0, oldLocations.length);
                        newLocations[oldLocations.length] = TargletTaskImpl.this.targletContainer;
                    } else {
                        newLocations = new ITargetLocation[]{TargletTaskImpl.this.targletContainer};
                    }
                    TargletTaskImpl.this.targetDefinition.setTargetLocations(newLocations);
                    targlets = TargletTaskImpl.this.copyTarglets;
                } else {
                    targlets = TargletTaskImpl.this.targletContainer.getTarglets();
                    for (Targlet targlet : TargletTaskImpl.this.copyTarglets) {
                        int index = TargletTaskImpl.this.targletContainer.getTargletIndex(targlet.getName());
                        if (index != -1) {
                            targlets.set(index, (Object)targlet);
                            continue;
                        }
                        targlets.add((Object)targlet);
                    }
                }
                ProgressLogMonitor monitor = new ProgressLogMonitor((ProgressLog)context);
                boolean mirrors = context.isMirrors();
                TargletTaskImpl.this.targletContainer.setTarglets((Collection)targlets);
                TargletTaskImpl.this.targletContainer.forceUpdate(true, mirrors, (IProgressMonitor)monitor);
                try {
                    Job.getJobManager().join(WorkspaceIUImporter.WORKSPACE_IU_IMPORT_FAMILY, (IProgressMonitor)monitor);
                }
                catch (InterruptedException ex) {
                    TargletsCorePlugin.INSTANCE.coreException((Throwable)ex);
                }
                return null;
            }
        });
    }

    private ITargetDefinition getTargetDefinition(SetupTaskContext context, ITargetPlatformService service) throws CoreException {
        ITargetHandle[] iTargetHandleArray = service.getTargets((IProgressMonitor)new ProgressLogMonitor((ProgressLog)context));
        int n = iTargetHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetHandle targetHandle = iTargetHandleArray[n2];
            ITargetDefinition targetDefinition = targetHandle.getTargetDefinition();
            if (TARGET_DEFINITION_NAME.equals(targetDefinition.getName())) {
                return targetDefinition;
            }
            ++n2;
        }
        return null;
    }

    private ITargletContainer getTargletContainer() {
        ITargetLocation[] locations = this.targetDefinition.getTargetLocations();
        if (locations != null) {
            ITargetLocation[] iTargetLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargletContainer targletContainer;
                ITargetLocation location = iTargetLocationArray[n2];
                if (location instanceof ITargletContainer && TARGLET_CONTAINER_ID.equals((targletContainer = (ITargletContainer)location).getID())) {
                    return targletContainer;
                }
                ++n2;
            }
        }
        return null;
    }
}

