/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.P2Package;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementItemProvider
extends ModelElementItemProvider {
    public static final String NAMESPACE_PACKAGE_ID = "java.package";
    private static final String FEATURE_SUFFIX = ".feature.group";

    public RequirementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addNamespacePropertyDescriptor(object);
            this.addVersionRangePropertyDescriptor(object);
            this.addOptionalPropertyDescriptor(object);
            this.addFeaturePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_name_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamespacePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_namespace_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_namespace_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__NAMESPACE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addVersionRangePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_versionRange_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_versionRange_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__VERSION_RANGE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addOptionalPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_optional_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_optional_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__OPTIONAL, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addFeaturePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_feature_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_feature_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__FEATURE, false, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected Collection<?> filterAlternatives(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> alternatives) {
        return super.filterAlternatives(domain, owner, location, operations, operation, RequirementItemProvider.filterAlternatives(alternatives));
    }

    public static Collection<?> filterAlternatives(Collection<?> alternatives) {
        ArrayList result = new ArrayList();
        for (Object object : alternatives) {
            if (object instanceof Requirement) {
                Version minimum;
                Requirement requirement = (Requirement)object;
                String namespace = requirement.getNamespace();
                if ("osgi.bundle".equals(namespace)) {
                    requirement.setNamespace("org.eclipse.equinox.p2.iu");
                } else if (!"org.eclipse.equinox.p2.iu".equals(namespace) && !NAMESPACE_PACKAGE_ID.equals(namespace)) continue;
                VersionRange versionRange = requirement.getVersionRange();
                if (versionRange != null && (minimum = versionRange.getMinimum()).toString().endsWith(".qualifier")) {
                    VersionRange minimumVersionRange = P2Factory.eINSTANCE.createVersionRange(minimum, VersionSegment.MICRO);
                    requirement.setVersionRange(minimumVersionRange);
                }
            }
            result.add(object);
        }
        return result;
    }

    protected Collection<?> filterChoices(Collection<?> choices, EStructuralFeature feature, Object object) {
        if (feature == P2Package.Literals.REQUIREMENT__NAMESPACE) {
            return Arrays.asList("org.eclipse.equinox.p2.iu", NAMESPACE_PACKAGE_ID);
        }
        return super.filterChoices(choices, feature, object);
    }

    public Object getImage(Object object) {
        String key = "full/obj16/Requirement";
        Requirement requirement = (Requirement)object;
        String namespace = requirement.getNamespace();
        if ("org.eclipse.equinox.p2.iu".equals(namespace)) {
            key = requirement.isFeature() ? String.valueOf(key) + "_Feature" : String.valueOf(key) + "_Plugin";
        } else if (NAMESPACE_PACKAGE_ID.equals(namespace)) {
            key = String.valueOf(key) + "_Package";
        }
        if (requirement.isOptional()) {
            key = String.valueOf(key) + "_Optional";
        }
        return this.overlayImage(object, this.getResourceLocator().getImage(key));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        Requirement requirement = (Requirement)object;
        String label = requirement.getName();
        if (label == null || label.length() == 0) {
            label = this.getString("_UI_Requirement_type");
        } else if (label.endsWith(FEATURE_SUFFIX)) {
            label = label.substring(0, label.length() - FEATURE_SUFFIX.length());
        }
        VersionRange versionRange = requirement.getVersionRange();
        return String.valueOf(label) + (versionRange == null || VersionRange.emptyRange.equals((Object)versionRange) ? "" : " " + versionRange.toString());
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Requirement.class)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

