/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.uml24atl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.m2m.atl.drivers.uml24atl.ASMUMLModel;
import org.eclipse.m2m.atl.engine.AtlEMFModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AtlUML2ModelHandler
extends AtlEMFModelHandler {
    private ASMUMLModel mofmm = ASMUMLModel.createMOF(null);
    private boolean useIDs = true;
    private boolean removeIDs = false;
    private String encoding = "ISO-8859-1";

    public void saveModel(ASMModel model, String fileName, IProject project) {
        String uri = String.valueOf(project.getFullPath().toString()) + "/" + fileName;
        this.saveModel(model, uri);
    }

    public void saveModel(ASMModel model, String uri) {
        this.saveModel(model, URI.createURI((String)uri), null);
    }

    public void saveModel(ASMModel model, OutputStream out) {
        this.saveModel(model, null, out);
    }

    protected void saveModel(ASMModel model, URI uri, OutputStream out) {
        ((ASMUMLModel)model).applyDelayedInvocations();
        XMIResource r = (XMIResource)((ASMUMLModel)model).getExtent();
        if (uri != null) {
            r.setURI(uri);
        }
        r.setXMIVersion("2.1");
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", this.encoding);
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        options.put("SCHEMA_LOCATION", Boolean.TRUE);
        options.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        this.useIDs = true;
        if ((this.useIDs || this.removeIDs) && r instanceof XMIResource) {
            XMIResource xr = r;
            int id = 1;
            HashSet<EObject> alreadySet = new HashSet<EObject>();
            TreeIterator i = r.getAllContents();
            while (i.hasNext()) {
                EObject eo = (EObject)i.next();
                if (alreadySet.contains(eo)) continue;
                xr.setID(eo, this.removeIDs ? null : "a" + id++);
                alreadySet.add(eo);
            }
        }
        try {
            if (out != null) {
                r.save(out, options);
            } else {
                r.save(options);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public ASMModel getMof() {
        return this.mofmm;
    }

    public ASMModel loadModel(String name, ASMModel metamodel, InputStream in) {
        ASMUMLModel ret = null;
        try {
            ret = ASMUMLModel.loadASMUMLModel(name, (ASMUMLModel)metamodel, in, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public ASMModel newModel(String name, ASMModel metamodel) {
        ASMUMLModel ret = null;
        try {
            ret = ASMUMLModel.newASMUMLModel(name, (ASMUMLModel)metamodel, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public ASMModel newModel(String name, String uri, ASMModel metamodel) {
        ASMUMLModel ret = null;
        try {
            ret = ASMUMLModel.newASMUMLModel(name, uri, (ASMUMLModel)metamodel, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public ASMModel getBuiltInMetaModel(String name) {
        ASMModel ret = null;
        return ret;
    }

    public boolean isHandling(ASMModel model) {
        return model instanceof ASMUMLModel;
    }

    public void disposeOfModel(ASMModel model) {
        ((ASMUMLModel)model).dispose();
    }

    public ASMModel loadModel(String name, ASMModel metamodel, String uri) {
        ASMUMLModel ret = null;
        try {
            ret = ASMUMLModel.loadASMUMLModel(name, (ASMUMLModel)metamodel, uri, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public ASMModel loadModel(String name, ASMModel metamodel, URI uri) {
        ASMUMLModel ret = null;
        try {
            ret = ASMUMLModel.loadASMUMLModel(name, (ASMUMLModel)metamodel, uri, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

