/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.vertical;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.HorizontalConstraint;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLine;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineIterator;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.OrderingConstraint;

class InputAsserter {
    private final Set myAllElements = new HashSet();
    private final Map myHorizontal2Info = new HashMap();
    private final Map myOrdering2Info = new HashMap();

    InputAsserter(LifeLine[] lifeLines) {
        int i = 0;
        while (i < lifeLines.length) {
            LifeLineIterator it = lifeLines[i].iterator();
            while (it.hasNext()) {
                OrderingConstraint orderingConstraint;
                it.nextClueValue();
                LifeLineElement element = it.nextElement();
                this.registerElement(element);
                HorizontalConstraint horizontalConstraint = element.getHorizontalConstraint();
                if (horizontalConstraint != null) {
                    this.getHorizontalInfo(horizontalConstraint).addElement(element);
                }
                Enumeration<OrderingConstraint> beforeEnum = element.beforeConstraints();
                while (beforeEnum.hasMoreElements()) {
                    orderingConstraint = beforeEnum.nextElement();
                    this.getOrderingInfo(orderingConstraint).registerAfter(element);
                }
                Enumeration<OrderingConstraint> afterEnum = element.afterConstraints();
                while (afterEnum.hasMoreElements()) {
                    orderingConstraint = afterEnum.nextElement();
                    this.getOrderingInfo(orderingConstraint).registerBefore(element);
                }
            }
            ++i;
        }
        for (Object info : this.myHorizontal2Info.values()) {
            ((HorizontalInfo)info).checkComplete();
        }
        for (Object info : this.myOrdering2Info.values()) {
            ((OrderingInfo)info).checkComplete();
        }
    }

    private void registerElement(LifeLineElement element) {
        boolean res = this.myAllElements.add(element);
        if (!res) {
            throw new RuntimeException("Such element already added to set");
        }
    }

    private HorizontalInfo getHorizontalInfo(HorizontalConstraint constraint) {
        HorizontalInfo info = (HorizontalInfo)this.myHorizontal2Info.get(constraint);
        if (info == null) {
            info = new HorizontalInfo(constraint);
            this.myHorizontal2Info.put(constraint, info);
        }
        return info;
    }

    private OrderingInfo getOrderingInfo(OrderingConstraint constraint) {
        OrderingInfo info = (OrderingInfo)this.myOrdering2Info.get(constraint);
        if (info == null) {
            info = new OrderingInfo(constraint);
            this.myOrdering2Info.put(constraint, info);
        }
        return info;
    }

    private static class HorizontalInfo {
        private final Set myExpectedElements;

        HorizontalInfo(HorizontalConstraint constraint) {
            this.myExpectedElements = new HashSet<LifeLineElement>(constraint.getLifeLineElementsList());
        }

        void addElement(LifeLineElement element) {
            boolean res = this.myExpectedElements.remove(element);
            if (!res) {
                throw new RuntimeException("Non-expected element");
            }
        }

        void checkComplete() {
            if (!this.myExpectedElements.isEmpty()) {
                throw new RuntimeException("Not all elements are found");
            }
        }
    }

    private static class OrderingInfo {
        private boolean myBeforeFound = false;
        private boolean myAfterFound = false;
        private final OrderingConstraint myConstraint;

        OrderingInfo(OrderingConstraint constraint) {
            this.myConstraint = constraint;
        }

        void registerBefore(LifeLineElement element) {
            if (this.myBeforeFound) {
                throw new RuntimeException("Element already registered");
            }
            if (element != this.myConstraint.getBeforeElement()) {
                throw new RuntimeException("Unexpected 'before' element");
            }
            this.myBeforeFound = true;
        }

        void registerAfter(LifeLineElement element) {
            if (this.myAfterFound) {
                throw new RuntimeException("Element already registered");
            }
            if (element != this.myConstraint.getAfterElement()) {
                throw new RuntimeException("Unexpected 'after' element");
            }
            this.myAfterFound = true;
        }

        void checkComplete() {
            if (!this.myBeforeFound) {
                throw new RuntimeException("Before element not found");
            }
            if (!this.myAfterFound) {
                throw new RuntimeException("After element not found");
            }
        }
    }
}

