/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.component.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.uml2.diagram.component.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Type;

public class PortProvidedReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public PortProvidedReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Port)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Port)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistPortProvided_4006(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Interface)) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canExistPortProvided_4006(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getProvideds().remove((Object)this.getOldTarget());
        this.getNewSource().getProvideds().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        Interface oldTarget = this.getOldTarget();
        Interface newTarget = this.getNewTarget();
        Port port = this.getOldSource();
        Classifier portType = (Classifier)port.getType();
        if (oldTarget.equals(portType)) {
            port.setType((Type)newTarget);
        } else {
            for (Dependency nextDependency : portType.getClientDependencies()) {
                if (!PortProvidedReorientCommand.isInterfaceRealization(nextDependency, oldTarget)) continue;
                nextDependency.getSuppliers().remove((Object)oldTarget);
                nextDependency.getSuppliers().add((Object)newTarget);
            }
        }
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Port getOldSource() {
        return (Port)this.referenceOwner;
    }

    protected Port getNewSource() {
        return (Port)this.newEnd;
    }

    protected Interface getOldTarget() {
        return (Interface)this.oldEnd;
    }

    protected Interface getNewTarget() {
        return (Interface)this.newEnd;
    }

    private static boolean isInterfaceRealization(Dependency dependency, Interface innterface) {
        return dependency instanceof Realization && dependency.getSuppliers().contains((Object)innterface);
    }
}

