/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.internal.sessions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.sirius.editor.internal.sessions.services.IPapyrusSessionFactory;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.tools.api.Messages;

public class PapyrusLocalSessionCreationOperation
extends DefaultLocalSessionCreationOperation {
    private IProgressMonitor monitor;
    private TransactionalEditingDomain transactionalEditingDomain;

    public PapyrusLocalSessionCreationOperation(URI sessionResourceURI, IProgressMonitor monitor, TransactionalEditingDomain transactionalEditingDomain) {
        super(sessionResourceURI, monitor);
        this.transactionalEditingDomain = transactionalEditingDomain;
    }

    public void execute() throws CoreException {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        try {
            this.monitor.beginTask(Messages.DefaultLocalSessionCreationOperation_createResoureMsg, 3);
            this.monitor.subTask(Messages.DefaultLocalSessionCreationOperation_createSessionMsg);
            SessionFactory factory = SessionFactory.INSTANCE;
            if (!(factory instanceof IPapyrusSessionFactory)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.sirius.editor", NLS.bind((String)"We expected to get the {0}, so we are not able to create the Sirius Session for Papyrus", (Object)IPapyrusSessionFactory.class.getName())));
            }
            IPapyrusSessionFactory papyrusFactory = (IPapyrusSessionFactory)factory;
            this.session = papyrusFactory.createPapyrusSession(this.sessionResourceURI, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.monitor, (int)1), this.transactionalEditingDomain);
            this.monitor.subTask(Messages.DefaultLocalSessionCreationOperation_sessionOpenMsg);
            this.session.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.monitor, (int)1));
            this.transactionalEditingDomain.getCommandStack().flush();
            for (Resource r : this.transactionalEditingDomain.getResourceSet().getResources()) {
                r.setModified(false);
            }
        }
        finally {
            this.monitor.done();
        }
    }
}

