/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.generators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractQVTGenerator
implements IGenerator,
Listener {
    protected List<Context> generatedContexts;
    protected ModelExtent out;
    private Set<Listener> listeners = new HashSet<Listener>();
    private int strategy;
    private Collection<ResourceSet> scratchResourceSets;

    @Override
    public List<Context> generate(List<URI> targetURI) {
        switch (this.strategy) {
            case 0: {
                this.generatedContexts = this.generateSameFile(targetURI);
                break;
            }
            case 1: {
                this.generatedContexts = this.generateSameFile(targetURI);
                break;
            }
            case 2: {
                this.generatedContexts = this.generateDifferentFile(targetURI);
                break;
            }
            default: {
                this.generatedContexts = null;
            }
        }
        return this.generatedContexts;
    }

    @Override
    public void dispose() {
        if (this.scratchResourceSets != null) {
            for (ResourceSet next : this.scratchResourceSets) {
                EMFHelper.unload((ResourceSet)next);
            }
            this.scratchResourceSets = null;
        }
    }

    protected abstract List<ModelExtent> getModelExtents();

    protected ModelExtent getOutContextExtent() {
        if (this.out == null) {
            this.out = new BasicModelExtent();
        }
        return this.out;
    }

    protected abstract URI getTransformationURI();

    protected EObject loadEMFModel(URI uri) throws IOException {
        ResourceSet resourceSet = this.createResourceSet();
        try {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource != null && !resource.getContents().isEmpty()) {
                return (EObject)resource.getContents().get(0);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
        return null;
    }

    protected final ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        if (this.scratchResourceSets == null) {
            this.scratchResourceSets = new ArrayList<ResourceSet>();
        }
        this.scratchResourceSets.add((ResourceSet)result);
        return result;
    }

    @Override
    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void handleEvent(Event event) {
        for (Listener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected List<Context> getContexts(List<EObject> outObjects) {
        LinkedList<Context> result = new LinkedList<Context>();
        for (EObject objectResult : outObjects) {
            if (!(objectResult instanceof Context)) continue;
            result.add((Context)objectResult);
        }
        return result;
    }

    @Override
    public abstract IObservableValue getObservableValue();

    @Override
    public void setStrategy(int strategy) {
        this.strategy = strategy;
    }

    private List<Context> generateSameFile(List<URI> targetURI) {
        URI transformationURI = this.getTransformationURI();
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        Diagnostic diagnostic = executor.loadTransformation();
        if (diagnostic.getSeverity() != 0) {
            Activator.log.warn("Cannot load the transformation : " + String.valueOf(transformationURI));
            this.generatedContexts = null;
            return null;
        }
        List<ModelExtent> extents = this.getModelExtents();
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        ExecutionDiagnostic result = executor.execute((ExecutionContext)context, extents.toArray(new ModelExtent[0]));
        if (result.getSeverity() == 0) {
            List outObjects = this.getOutContextExtent().getContents();
            Object objectResult = outObjects.get(0);
            if (!(objectResult instanceof Context)) {
                return null;
            }
            ResourceSet resourceSet = this.createResourceSet();
            Resource contextResource = resourceSet.createResource(targetURI.get(0), "org.eclipse.papyrus.infra.properties.context");
            contextResource.getContents().addAll((Collection)outObjects);
            this.generatedContexts = this.getContexts(outObjects);
            return this.generatedContexts;
        }
        IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
        Activator.log.warn(String.format("%s : %s", status.getPlugin(), status.getMessage()));
        this.generatedContexts = null;
        return null;
    }

    protected abstract List<ModelExtent> getModelExtents(int var1);

    private List<Context> generateDifferentFile(List<URI> targetURI) {
        URI transformationURI = this.getTransformationURI();
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        Diagnostic diagnostic = executor.loadTransformation();
        if (diagnostic.getSeverity() != 0) {
            Activator.log.warn("Cannot load the transformation : " + String.valueOf(transformationURI));
            this.generatedContexts = null;
            return null;
        }
        List<ModelExtent> extents = null;
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        LinkedList<Context> temp = new LinkedList<Context>();
        int i = 0;
        while (i < targetURI.size()) {
            extents = this.getModelExtents(i);
            ExecutionDiagnostic result = executor.execute((ExecutionContext)context, extents.toArray(new ModelExtent[0]));
            if (result.getSeverity() == 0) {
                List outObjects = this.getOutContextExtent().getContents();
                Object objectResult = outObjects.get(0);
                if (!(objectResult instanceof Context)) {
                    return null;
                }
                ResourceSet resourceSet = this.createResourceSet();
                Resource contextResource = resourceSet.createResource(targetURI.get(i), "org.eclipse.papyrus.infra.properties.context");
                contextResource.getContents().addAll((Collection)outObjects);
                temp.addAll(this.getContexts(outObjects));
            } else {
                IStatus status = BasicDiagnostic.toIStatus((Diagnostic)result);
                Activator.log.warn(String.format("%s : %s", status.getPlugin(), status.getMessage()));
            }
            ++i;
        }
        return temp;
    }
}

