/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class InstanceSpecificationWithSlotConfigureElementCommand
extends ConfigureElementCommand {
    private Classifier classifier;

    public InstanceSpecificationWithSlotConfigureElementCommand(ConfigureRequest request, Classifier classifier) {
        super(request);
        this.classifier = classifier;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        InstanceSpecification instanceSpecification = (InstanceSpecification)this.getElementToEdit();
        if (this.classifier != null) {
            instanceSpecification.getClassifiers().add((Object)this.classifier);
            EList attributes = this.classifier.getAttributes();
            for (Property property : attributes) {
                Slot slot = instanceSpecification.createSlot();
                Type type = property.getType();
                if (type != null) {
                    ValueSpecification valueSpecification = slot.createValue(property.getName(), type, UMLPackage.eINSTANCE.getInstanceValue());
                    valueSpecification.setType(type);
                } else {
                    slot.createValue(property.getName(), null, UMLPackage.eINSTANCE.getLiteralString());
                }
                slot.setDefiningFeature((StructuralFeature)property);
            }
        }
        return CommandResult.newOKCommandResult((Object)instanceSpecification);
    }
}

