/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.documentview.modelexplorer.internal.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.model2doc.documentview.Document;
import org.eclipse.papyrus.model2doc.documentview.modelexplorer.internal.command.RenameDocumentLabelCommand;
import org.eclipse.papyrus.model2doc.documentview.modelexplorer.internal.handler.AbstractDocumentCommandHandler;
import org.eclipse.papyrus.model2doc.documentview.modelexplorer.internal.message.Messages;
import org.eclipse.papyrus.views.modelexplorer.commands.RenameElementCommand;
import org.eclipse.papyrus.views.modelexplorer.util.ModelExplorerEditionUtil;

public class RenameDocumentHandler
extends AbstractDocumentCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(context);
        List<Document> documents = this.getSelectedDocuments();
        if (editingDomain != null && documents.size() == 1) {
            Document document = documents.get(0);
            String documentLabel = LabelInternationalizationUtils.getLabelWithoutSubstract((EObject)document, (boolean)true);
            if (documentLabel != null && LabelInternationalizationPreferencesUtils.getInternationalizationPreference((EObject)document)) {
                RenameDocumentLabelCommand cmd = new RenameDocumentLabelCommand(editingDomain, "ChangeDocumentLabelCommand", (EObject)document, documentLabel, Messages.RenameDocumentHandler_Label_DialogTitle);
                return new GMFtoEMFCommandWrapper((ICommand)cmd);
            }
            String currentName = document.getName();
            if (currentName != null) {
                EStructuralFeature nameFeature = document.eClass().getEStructuralFeature("name");
                return new RenameElementCommand(editingDomain, "RenameDocumentCommand", (EObject)document, currentName, nameFeature, Messages.RenameDocumentHandler_RenameAnExistingDocument, Messages.RenameDocumentHandler_NewName);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        boolean computeEnabled = super.computeEnabled(context);
        if (computeEnabled) {
            List selectedElements = this.getSelectedElements();
            EObject selection = (EObject)selectedElements.get(0);
            computeEnabled = !EMFHelper.isReadOnly((EObject)selection);
        }
        return computeEnabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedDocument = this.getSelectedElement();
        if (ModelExplorerEditionUtil.isHandledByDirectEditor((EObject)selectedDocument)) {
            ModelExplorerEditionUtil.editElement((EObject)selectedDocument);
        } else {
            super.execute(event);
        }
        return null;
    }
}

