/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.author.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.papyrus.model2doc.core.author.IAuthor;

public class IAuthorsOperations {
    private static final String SPACE = " ";
    private static final String AUTHOR_SEPARATOR = "; ";

    public static final String buildAuthorLabel(IAuthor author) {
        if (author == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String firstName = author.getFirstName();
        String lastName = author.getLastName();
        builder.append(firstName != null ? firstName : "");
        builder.append(SPACE);
        builder.append(lastName != null ? lastName : "");
        return builder.toString();
    }

    public static final String buildMultiAuthorLabel(Collection<IAuthor> authors) {
        StringBuilder builder = new StringBuilder();
        Iterator<IAuthor> iter = authors.iterator();
        while (iter.hasNext()) {
            builder.append(IAuthorsOperations.buildAuthorLabel(iter.next()));
            if (!iter.hasNext()) continue;
            builder.append(AUTHOR_SEPARATOR);
        }
        return builder.toString();
    }
}

