/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.adt.Messages;
import org.eclipse.m2m.atl.adt.runner.ATLProperties;
import org.eclipse.m2m.atl.adt.runner.CreateRunnableAtlOperation;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.MarkerMaker;
import org.eclipse.m2m.atl.engine.compiler.AtlCompiler;
import org.eclipse.m2m.atl.engine.compiler.CompilerNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlBuildVisitor
implements IResourceVisitor {
    private MarkerMaker markerMaker = new MarkerMaker();
    private IProgressMonitor monitor;

    public AtlBuildVisitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private boolean hasChanged(IResource resource) {
        return resource.getLocalTimeStamp() > this.getAsmFile(resource).getLocalTimeStamp();
    }

    private boolean hasAsmFile(IResource resource) {
        return this.getAsmFile(resource).exists();
    }

    private IFile getAsmFile(IResource resource) {
        String atlFileName = resource.getName();
        String asmFileName = String.valueOf(atlFileName.substring(0, atlFileName.lastIndexOf(46))) + ".asm";
        IFile asm = resource.getParent().getFile((IPath)new Path(asmFileName));
        return asm;
    }

    public boolean visit(IResource resource) throws CoreException {
        String extension = resource.getFileExtension();
        if ("atl".equals(extension) && resource instanceof IFile && ((IFile)resource).getLocation().toFile().length() > 0L && (!this.hasAsmFile(resource) || this.hasChanged(resource))) {
            String inName = resource.getName();
            this.monitor.subTask(Messages.getString("AtlBuildVisitor.COMPILETASK", new Object[]{inName}));
            String outName = String.valueOf(inName.substring(0, inName.lastIndexOf(46))) + ".asm";
            IFile out = resource.getParent().getFile((IPath)new Path(outName));
            InputStream is = ((IFile)resource).getContents();
            try {
                EObject[] pbms = AtlCompiler.compile((InputStream)is, (IFile)out);
                this.markerMaker.resetPbmMarkers(resource, pbms);
                IFile asmFile = this.getAsmFile(resource);
                if (asmFile.exists()) {
                    asmFile.setDerived(true);
                }
                is.close();
                if (pbms.length == 0) {
                    IFile[] iFileArray = this.getRelatedPropertyFiles((IFile)resource);
                    int n = iFileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile propertyFile = iFileArray[n2];
                        if (!propertyFile.isDerived()) {
                            IFile javaFile = propertyFile.getParent().getFile(new Path(propertyFile.getName()).removeFileExtension().addFileExtension("java"));
                            CreateRunnableAtlOperation op = new CreateRunnableAtlOperation(propertyFile, javaFile);
                            op.run(this.monitor);
                        }
                        ++n2;
                    }
                }
            }
            catch (CompilerNotFoundException cnfee) {
                IMarker marker = resource.createMarker("org.eclipse.m2m.atl.engine.problem");
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)cnfee.getMessage());
                marker.setAttribute("lineNumber", 1);
            }
            catch (IOException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private IFile[] getRelatedPropertyFiles(IFile atlFile) throws IOException, CoreException {
        ArrayList<IFile> res = new ArrayList<IFile>();
        for (IFile propertyFile : this.getAllPropertyFiles(atlFile.getParent())) {
            ATLProperties properties = new ATLProperties(propertyFile);
            IFile[] modules = properties.getTransformationFiles();
            if (modules == null || !Arrays.asList(modules).contains(atlFile)) continue;
            res.add(propertyFile);
        }
        return res.toArray(new IFile[res.size()]);
    }

    private List<IFile> getAllPropertyFiles(IContainer container) throws CoreException {
        if (container.getProject().hasNature("org.eclipse.pde.PluginNature")) {
            PropertiesVisitor visitor = new PropertiesVisitor();
            container.accept((IResourceVisitor)visitor);
            return visitor.getPropertyFiles();
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesVisitor
    implements IResourceVisitor {
        private List<IFile> propertyFiles = new ArrayList<IFile>();

        private PropertiesVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            IFile propertyFile;
            if (resource instanceof IContainer) {
                return true;
            }
            if (resource instanceof IFile && "properties".equals((propertyFile = (IFile)resource).getFileExtension())) {
                IResource[] iResourceArray = resource.getParent().members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member instanceof IFile && "atl".equals(member.getFileExtension()) && propertyFile.getName().equalsIgnoreCase(member.getFullPath().removeFileExtension().addFileExtension("properties").lastSegment())) {
                        this.propertyFiles.add(propertyFile);
                    }
                    ++n2;
                }
            }
            return true;
        }

        public List<IFile> getPropertyFiles() {
            return this.propertyFiles;
        }
    }
}

