/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.catalina.loader.StandardClassLoader;
import org.apache.catalina.startup.Bootstrap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class ClassLoaderFactory {
    private static final Log log = LogFactory.getLog(ClassLoaderFactory.class);

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, final ClassLoader parent) throws Exception {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new class loader");
        }
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (unpacked != null) {
            for (i = 0; i < unpacked.length; ++i) {
                File file = unpacked[i];
                if (!file.exists() || !file.canRead()) continue;
                file = new File(file.getCanonicalPath() + File.separator);
                URL url = file.toURI().toURL();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Including directory " + url));
                }
                set.add(url);
            }
        }
        if (packed != null) {
            for (i = 0; i < packed.length; ++i) {
                File directory = packed[i];
                if (!directory.isDirectory() || !directory.exists() || !directory.canRead()) continue;
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase(Locale.ENGLISH);
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including jar file " + file.getAbsolutePath()));
                    }
                    URL url = file.toURI().toURL();
                    set.add(url);
                }
            }
        }
        final URL[] array = set.toArray(new URL[set.size()]);
        return AccessController.doPrivileged(new PrivilegedAction<StandardClassLoader>(){

            @Override
            public StandardClassLoader run() {
                if (parent == null) {
                    return new StandardClassLoader(array);
                }
                return new StandardClassLoader(array, parent);
            }
        });
    }

    public static ClassLoader createClassLoader(List<Repository> repositories, final ClassLoader parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new class loader");
        }
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (repositories != null) {
            for (Repository repository : repositories) {
                URL url;
                File directory;
                if (repository.getType() == RepositoryType.URL) {
                    URL url2 = new URL(repository.getLocation());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including URL " + url2));
                    }
                    set.add(url2);
                    continue;
                }
                if (repository.getType() == RepositoryType.DIR) {
                    directory = new File(repository.getLocation());
                    if (!ClassLoaderFactory.validateFile(directory = directory.getCanonicalFile(), RepositoryType.DIR)) continue;
                    url = directory.toURI().toURL();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including directory " + url));
                    }
                    set.add(url);
                    continue;
                }
                if (repository.getType() == RepositoryType.JAR) {
                    File file = new File(repository.getLocation());
                    if (!ClassLoaderFactory.validateFile(file = file.getCanonicalFile(), RepositoryType.JAR)) continue;
                    url = file.toURI().toURL();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including jar file " + url));
                    }
                    set.add(url);
                    continue;
                }
                if (repository.getType() != RepositoryType.GLOB) continue;
                directory = new File(repository.getLocation());
                if (!ClassLoaderFactory.validateFile(directory = directory.getCanonicalFile(), RepositoryType.GLOB)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Including directory glob " + directory.getAbsolutePath()));
                }
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase(Locale.ENGLISH);
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (!ClassLoaderFactory.validateFile(file = file.getCanonicalFile(), RepositoryType.JAR)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("    Including glob jar file " + file.getAbsolutePath()));
                    }
                    URL url3 = file.toURI().toURL();
                    set.add(url3);
                }
            }
        }
        final URL[] array = set.toArray(new URL[set.size()]);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < array.length; ++i) {
                log.debug((Object)("  location " + i + " is " + array[i]));
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<StandardClassLoader>(){

            @Override
            public StandardClassLoader run() {
                if (parent == null) {
                    return new StandardClassLoader(array);
                }
                return new StandardClassLoader(array, parent);
            }
        });
    }

    private static boolean validateFile(File file, RepositoryType type) throws IOException {
        if (RepositoryType.DIR == type || RepositoryType.GLOB == type) {
            if (!(file.exists() && file.isDirectory() && file.canRead())) {
                String msg = "Problem with directory [" + file + "], exists: [" + file.exists() + "], isDirectory: [" + file.isDirectory() + "], canRead: [" + file.canRead() + "]";
                File home = new File(Bootstrap.getCatalinaHome());
                home = home.getCanonicalFile();
                File base = new File(Bootstrap.getCatalinaBase());
                base = base.getCanonicalFile();
                File defaultValue = new File(base, "lib");
                if (!home.getPath().equals(base.getPath()) && file.getPath().equals(defaultValue.getPath()) && !file.exists()) {
                    log.debug((Object)msg);
                } else {
                    log.warn((Object)msg);
                }
                return false;
            }
        } else if (!(RepositoryType.JAR != type || file.exists() && file.canRead())) {
            log.warn((Object)("Problem with JAR file [" + file + "], exists: [" + file.exists() + "], canRead: [" + file.canRead() + "]"));
            return false;
        }
        return true;
    }

    public static class Repository {
        private String location;
        private RepositoryType type;

        public Repository(String location, RepositoryType type) {
            this.location = location;
            this.type = type;
        }

        public String getLocation() {
            return this.location;
        }

        public RepositoryType getType() {
            return this.type;
        }
    }

    public static enum RepositoryType {
        DIR,
        GLOB,
        JAR,
        URL;

    }
}

