/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;

public final class Parameters {
    private static final Log log = LogFactory.getLog(Parameters.class);
    private Hashtable<String, String[]> paramHashStringArray = new Hashtable();
    private boolean didQueryParameters = false;
    MessageBytes queryMB;
    UDecoder urlDec;
    MessageBytes decodedQuery = MessageBytes.newInstance();
    String encoding = null;
    String queryStringEncoding = null;
    ByteChunk tmpName = new ByteChunk();
    ByteChunk tmpValue = new ByteChunk();
    private ByteChunk origName = new ByteChunk();
    private ByteChunk origValue = new ByteChunk();
    CharChunk tmpNameC = new CharChunk(1024);
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    public void setQuery(MessageBytes queryMB) {
        this.queryMB = queryMB;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String s) {
        this.encoding = s;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set encoding to " + s));
        }
    }

    public void setQueryStringEncoding(String s) {
        this.queryStringEncoding = s;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set query string encoding to " + s));
        }
    }

    public void recycle() {
        this.paramHashStringArray.clear();
        this.didQueryParameters = false;
        this.encoding = null;
        this.decodedQuery.recycle();
    }

    public void addParameterValues(String key, String[] newValues) {
        String[] values;
        if (key == null) {
            return;
        }
        if (this.paramHashStringArray.containsKey(key)) {
            int i;
            String[] oldValues = this.paramHashStringArray.get(key);
            values = new String[oldValues.length + newValues.length];
            for (i = 0; i < oldValues.length; ++i) {
                values[i] = oldValues[i];
            }
            for (i = 0; i < newValues.length; ++i) {
                values[i + oldValues.length] = newValues[i];
            }
        } else {
            values = newValues;
        }
        this.paramHashStringArray.put(key, values);
    }

    public String[] getParameterValues(String name) {
        this.handleQueryParameters();
        String[] values = this.paramHashStringArray.get(name);
        return values;
    }

    public Enumeration<String> getParameterNames() {
        this.handleQueryParameters();
        return this.paramHashStringArray.keys();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            if (values.length == 0) {
                return "";
            }
            return values[0];
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryMB == null || this.queryMB.isNull()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decoding query " + this.decodedQuery + " " + this.queryStringEncoding));
        }
        try {
            this.decodedQuery.duplicate(this.queryMB);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processParameters(this.decodedQuery, this.queryStringEncoding);
    }

    private void addParam(String key, String value) {
        String[] values;
        if (key == null) {
            return;
        }
        if (this.paramHashStringArray.containsKey(key)) {
            String[] oldValues = this.paramHashStringArray.get(key);
            values = new String[oldValues.length + 1];
            for (int i = 0; i < oldValues.length; ++i) {
                values[i] = oldValues[i];
            }
            values[oldValues.length] = value;
        } else {
            values = new String[]{value};
        }
        this.paramHashStringArray.put(key, values);
    }

    public void setURLDecoder(UDecoder u) {
        this.urlDec = u;
    }

    public void processParameters(byte[] bytes, int start, int len) {
        this.processParameters(bytes, start, len, this.encoding);
    }

    public void processParameters(byte[] bytes, int start, int len, String enc) {
        int end = start + len;
        int pos = start;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Bytes: " + new String(bytes, start, len, DEFAULT_CHARSET)));
        }
        do {
            block14: {
                boolean noEq = false;
                int valStart = -1;
                int valEnd = -1;
                int nameStart = pos;
                int nameEnd = ByteChunk.indexOf(bytes, nameStart, end, '=');
                int nameEnd2 = ByteChunk.indexOf(bytes, nameStart, end, '&');
                if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                    nameEnd = nameEnd2;
                    noEq = true;
                    valStart = nameEnd;
                    valEnd = nameEnd;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("no equal " + nameStart + " " + nameEnd + " " + new String(bytes, nameStart, nameEnd - nameStart, DEFAULT_CHARSET)));
                    }
                }
                if (nameEnd == -1) {
                    nameEnd = end;
                }
                if (!noEq && (valEnd = ByteChunk.indexOf(bytes, valStart = nameEnd < end ? nameEnd + 1 : end, end, '&')) == -1) {
                    valEnd = valStart < end ? end : valStart;
                }
                pos = valEnd + 1;
                if (nameEnd <= nameStart) {
                    if (!log.isInfoEnabled()) continue;
                    StringBuilder msg = new StringBuilder("Parameters: Invalid chunk ");
                    if (valEnd >= nameStart) {
                        msg.append('\'');
                        msg.append(new String(bytes, nameStart, valEnd - nameStart, DEFAULT_CHARSET));
                        msg.append("' ");
                    }
                    msg.append("ignored.");
                    log.info((Object)msg);
                    continue;
                }
                this.tmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
                this.tmpValue.setBytes(bytes, valStart, valEnd - valStart);
                if (log.isDebugEnabled()) {
                    try {
                        this.origName.append(bytes, nameStart, nameEnd - nameStart);
                        this.origValue.append(bytes, valStart, valEnd - valStart);
                    }
                    catch (IOException ioe) {
                        log.error((Object)"Error copying parameters", (Throwable)ioe);
                    }
                }
                try {
                    this.addParam(this.urlDecode(this.tmpName, enc), this.urlDecode(this.tmpValue, enc));
                }
                catch (IOException e) {
                    StringBuilder msg = new StringBuilder("Parameters: Character decoding failed.");
                    msg.append(" Parameter '");
                    if (log.isDebugEnabled()) {
                        msg.append(this.origName.toString());
                        msg.append("' with value '");
                        msg.append(this.origValue.toString());
                        msg.append("' has been ignored.");
                        log.debug((Object)msg, (Throwable)e);
                    }
                    if (!log.isInfoEnabled()) break block14;
                    msg.append(this.tmpName.toString());
                    msg.append("' with value '");
                    msg.append(this.tmpValue.toString());
                    msg.append("' has been ignored. Note that the name and ");
                    msg.append("value quoted here may be corrupted due to ");
                    msg.append("the failed decoding. Use debug level logging ");
                    msg.append("to see the original, non-corrupted values.");
                    log.info((Object)msg);
                }
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
            if (!log.isDebugEnabled()) continue;
            this.origName.recycle();
            this.origValue.recycle();
        } while (pos < end);
    }

    private String urlDecode(ByteChunk bc, String enc) throws IOException {
        if (this.urlDec == null) {
            this.urlDec = new UDecoder();
        }
        this.urlDec.convert(bc);
        String result = null;
        if (enc != null) {
            bc.setEncoding(enc);
            result = bc.toString();
        } else {
            CharChunk cc = this.tmpNameC;
            int length = bc.getLength();
            cc.allocate(length, -1);
            byte[] bbuf = bc.getBuffer();
            char[] cbuf = cc.getBuffer();
            int start = bc.getStart();
            for (int i = 0; i < length; ++i) {
                cbuf[i] = (char)(bbuf[i + start] & 0xFF);
            }
            cc.setChars(cbuf, 0, length);
            result = cc.toString();
            cc.recycle();
        }
        return result;
    }

    public void processParameters(MessageBytes data, String encoding) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        if (data.getType() != 2) {
            data.toBytes();
        }
        ByteChunk bc = data.getByteChunk();
        this.processParameters(bc.getBytes(), bc.getOffset(), bc.getLength(), encoding);
    }

    public String paramsAsString() {
        StringBuilder sb = new StringBuilder();
        Enumeration<String> en = this.paramHashStringArray.keys();
        while (en.hasMoreElements()) {
            String k = en.nextElement();
            sb.append(k).append("=");
            String[] v = this.paramHashStringArray.get(k);
            for (int i = 0; i < v.length; ++i) {
                sb.append(v[i]).append(",");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

