/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.coyote.ActionCode;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Processor
extends AbstractHttp11Processor<Socket> {
    private static final Log log = LogFactory.getLog(Http11Processor.class);
    protected InternalInputBuffer inputBuffer = null;
    protected InternalOutputBuffer outputBuffer = null;
    protected SSLSupport sslSupport;
    protected SocketWrapper<Socket> socket;
    private int disableKeepAlivePercentage = 75;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11Processor(int headerBufferSize, JIoEndpoint endpoint, int maxTrailerSize) {
        super(endpoint);
        this.inputBuffer = new InternalInputBuffer(this.request, headerBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(maxTrailerSize);
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public int getDisableKeepAlivePercentage() {
        return this.disableKeepAlivePercentage;
    }

    public void setDisableKeepAlivePercentage(int disableKeepAlivePercentage) {
        this.disableKeepAlivePercentage = disableKeepAlivePercentage;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socketWrapper) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.socket = socketWrapper;
        this.inputBuffer.init(socketWrapper, this.endpoint);
        this.outputBuffer.init(socketWrapper, this.endpoint);
        this.error = false;
        this.keepAlive = true;
        this.comet = false;
        int soTimeout = this.endpoint.getSoTimeout();
        if (this.disableKeepAlive()) {
            socketWrapper.setKeepAliveLeft(0);
        }
        try {
            this.socket.getSocket().setSoTimeout(soTimeout);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.debug((Object)sm.getString("http11processor.socket.timeout"), t);
            this.error = true;
        }
        boolean keptAlive = socketWrapper.isKeptAlive();
        while (!this.error && this.keepAlive && !this.endpoint.isPaused()) {
            try {
                int standardTimeout = 0;
                if (keptAlive) {
                    if (this.keepAliveTimeout > 0) {
                        standardTimeout = this.keepAliveTimeout;
                    } else if (soTimeout > 0) {
                        standardTimeout = soTimeout;
                    }
                }
                if (this.inputBuffer.lastValid == 0 && socketWrapper.getLastAccess() > -1L && standardTimeout > 0) {
                    long queueTime = System.currentTimeMillis() - socketWrapper.getLastAccess();
                    int firstReadTimeout = queueTime >= (long)standardTimeout ? 1 : standardTimeout - (int)queueTime;
                    this.socket.getSocket().setSoTimeout(firstReadTimeout);
                    if (!this.inputBuffer.fill()) {
                        throw new EOFException(sm.getString("iib.eof.error"));
                    }
                }
                if (standardTimeout > 0) {
                    this.socket.getSocket().setSoTimeout(standardTimeout);
                }
                this.inputBuffer.parseRequestLine(false);
                if (this.endpoint.isPaused()) {
                    this.response.setStatus(503);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                } else {
                    this.request.setStartTime(System.currentTimeMillis());
                    keptAlive = true;
                    if (this.disableUploadTimeout) {
                        this.socket.getSocket().setSoTimeout(soTimeout);
                    } else {
                        this.socket.getSocket().setSoTimeout(this.connectionUploadTimeout);
                    }
                    this.inputBuffer.parseHeaders();
                }
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("http11processor.header.parse"), t);
                }
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            if (!this.error) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.request.prepare"), t);
                    }
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (this.maxKeepAliveRequests == 1) {
                this.keepAlive = false;
            } else if (this.maxKeepAliveRequests > 0 && socketWrapper.decrementKeepAlive() <= 0) {
                this.keepAlive = false;
            }
            if (!this.error) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.error) {
                        this.error = this.response.getErrorException() != null || !this.isAsync() && this.statusDropsConnection(this.response.getStatus());
                    }
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error((Object)sm.getString("http11processor.request.process"), t);
                    this.response.setStatus(500);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            try {
                rp.setStage(4);
                if (this.error && !this.isAsync()) {
                    this.inputBuffer.setSwallowInput(false);
                }
                if (!this.isAsync()) {
                    this.endRequest();
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.error((Object)sm.getString("http11processor.request.finish"), t);
                this.response.setStatus(500);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            try {
                rp.setStage(5);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.error((Object)sm.getString("http11processor.response.finish"), t);
                this.error = true;
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            rp.setStage(6);
            if (!this.isAsync() || this.error) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
            }
            if (!this.isAsync() && !this.error && this.inputBuffer.lastValid != 0) continue;
        }
        rp.setStage(7);
        if (this.error || this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (!this.keepAlive) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    protected boolean disableKeepAlive() {
        int threadRatio = -1;
        if (this.endpoint.getCurrentThreadsBusy() > 0 && this.endpoint.getMaxThreads() > 0) {
            threadRatio = this.endpoint.getCurrentThreadsBusy() * 100 / this.endpoint.getMaxThreads();
        }
        return threadRatio > this.getDisableKeepAlivePercentage();
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    protected void recycleInternal() {
        this.socket = null;
        this.sslSupport = null;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        throw new IOException(sm.getString("http11processor.comet.notsupported"));
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.CLOSE) {
            try {
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
            try {
                if (this.sslSupport != null) {
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
            }
        } else if (actionCode == ActionCode.REQ_HOST_ADDR_ATTRIBUTE) {
            InetAddress inetAddr;
            if (this.remoteAddr == null && this.socket != null && (inetAddr = this.socket.getSocket().getInetAddress()) != null) {
                this.remoteAddr = inetAddr.getHostAddress();
            }
            this.request.remoteAddr().setString(this.remoteAddr);
        } else if (actionCode == ActionCode.REQ_LOCAL_NAME_ATTRIBUTE) {
            InetAddress inetAddr;
            if (this.localName == null && this.socket != null && (inetAddr = this.socket.getSocket().getLocalAddress()) != null) {
                this.localName = inetAddr.getHostName();
            }
            this.request.localName().setString(this.localName);
        } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
            if (this.remoteHost == null && this.socket != null) {
                InetAddress inetAddr = this.socket.getSocket().getInetAddress();
                if (inetAddr != null) {
                    this.remoteHost = inetAddr.getHostName();
                }
                if (this.remoteHost == null) {
                    if (this.remoteAddr != null) {
                        this.remoteHost = this.remoteAddr;
                    } else {
                        this.request.remoteHost().recycle();
                    }
                }
            }
            this.request.remoteHost().setString(this.remoteHost);
        } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
            if (this.localAddr == null) {
                this.localAddr = this.socket.getSocket().getLocalAddress().getHostAddress();
            }
            this.request.localAddr().setString(this.localAddr);
        } else if (actionCode == ActionCode.REQ_REMOTEPORT_ATTRIBUTE) {
            if (this.remotePort == -1 && this.socket != null) {
                this.remotePort = this.socket.getSocket().getPort();
            }
            this.request.setRemotePort(this.remotePort);
        } else if (actionCode == ActionCode.REQ_LOCALPORT_ATTRIBUTE) {
            if (this.localPort == -1 && this.socket != null) {
                this.localPort = this.socket.getSocket().getLocalPort();
            }
            this.request.setLocalPort(this.localPort);
        } else if (actionCode == ActionCode.REQ_SSL_CERTIFICATE) {
            if (this.sslSupport != null) {
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                try {
                    Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        } else if (actionCode == ActionCode.ASYNC_COMPLETE) {
            if (this.asyncStateMachine.asyncComplete()) {
                ((JIoEndpoint)this.endpoint).processSocketAsync(this.socket, SocketStatus.OPEN);
            }
        } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            long timeout = (Long)param;
            this.socket.setTimeout(timeout);
        } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
            ((JIoEndpoint)this.endpoint).processSocketAsync(this.socket, SocketStatus.OPEN);
        }
    }

    @Override
    protected void prepareRequestInternal() {
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        Exception e = new Exception();
        log.error((Object)sm.getString("http11processor.neverused"), (Throwable)e);
        return false;
    }

    @Override
    protected AbstractInputBuffer<Socket> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Socket> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setSocketBuffer(int socketBuffer) {
        super.setSocketBuffer(socketBuffer);
        this.outputBuffer.setSocketBuffer(socketBuffer);
    }
}

