/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.java.Assert;

public class PlatformUriUtils {
    private PlatformUriUtils() {
    }

    public static boolean isPlatformUri(String path) {
        return path.startsWith("platform:/");
    }

    public static boolean isAbsolute(String path) {
        return PlatformUriUtils.isPlatformUri(path) || Paths.isAbsolute(path);
    }

    public static boolean exists(String absPath) {
        if (PlatformUriUtils.isPlatformUri(absPath)) {
            URI uri;
            try {
                uri = URI.createURI((String)absPath);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
            return URIConverter.INSTANCE.exists(uri, null);
        }
        return Files.exists(java.nio.file.Paths.get(absPath, new String[0]), new LinkOption[0]);
    }

    public static String resolve(String path, String absDir) {
        if (PlatformUriUtils.isAbsolute(path)) {
            if (PlatformUriUtils.isPlatformUri(path)) {
                return PlatformUriUtils.normalizePlatformUri(path);
            }
            return Paths.resolve(path, absDir);
        }
        if (PlatformUriUtils.isPlatformUri(absDir)) {
            String[] parts = PlatformUriUtils.splitPlatformUri(absDir);
            String platformPath = parts[2];
            platformPath = Paths.resolve(path, platformPath);
            parts[2] = platformPath = platformPath.replace('\\', '/');
            return PlatformUriUtils.combinePlatformUri(parts);
        }
        return Paths.resolve(path, absDir);
    }

    public static String getRelativePath(String absTgtPath, String absRelDir) {
        if (PlatformUriUtils.isPlatformUri(absTgtPath)) {
            if (PlatformUriUtils.isPlatformUri(absRelDir)) {
                String[] tgtParts = PlatformUriUtils.splitPlatformUri(absTgtPath);
                String[] relParts = PlatformUriUtils.splitPlatformUri(absRelDir);
                if (Objects.equals(tgtParts[0], tgtParts[0]) && Objects.equals(tgtParts[1], tgtParts[1])) {
                    String p = Paths.getRelativePath(tgtParts[2], relParts[2]);
                    p = p.replace('\\', '/');
                    return p;
                }
            }
            return PlatformUriUtils.normalizePlatformUri(absTgtPath);
        }
        if (PlatformUriUtils.isPlatformUri(absRelDir)) {
            return Paths.join(absTgtPath, ".");
        }
        return Paths.getRelativePath(absTgtPath, absRelDir);
    }

    public static String normalizePlatformUri(String uri) {
        String[] parts = PlatformUriUtils.splitPlatformUri(uri);
        return PlatformUriUtils.combinePlatformUri(parts);
    }

    public static String[] splitPlatformUri(String uri) {
        String path;
        boolean hasName;
        Object prefix;
        Assert.check((boolean)PlatformUriUtils.isPlatformUri(uri));
        if (uri.startsWith("platform:/resource/")) {
            prefix = "platform:/resource/";
            hasName = true;
        } else if (uri.startsWith("platform:/plugin/")) {
            prefix = "platform:/plugin/";
            hasName = true;
        } else if (uri.startsWith("platform:/fragment/")) {
            prefix = "platform:/fragment/";
            hasName = true;
        } else if (uri.startsWith("platform:/meta/")) {
            prefix = "platform:/meta/";
            hasName = true;
        } else {
            prefix = "platform:/";
            hasName = false;
        }
        String remainder = uri.substring(((String)prefix).length());
        int idx = remainder.indexOf(47);
        String name = idx == -1 ? remainder : remainder.substring(0, idx);
        String string = path = idx == -1 ? "/" : remainder.substring(idx);
        if (!hasName) {
            prefix = (String)prefix + name + "/";
            name = null;
        }
        Assert.check((boolean)((String)prefix).endsWith("/"));
        Assert.check((boolean)path.startsWith("/"));
        path = Paths.join(path, ".");
        path = path.replace('\\', '/');
        return new String[]{prefix, name, path};
    }

    public static String combinePlatformUri(String[] parts) {
        Assert.check((parts.length == 3 ? 1 : 0) != 0);
        Assert.notNull((Object)parts[0]);
        Assert.notNull((Object)parts[2]);
        if (parts[1] == null) {
            return parts[0] + parts[2];
        }
        return parts[0] + parts[1] + parts[2];
    }
}

