/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.fuzzy.emf.ESEMFDataProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.ESMutateUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.Annotations;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESFuzzyRunner;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.WorkspaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=ESFuzzyRunner.class)
@Annotations.DataProvider(value=ESEMFDataProvider.class)
public abstract class FuzzyProjectTest {
    @Annotations.Data
    private Project project;
    @Annotations.Util
    private ESMutateUtil util;
    @Annotations.Options
    private final Map<String, Object> options = new HashMap<String, Object>(){
        {
            this.put("mutatorEditingDomain", ((ESWorkspaceProviderImpl)ESWorkspaceProvider.INSTANCE).getEditingDomain());
        }
    };
    private ProjectSpace projectSpace;
    private ProjectSpace copyProjectSpace;

    @BeforeClass
    public static void init() {
        CommonUtil.setTesting((boolean)true);
    }

    @Before
    public void setup() {
        CommonUtil.setTesting((boolean)true);
        Configuration.getClientBehavior().setAutoSave(false);
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                ESWorkspaceImpl esWorkspaceImpl = (ESWorkspaceImpl)ESWorkspaceProvider.INSTANCE.getWorkspace();
                WorkspaceBase workspace = (WorkspaceBase)esWorkspaceImpl.toInternalAPI();
                FuzzyProjectTest.this.projectSpace = workspace.createLocalProject("testProject", FuzzyProjectTest.this.project, false);
                if (FuzzyProjectTest.this.projectSpaceCopyNeeded()) {
                    FuzzyProjectTest.this.copyProjectSpace = ((WorkspaceBase)esWorkspaceImpl.toInternalAPI()).cloneProject("", FuzzyProjectTest.this.projectSpace.getProject());
                }
            }
        });
    }

    public void clearOperations() {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FuzzyProjectTest.this.getProjectSpace().getLocalChangePackage().clear();
                FuzzyProjectTest.this.getProjectSpace().getOperationManager().clearOperations();
                return null;
            }
        });
    }

    @After
    public void tearDown() {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    ESWorkspaceImpl currentWorkspace = (ESWorkspaceImpl)ESWorkspaceProvider.INSTANCE.getWorkspace();
                    EList projectSpaces = ((Workspace)currentWorkspace.toInternalAPI()).getProjectSpaces();
                    if (FuzzyProjectTest.this.projectSpace != null && projectSpaces.contains((Object)FuzzyProjectTest.this.projectSpace)) {
                        FuzzyProjectTest.this.projectSpace.delete((IProgressMonitor)new NullProgressMonitor());
                    }
                    if (FuzzyProjectTest.this.copyProjectSpace != null && projectSpaces.contains((Object)FuzzyProjectTest.this.copyProjectSpace)) {
                        FuzzyProjectTest.this.copyProjectSpace.delete((IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {}
                return null;
            }
        });
    }

    public ESModelMutatorConfiguration getModelMutatorConfiguration(Project project) {
        return FuzzyProjectTest.getModelMutatorConfiguration(project, this.util);
    }

    public static ESModelMutatorConfiguration getModelMutatorConfiguration(Project project, ESMutateUtil util) {
        ESModelMutatorConfiguration mmc = new ESModelMutatorConfiguration(util.getEPackages(), (EObject)project, Long.valueOf(1L));
        mmc.seteStructuralFeaturesToIgnore(util.getEStructuralFeaturesToIgnore());
        mmc.seteClassesToIgnore(util.getEClassesToIgnore());
        mmc.setEditingDomain(((ESWorkspaceProviderImpl)ESWorkspaceProvider.INSTANCE).getEditingDomain());
        mmc.setMinObjectsCount(util.getMinObjectsCount());
        return mmc;
    }

    public boolean projectSpaceCopyNeeded() {
        return true;
    }

    public void fail(Project project1, Project project2) {
        FuzzyProjectTest.fail(project1, project2, this.util);
    }

    public static void fail(Project project1, Project project2, ESMutateUtil util) {
        FuzzyProjectTest.save(project1, project2, util);
        Assert.fail((String)"Projects are not equal");
    }

    public static void save(final Project project1, final Project project2, final ESMutateUtil util) {
        final HashMap<String, String> options = new HashMap<String, String>();
        options.put("PROCESS_DANGLING_HREF", "DISCARD");
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                try {
                    ModelUtil.saveEObjectToResource(Arrays.asList(project1), (URI)util.getRunResourceURI("original"), (Map)options);
                    ModelUtil.saveEObjectToResource(Arrays.asList(project2), (URI)util.getRunResourceURI("copy"), (Map)options);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void compareIgnoreOrder(Project project1, Project project2) {
        FuzzyProjectTest.compareIgnoreOrder(project1, project2, this.util);
    }

    public static void compareIgnoreOrder(Project project1, Project project2, ESMutateUtil util) {
        if (project1.getModelElements().size() != project2.getModelElements().size()) {
            FuzzyProjectTest.fail(project1, project2, util);
        }
        int index = 0;
        for (EObject eObject1 : project1.getModelElements()) {
            ModelElementId modelElementId1 = project1.getModelElementId(eObject1);
            EObject eObject2 = project2.getModelElement(modelElementId1);
            if (eObject2 == null || !project2.getModelElements().contains((Object)eObject2)) {
                FuzzyProjectTest.fail(project1, project2, util);
            }
            project2.getModelElements().move(index, (Object)eObject2);
            ++index;
        }
        if (!ModelUtil.areEqual((IdEObjectCollection)project1, (IdEObjectCollection)project2)) {
            FuzzyProjectTest.fail(project1, project2, util);
        }
    }

    public ESMutateUtil getUtil() {
        return this.util;
    }

    public ProjectSpace getProjectSpace() {
        return this.projectSpace;
    }

    public void setProjectSpace(ProjectSpace projectSpace) {
        this.projectSpace = projectSpace;
    }

    public ProjectSpace getCopyProjectSpace() throws IllegalStateException {
        if (!this.projectSpaceCopyNeeded()) {
            throw new IllegalStateException("This test does not have a copied projectSpace!");
        }
        return this.copyProjectSpace;
    }

    public void setCopyProjectSpace(ProjectSpace copyProjectSpace) throws IllegalStateException {
        if (!this.projectSpaceCopyNeeded()) {
            throw new IllegalStateException("This test does not have a copied projectSpace!");
        }
        this.copyProjectSpace = copyProjectSpace;
    }
}

