/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.misc.precompilation;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setGeneralURI("/jsp/spec/misc/precompilation");
        this.setContextRoot("/jsp_misc_precompilation_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_misc_precompilation_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_misc_precompilation_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/precompile.jsp")), "precompile.jsp");
        return archive;
    }

    @Test
    public void precompileNoValueTest() throws Exception {
        String testName = "precompileNoValue";
        TEST_PROPS.setProperty("testname", testName + "Test");
        TEST_PROPS.setProperty("request", "GET /jsp_misc_precompilation_web/precompile.jsp?jsp_precompile HTTP/1.0");
        TEST_PROPS.setProperty("unexpected_response_match", "Got the Request");
        this.invoke();
    }

    @Test
    public void precompileFalseTest() throws Exception {
        String testName = "precompileFalse";
        TEST_PROPS.setProperty("testname", testName + "Test");
        TEST_PROPS.setProperty("request", "GET /jsp_misc_precompilation_web/precompile.jsp?jsp_precompile=false HTTP/1.0");
        TEST_PROPS.setProperty("unexpected_response_match", "Got the Request");
        this.invoke();
    }

    @Test
    public void precompileTrueTest() throws Exception {
        String testName = "precompileTrue";
        TEST_PROPS.setProperty("testname", testName + "Test");
        TEST_PROPS.setProperty("request", "GET /jsp_misc_precompilation_web/precompile.jsp?jsp_precompile=true HTTP/1.0");
        TEST_PROPS.setProperty("unexpected_response_match", "Got the Request");
        this.invoke();
    }

    @Test
    public void precompileNegativeTest() throws Exception {
        String testName = "precompileNegative";
        TEST_PROPS.setProperty("testname", testName + "Test");
        TEST_PROPS.setProperty("request", "GET /jsp_misc_precompilation_web/precompile.jsp?jsp_precompile=any_invalid_value HTTP/1.0");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

