/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.filters;

import com.sun.ts.tests.jstl.common.JstlTckConstants;
import com.sun.ts.tests.jstl.common.wrappers.TckDataSourceWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.tools.ant.util.StringUtils;

public class JstlDbFilter
implements Filter,
JstlTckConstants {
    private FilterConfig _config = null;
    private ServletContext _context;
    private boolean _debug = true;

    private void addDataSource(HttpServletRequest req) throws IOException, ServletException {
        if (this._context.getAttribute("jstlDS") != null && this._context.getAttribute("logDS") != null) {
            return;
        }
        String url = req.getHeader("jstl.db.url");
        url = this.escapeComma(url);
        String driver = req.getHeader("jstl.db.driver");
        String user = req.getHeader("jstl.db.user");
        String password = req.getHeader("jstl.db.password");
        this.trace("Creating TckDataSourceWrapper...");
        TckDataSourceWrapper ds = new TckDataSourceWrapper();
        try {
            ds.setDriverClassName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        ds.setJdbcURL(url);
        ds.setUserName(user);
        ds.setPassword(password);
        this.trace("TckDataSourceWrapper, jstlDS, created: " + String.valueOf(ds));
        this.trace("TckDataSourceWrapper info: " + ds.getDSInfo());
        this._context.setAttribute("jstlDS", (Object)ds);
        this.trace("Creating TckDataSourceWrapper that returns wrapped Connections...");
        TckDataSourceWrapper dsw = new TckDataSourceWrapper(this._context);
        try {
            dsw.setDriverClassName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        dsw.setJdbcURL(url);
        dsw.setUserName(user);
        dsw.setPassword(password);
        this.trace("TckDataSourceWrapper, logDS, created: " + String.valueOf(dsw));
        this.trace("TckDataSourceWrapper info: " + dsw.getDSInfo());
        this._context.setAttribute("logDS", (Object)dsw);
    }

    public void init(FilterConfig config) {
        this._config = config;
        this._context = this._config.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        this.addDataSource(req);
        chain.doFilter((ServletRequest)req, response);
    }

    public void destroy() {
        this._config = null;
    }

    private void trace(String buf) {
        if (this._debug) {
            System.out.println("[JstlDbFilter] " + buf);
        }
    }

    private String escapeComma(String url) {
        if (url == null) {
            return url;
        }
        int comma = url.indexOf(44);
        if (comma == -1) {
            return url;
        }
        String result = StringUtils.replace((String)url, (String)",", (String)"\\,");
        return result;
    }
}

