/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.commonee;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.EETest;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.util.Enumeration;
import java.util.Properties;

public class Client
extends EETest {
    protected TSNamingContextInterface context = null;
    protected Properties props = null;
    protected Queue rcvrQueue;
    protected QueueConnection qConnect;
    protected QueueSession session;
    protected QueueConnectionFactory qFactory;
    protected QueueSender qSender;
    protected TopicConnection tConnect;
    protected TopicSession tSession;
    protected TopicConnectionFactory tFactory;
    protected TopicPublisher tPub;
    protected String jmsUser = null;
    protected String jmsPassword = null;
    protected String hostname = null;
    protected String traceFlag = null;
    protected String logPort = null;
    protected TextMessage msg = null;
    protected long timeout = 0L;

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        try {
            this.jmsUser = TestUtil.getProperty(p, "user");
            if (this.jmsUser == null) {
                TestUtil.logTrace("user is null");
                throw new Exception("Error getting user");
            }
            this.jmsPassword = TestUtil.getProperty(p, "password");
            if (this.jmsPassword == null) {
                TestUtil.logTrace("password is null");
                throw new Exception("Error getting password");
            }
            String time = TestUtil.getProperty(p, "jms_timeout");
            if (time == null) {
                TestUtil.logTrace("jms_timeout is null");
                throw new Exception("Error getting jms_timeout");
            }
            this.hostname = TestUtil.getProperty(p, "harness.host");
            if (this.hostname == null) {
                TestUtil.logTrace("harness.host is null");
                throw new Exception("Error getting harness.host");
            }
            this.traceFlag = TestUtil.getProperty(p, "harness.log.traceflag");
            if (this.traceFlag == null) {
                TestUtil.logTrace("harness.log.traceflag is null");
                throw new Exception("Error getting harness.log.traceflag");
            }
            this.logPort = TestUtil.getProperty(p, "harness.log.port");
            if (this.logPort == null) {
                TestUtil.logTrace("harness.log.port is null");
                throw new Exception("Error getting harness.log.port");
            }
            this.timeout = Long.parseLong(time);
            TestUtil.logTrace("in client setup");
            this.context = new TSNamingContext();
            TestUtil.logTrace("Client: Do lookups!");
            this.rcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            this.session = this.qConnect.createQueueSession(false, 1);
            this.qConnect.start();
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            this.tConnect = this.tFactory.createTopicConnection(this.jmsUser, this.jmsPassword);
            this.tSession = this.tConnect.createTopicSession(false, 1);
            this.tConnect.start();
            TestUtil.logTrace("get the connection and starter up");
            TestUtil.logTrace("Client: connection started, now send initialization msg!");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    protected void createTestMessage(String TestCase2, int num) {
        String myMessage = "MDB deploy tests";
        String key = null;
        try {
            this.msg = this.session.createTextMessage();
            Enumeration<?> e = this.props.propertyNames();
            this.msg.setStringProperty("user", this.jmsUser);
            this.msg.setStringProperty("password", this.jmsPassword);
            this.msg.setStringProperty("harnesshost", this.hostname);
            this.msg.setStringProperty("harnesslogtraceflag", this.traceFlag);
            this.msg.setStringProperty("harnesslogport", this.logPort);
            e = this.props.propertyNames();
            key = null;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.contains("-") || key.contains(".") || key.contains("***")) continue;
                String value = TestUtil.getProperty(this.props, key);
                try {
                    this.msg.setStringProperty(key, value);
                }
                catch (JMSException jMSException) {}
            }
            this.msg.setText(myMessage);
            this.msg.setIntProperty("TestCaseNum", num);
            this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", TestCase2);
        }
        catch (Exception ee) {
            TestUtil.printStackTrace(ee);
            TestUtil.logMsg("key was: " + key);
            TestUtil.logMsg("props was: " + this.props.getProperty(key));
            TestUtil.logMsg("Error setting properties");
        }
    }

    public boolean checkOnResponse(String TestCase2) {
        boolean status = false;
        try {
            TestUtil.logMsg("@checkOnResponse");
            status = this.recvMessageInternal(this.session, TestCase2);
            TestUtil.logMsg("Close the session");
        }
        catch (Exception e) {
            TestUtil.printStackTrace(e);
        }
        return status;
    }

    protected boolean recvMessageInternal(QueueSession session, String TestCase2) throws JMSException {
        boolean retcode = false;
        TestUtil.logMsg("@recvMessageInternal");
        QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
        Message msgRec = null;
        for (int i = 0; i < 10; ++i) {
            TestUtil.logMsg("@recvMessageInternal trying to receive the message: " + i);
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null) break;
        }
        if (msgRec != null) {
            if (msgRec instanceof TextMessage) {
                TestUtil.logMsg("**** Received msg text = " + ((TextMessage)msgRec).getText() + " ****");
            }
            TestUtil.logMsg("**** Received msg getStringProperty('TestCase') = " + msgRec.getStringProperty("TestCase"));
            TestUtil.logMsg("**** Received msg getStringProperty('Status') = " + msgRec.getStringProperty("Status"));
            if (msgRec.getStringProperty("TestCase") == null || msgRec.getStringProperty("Status") == null) {
                TestUtil.logMsg("Fail: unexpected message received from MDB_QUEUE_REPLY msgRec=" + String.valueOf(msgRec));
            } else if (msgRec.getStringProperty("TestCase").equals(TestCase2) && msgRec.getStringProperty("Status").equals("Pass")) {
                TestUtil.logMsg("TestCase: " + msgRec.getStringProperty("TestCase"));
                TestUtil.logMsg("Status from msg: " + msgRec.getStringProperty("Status"));
                TestUtil.logMsg("Pass: we got the expected msg back! ");
                retcode = true;
            } else if (msgRec.getStringProperty("Status").equals("Fail")) {
                TestUtil.logMsg("TestCase: " + msgRec.getStringProperty("TestCase"));
                TestUtil.logMsg("Status from msg: " + msgRec.getStringProperty("Status"));
                TestUtil.logMsg("Fail: Error(s) occurred! ");
            } else {
                TestUtil.logMsg("Fail: we didnt get the expected msg back! ");
                TestUtil.logMsg("TestCase:  " + msgRec.getStringProperty("TestCase"));
            }
        } else if (msgRec == null) {
            TestUtil.logMsg("Fail: we didnt get any msg back! ");
        }
        return retcode;
    }

    public void cleanup() throws Exception {
        try {
            this.closeDefaultConnections();
            this.flushQueue();
        }
        catch (Exception e) {
            TestUtil.logErr("Cleanup error: " + e.toString());
            TestUtil.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueue() throws Exception {
        QueueConnection qc = null;
        QueueReceiver qr = null;
        QueueSession qs = null;
        int numMsgsFlushed = 0;
        try {
            qc = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            qs = qc.createQueueSession(false, 1);
            qc.start();
            qr = qs.createReceiver(this.rcvrQueue);
            Message msg = qr.receive(this.timeout);
            while (msg != null) {
                if (msg instanceof TextMessage) {
                    TestUtil.logMsg("**** Flushed TextMessage =" + ((TextMessage)msg).getText() + " ****");
                } else {
                    String msgType = "Message";
                    if (msg instanceof BytesMessage) {
                        msgType = "BytesMessage";
                    } else if (msg instanceof MapMessage) {
                        msgType = "MapMessage";
                    } else if (msg instanceof ObjectMessage) {
                        msgType = "ObjectMessage";
                    } else if (msg instanceof StreamMessage) {
                        msgType = "StreamMessage";
                    }
                    TestUtil.logMsg("**** Flushed Message of type " + msgType + " ****");
                }
                ++numMsgsFlushed;
                msg = qr.receiveNoWait();
            }
            if (numMsgsFlushed > 0) {
                TestUtil.logMsg("flushed " + numMsgsFlushed + " messages");
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Cleanup error attempting to flush Queue: " + e.toString());
            TestUtil.printStackTrace(e);
        }
        finally {
            qc.close();
        }
    }

    public void closeDefaultConnections() throws Exception {
        try {
            if (this.qConnect != null) {
                TestUtil.logMsg("Client: Closing QueueConnection");
                this.qConnect.close();
            }
            if (this.tConnect != null) {
                TestUtil.logMsg("Client: Closing TopicConnection");
                this.tConnect.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Cleanup error: " + e.toString());
            TestUtil.printStackTrace(e);
        }
    }
}

