/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosfolder.h"

UosFolder *uos_folder_new(UosFolderType type,
                   const gchar *name,
                          const gchar *path){
    return folder_new(type,name,path);
}

void uos_folder_local_folder_init(UosFolder *folder,
                              const gchar *name,
                              const gchar *path){
    folder_local_folder_init(folder,name,path);
}

void uos_folder_remote_folder_init(UosFolder *folder,
                               const gchar *name,
                               const gchar *path){
    folder_remote_folder_init(folder,name,path);
}

void uos_folder_destroy(UosFolder *folder){
    folder_destroy(folder);
}

void uos_folder_clear(UosFolder *folder){
    folder_clear(folder);
}

void uos_folder_local_folder_destroy(UosLocalFolder *lfolder){
    folder_local_folder_destroy(lfolder);
}

void uos_folder_remote_folder_destroy(UosRemoteFolder *rfolder){
    folder_remote_folder_destroy(rfolder);
}


gint uos_folder_remote_folder_destroy_all_sessions(void){
    return folder_remote_folder_destroy_all_sessions();
}


gboolean uos_folder_remote_folder_is_session_active(UosRemoteFolder *rfolder){
    return folder_remote_folder_is_session_active(rfolder);
}

gboolean uos_folder_remote_folder_active_session_exist(void){
    return folder_remote_folder_active_session_exist();
}


gint uos_folder_scan_tree(UosFolder *folder){
    return folder_scan_tree(folder);
}

gint uos_folder_create_tree(UosFolder *folder){
    return folder_create_tree(folder);
}


UosFolderItem *uos_folder_item_new(const gchar *name,
                            const gchar *path){
    return folder_item_new(name,path);
}

void uos_folder_item_append(UosFolderItem *parent,
                        UosFolderItem *item){
    folder_item_append(parent,item);
}

UosFolderItem *uos_folder_item_copy(UosFolderItem *item){
    return folder_item_copy(item);
}

void uos_folder_item_remove(UosFolderItem *item){
    folder_item_remove(item);
}

void uos_folder_item_remove_children(UosFolderItem *item){
    folder_item_remove_children(item);
}

void uos_folder_item_destroy(UosFolderItem *item){
    folder_item_destroy(item);
}


gint uos_folder_item_compare(UosFolderItem *item_a,
                         UosFolderItem *item_b){
    return folder_item_compare(item_a,item_b);
}

UosFolderUIFunc2 uos_folder_get_ui_func2(UosFolder *folder){
    return folder_get_ui_func2(folder);
}

gboolean uos_folder_call_ui_func2(UosFolder *folder,
                              UosFolderItem *item,
                              guint count,
                              guint total){
    return folder_call_ui_func2(folder,item,count,total);
}


void uos_folder_set_name(UosFolder *folder,
                     const gchar *name){
    folder_set_name(folder,name);
}

void uos_folder_tree_destroy(UosFolder *folder){
    folder_tree_destroy(folder);
}


void uos_folder_add(UosFolder *folder){
    folder_add(folder);
}

GList *uos_folder_get_list(void){
    return folder_get_list();
}

void uos_folder_list_free(void){
    folder_list_free();
}

gint uos_folder_read_list(void){
    return folder_read_list();
}

void uos_folder_write_list(void){
    folder_write_list();
}


gchar *uos_folder_get_status(GPtrArray *folders,
                         gboolean full){
    return folder_get_status(folders,full);
}


UosFolder *uos_folder_find_from_path(const gchar *path){
    return folder_find_from_path(path);
}

UosFolder *uos_folder_find_from_name(const gchar *name,
                              UosFolderType type){
    return folder_find_from_name(name,type);
}

UosFolderItem *uos_folder_find_item_from_path(const gchar *path){
    return folder_find_item_from_path(path);
}

UosFolderItem *uos_folder_find_child_item_by_name(UosFolderItem *item,
                                           const gchar *name){
    return folder_find_child_item_by_name(item,name);
}

gchar *uos_folder_get_identifier(UosFolder *folder){
    return folder_get_identifier(folder);
}

gchar *uos_folder_item_get_identifier(UosFolderItem *item){
    return folder_item_get_identifier(item);
}

UosFolderItem *uos_folder_find_item_from_identifier(const gchar *identifier){
    return folder_find_item_from_identifier(identifier);
}

UosFolderItem *uos_folder_find_item_and_num_from_id(const gchar *identifier,
                                             gint *num){
    return folder_find_item_and_num_from_id(identifier,num);
}


UosFolder *uos_folder_get_default_folder(void){
    return folder_get_default_folder();
}

UosFolderItem *uos_folder_get_default_inbox(void){
    return folder_get_default_inbox();
}

UosFolderItem *uos_folder_get_default_outbox(void){
    return folder_get_default_outbox();
}

UosFolderItem *uos_folder_get_default_draft(void){
    return folder_get_default_draft();
}

UosFolderItem *uos_folder_get_default_queue(void){
    return folder_get_default_queue();
}

UosFolderItem *uos_folder_get_default_trash(void){
    return folder_get_default_trash();
}

UosFolderItem *uos_folder_get_default_junk(void){
    return folder_get_default_junk();
}


gboolean uos_folder_item_is_trash(UosFolderItem *item){
    return folder_item_is_trash(item);
}


UosFolderItem *uos_folder_get_junk(UosFolder *folder){
    return folder_get_junk(folder);
}

void uos_folder_set_junk(UosFolder *folder,
                     UosFolderItem *item){
    folder_set_junk(folder,item);
}


void uos_folder_set_missing_folders(void){
    folder_set_missing_folders();
}

void uos_folder_unref_account_all(UosPrefsAccount *account){
    folder_unref_account_all(account);
}

gchar *uos_folder_get_path(UosFolder *folder){
    return folder_get_path(folder);
}

gchar *uos_folder_item_get_path(UosFolderItem *item){
    return folder_item_get_path(item);
}


gint uos_folder_item_scan(UosFolderItem *item){
    return folder_item_scan(item);
}

void uos_folder_item_scan_foreach(GHashTable *table){
    folder_item_scan_foreach(table);
}

void uos_folder_item_scan_foreach_cache(GHashTable *table){
    folder_item_scan_foreach_cache(table);
}

GSList *uos_folder_item_get_msg_list(UosFolderItem *item,
                                 gboolean use_cache){
    return folder_item_get_msg_list(item,use_cache);
}

GSList *uos_folder_item_get_uncached_msg_list(UosFolderItem *item){
    return folder_item_get_uncached_msg_list(item);
}

/* return value is filename encoding */
gchar *uos_folder_item_fetch_msg(UosFolderItem *item,
                             gint num){
    return folder_item_fetch_msg(item,num);
}

gint uos_folder_fetch_all_msg(UosFolder *folder, gint *newdownload, gint *newindexdownload){
    return folder_fetch_all_msg(folder, newdownload, newindexdownload);
}

gint uos_folder_item_fetch_all_msg_self(UosFolderItem *item, gint *newdownload){
    return folder_item_fetch_all_msg_self(item, newdownload);
}

gint uos_folder_item_fetch_all_msg(UosFolderItem *item){
    return folder_item_fetch_all_msg(item);
}

UosMsgInfo *uos_folder_item_get_msginfo(UosFolderItem *item,
                                 gint num){
    return folder_item_get_msginfo(item,num);
}

gint uos_folder_item_add_msg(UosFolderItem *dest,
                         const gchar *file,
                         UosMsgFlags *flags,
                         gboolean remove_source){
    return folder_item_add_msg(dest,file,flags,remove_source);
}

gint uos_folder_item_add_msgs(UosFolderItem *dest,
                          GSList *file_list,
                          gboolean remove_source,
                          gint *first){
    return folder_item_add_msgs(dest,file_list,remove_source,first);
}

gint uos_folder_item_add_msg_msginfo(UosFolderItem *dest,
                                 UosMsgInfo *msginfo,
                                 gboolean remove_source){
    return folder_item_add_msg_msginfo(dest,msginfo,remove_source);
}

gint uos_folder_item_add_msgs_msginfo(UosFolderItem *dest,
                                  GSList *msginfo_list,
                                  gboolean remove_source,
                                  gint *first){
    return folder_item_add_msgs_msginfo(dest,msginfo_list,remove_source,first);
}

gint uos_folder_item_move_msg(UosFolderItem *dest,
                          UosMsgInfo *msginfo){
    return folder_item_move_msg(dest,msginfo);
}

gint uos_folder_item_move_msgs(UosFolderItem *dest,
                           GSList *msglist){
    return folder_item_move_msgs(dest,msglist);
}

gint uos_folder_item_copy_msg(UosFolderItem *dest,
                          UosMsgInfo *msginfo){
    return folder_item_copy_msg(dest,msginfo);
}

gint uos_folder_item_copy_msgs(UosFolderItem *dest,
                           GSList *msglist){
    return folder_item_copy_msgs(dest,msglist);
}

gint uos_folder_item_remove_msg(UosFolderItem *item,
                            UosMsgInfo *msginfo){
    return folder_item_remove_msg(item,msginfo);
}

gint uos_folder_item_remove_msgs(UosFolderItem *item,
                             GSList *msglist){
    return folder_item_remove_msgs(item,msglist);
}

gint uos_folder_item_remove_all_msg(UosFolderItem *item){
    return folder_item_remove_all_msg(item);
}


gboolean uos_folder_item_is_msg_changed(UosFolderItem *item,
                                    UosMsgInfo *msginfo){
    return folder_item_is_msg_changed(item,msginfo);
}


gchar *uos_folder_item_get_cache_file(UosFolderItem *item){
    return folder_item_get_cache_file(item);
}

gchar *uos_folder_item_get_mark_file(UosFolderItem *item){
    return folder_item_get_mark_file(item);
}


gint uos_folder_item_close(UosFolderItem *item){
    return folder_item_close(item);
}

gchar *uos_folder_item_get_backup_file(UosFolderItem *item, int backup_type){
    return folder_item_get_backup_file(item, backup_type);
}

void uos_delete_backup_file(gchar *file){
    delete_backup_file(file);
}

