#!/usr/bin/guile-gnome-2 \
-e __main -s
!#

;; Copyright (C) 2018 Tommi Höynälänmaa
;; Distributed under GNU Lesser General Public License version 3,
;; see file doc/LGPL-3.

(import (guile))
(import (srfi srfi-1))
(import (rnrs exceptions))
(import (oop goops))

(import (th-scheme-utilities stdutils)
	(th-scheme-utilities parse-command-line)
	(th-scheme-utilities hrecord)
	(theme-d common theme-d-config)
	(theme-d runtime runtime0)
	(theme-d-gnome runtime gnome-support))

(import (g-wrap gw-wct))

(import (gnome gobject)
	(gnome pango)
	(gnome atk)
	(gnome gw gdk)
	(gnome gw gtk)
	(gnome gtk)
	(gnome gtk gdk-event))

(init-theme-d-config)

(define gl-theme-d-runtime-dir
  (get-theme-d-config-var 'runtime-dir))

(define gl-use-support-lib?
  (get-theme-d-config-var 'use-support-lib?))

(define gl-pretty-backtrace-support? #f)

(add-to-load-path ".")

(if gl-use-support-lib?
    (load-extension "libthemedsupport" "init_theme_d_support")
    (load-compiled (string-append gl-theme-d-runtime-dir
				  "/theme-d-alt-support.go")))

(define gl-custom-files0 (getenv "THEME_D_CUSTOM_CODE"))

(define gl-custom-files (if (string? gl-custom-files0)
			    (split-string gl-custom-files0 #\:)
			    '()))

(load-compiled (string-append gl-theme-d-runtime-dir "/runtime-theme-d-environment.go"))

(load-compiled (string-append gl-theme-d-runtime-dir "/theme-d-stdlib-support.go"))

(load-compiled (string-append gl-theme-d-runtime-dir "/prt.go"))

(for-each load-compiled gl-custom-files)

(define (__main args)
  (let* ((argd1 (make-hrecord <argument-descriptor> "no-verbose-errors" #f
			      (lambda () (set! gl-verbose-errors? #f))))
	 (argd2 (make-hrecord <argument-descriptor> "backtrace" #f
			      (lambda () (set! gl-backtrace? #t))))
	 (argd3 (make-hrecord <argument-descriptor> "pretty-backtrace" #f
			      (lambda () (set! gl-pretty-backtrace? #t))))
	 (args-without-cmd (cdr args))
	 (arg-descs (list argd1 argd2 argd3))
	 (proper-args '())
	 (handle-proper-args (lambda (proper-args1)
			       (set! proper-args proper-args1))))
    (parse-command-line args-without-cmd arg-descs handle-proper-args)
    (set! gl-l-command-line proper-args)
    (load-compiled (car proper-args))
    (if (and gl-pretty-backtrace?
	     (not gl-pretty-backtrace-support?))
	(begin
	  (display "Error: pretty backtrace support not linked.\n")
	  (exit 1)))
    (if (not gl-script?)
	(begin
;;	  (load-compiled (string-append gl-theme-d-runtime-dir "/"
;;					"os-main.go"))
	  (set! gl-enable-rte-exception-info? #t)
	  (guard (exc (else (my-error-exit-fwd exc)))
		 (os-main proper-args))))))
