// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use ffi;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::FromValueOptional;
use glib::value::SetValue;
use glib::value::Value;
use gobject_ffi;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum AxisUse {
    Ignore,
    X,
    Y,
    Pressure,
    Xtilt,
    Ytilt,
    Wheel,
    Distance,
    Rotation,
    Slider,
    Last,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for AxisUse {
    type GlibType = ffi::GdkAxisUse;

    fn to_glib(&self) -> ffi::GdkAxisUse {
        match *self {
            AxisUse::Ignore => ffi::GDK_AXIS_IGNORE,
            AxisUse::X => ffi::GDK_AXIS_X,
            AxisUse::Y => ffi::GDK_AXIS_Y,
            AxisUse::Pressure => ffi::GDK_AXIS_PRESSURE,
            AxisUse::Xtilt => ffi::GDK_AXIS_XTILT,
            AxisUse::Ytilt => ffi::GDK_AXIS_YTILT,
            AxisUse::Wheel => ffi::GDK_AXIS_WHEEL,
            AxisUse::Distance => ffi::GDK_AXIS_DISTANCE,
            AxisUse::Rotation => ffi::GDK_AXIS_ROTATION,
            AxisUse::Slider => ffi::GDK_AXIS_SLIDER,
            AxisUse::Last => ffi::GDK_AXIS_LAST,
            AxisUse::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkAxisUse> for AxisUse {
    fn from_glib(value: ffi::GdkAxisUse) -> Self {
        skip_assert_initialized!();
        match value {
            0 => AxisUse::Ignore,
            1 => AxisUse::X,
            2 => AxisUse::Y,
            3 => AxisUse::Pressure,
            4 => AxisUse::Xtilt,
            5 => AxisUse::Ytilt,
            6 => AxisUse::Wheel,
            7 => AxisUse::Distance,
            8 => AxisUse::Rotation,
            9 => AxisUse::Slider,
            10 => AxisUse::Last,
            value => AxisUse::__Unknown(value),
        }
    }
}

impl StaticType for AxisUse {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_axis_use_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for AxisUse {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for AxisUse {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for AxisUse {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum ByteOrder {
    LsbFirst,
    MsbFirst,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for ByteOrder {
    type GlibType = ffi::GdkByteOrder;

    fn to_glib(&self) -> ffi::GdkByteOrder {
        match *self {
            ByteOrder::LsbFirst => ffi::GDK_LSB_FIRST,
            ByteOrder::MsbFirst => ffi::GDK_MSB_FIRST,
            ByteOrder::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkByteOrder> for ByteOrder {
    fn from_glib(value: ffi::GdkByteOrder) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ByteOrder::LsbFirst,
            1 => ByteOrder::MsbFirst,
            value => ByteOrder::__Unknown(value),
        }
    }
}

impl StaticType for ByteOrder {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_byte_order_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ByteOrder {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ByteOrder {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ByteOrder {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum CrossingMode {
    Normal,
    Grab,
    Ungrab,
    GtkGrab,
    GtkUngrab,
    StateChanged,
    TouchBegin,
    TouchEnd,
    DeviceSwitch,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for CrossingMode {
    type GlibType = ffi::GdkCrossingMode;

    fn to_glib(&self) -> ffi::GdkCrossingMode {
        match *self {
            CrossingMode::Normal => ffi::GDK_CROSSING_NORMAL,
            CrossingMode::Grab => ffi::GDK_CROSSING_GRAB,
            CrossingMode::Ungrab => ffi::GDK_CROSSING_UNGRAB,
            CrossingMode::GtkGrab => ffi::GDK_CROSSING_GTK_GRAB,
            CrossingMode::GtkUngrab => ffi::GDK_CROSSING_GTK_UNGRAB,
            CrossingMode::StateChanged => ffi::GDK_CROSSING_STATE_CHANGED,
            CrossingMode::TouchBegin => ffi::GDK_CROSSING_TOUCH_BEGIN,
            CrossingMode::TouchEnd => ffi::GDK_CROSSING_TOUCH_END,
            CrossingMode::DeviceSwitch => ffi::GDK_CROSSING_DEVICE_SWITCH,
            CrossingMode::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkCrossingMode> for CrossingMode {
    fn from_glib(value: ffi::GdkCrossingMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => CrossingMode::Normal,
            1 => CrossingMode::Grab,
            2 => CrossingMode::Ungrab,
            3 => CrossingMode::GtkGrab,
            4 => CrossingMode::GtkUngrab,
            5 => CrossingMode::StateChanged,
            6 => CrossingMode::TouchBegin,
            7 => CrossingMode::TouchEnd,
            8 => CrossingMode::DeviceSwitch,
            value => CrossingMode::__Unknown(value),
        }
    }
}

impl StaticType for CrossingMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_crossing_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for CrossingMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for CrossingMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for CrossingMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum CursorType {
    XCursor,
    Arrow,
    BasedArrowDown,
    BasedArrowUp,
    Boat,
    Bogosity,
    BottomLeftCorner,
    BottomRightCorner,
    BottomSide,
    BottomTee,
    BoxSpiral,
    CenterPtr,
    Circle,
    Clock,
    CoffeeMug,
    Cross,
    CrossReverse,
    Crosshair,
    DiamondCross,
    Dot,
    Dotbox,
    DoubleArrow,
    DraftLarge,
    DraftSmall,
    DrapedBox,
    Exchange,
    Fleur,
    Gobbler,
    Gumby,
    Hand1,
    Hand2,
    Heart,
    Icon,
    IronCross,
    LeftPtr,
    LeftSide,
    LeftTee,
    Leftbutton,
    LlAngle,
    LrAngle,
    Man,
    Middlebutton,
    Mouse,
    Pencil,
    Pirate,
    Plus,
    QuestionArrow,
    RightPtr,
    RightSide,
    RightTee,
    Rightbutton,
    RtlLogo,
    Sailboat,
    SbDownArrow,
    SbHDoubleArrow,
    SbLeftArrow,
    SbRightArrow,
    SbUpArrow,
    SbVDoubleArrow,
    Shuttle,
    Sizing,
    Spider,
    Spraycan,
    Star,
    Target,
    Tcross,
    TopLeftArrow,
    TopLeftCorner,
    TopRightCorner,
    TopSide,
    TopTee,
    Trek,
    UlAngle,
    Umbrella,
    UrAngle,
    Watch,
    Xterm,
    LastCursor,
    BlankCursor,
    CursorIsPixmap,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for CursorType {
    type GlibType = ffi::GdkCursorType;

    fn to_glib(&self) -> ffi::GdkCursorType {
        match *self {
            CursorType::XCursor => ffi::GDK_X_CURSOR,
            CursorType::Arrow => ffi::GDK_ARROW,
            CursorType::BasedArrowDown => ffi::GDK_BASED_ARROW_DOWN,
            CursorType::BasedArrowUp => ffi::GDK_BASED_ARROW_UP,
            CursorType::Boat => ffi::GDK_BOAT,
            CursorType::Bogosity => ffi::GDK_BOGOSITY,
            CursorType::BottomLeftCorner => ffi::GDK_BOTTOM_LEFT_CORNER,
            CursorType::BottomRightCorner => ffi::GDK_BOTTOM_RIGHT_CORNER,
            CursorType::BottomSide => ffi::GDK_BOTTOM_SIDE,
            CursorType::BottomTee => ffi::GDK_BOTTOM_TEE,
            CursorType::BoxSpiral => ffi::GDK_BOX_SPIRAL,
            CursorType::CenterPtr => ffi::GDK_CENTER_PTR,
            CursorType::Circle => ffi::GDK_CIRCLE,
            CursorType::Clock => ffi::GDK_CLOCK,
            CursorType::CoffeeMug => ffi::GDK_COFFEE_MUG,
            CursorType::Cross => ffi::GDK_CROSS,
            CursorType::CrossReverse => ffi::GDK_CROSS_REVERSE,
            CursorType::Crosshair => ffi::GDK_CROSSHAIR,
            CursorType::DiamondCross => ffi::GDK_DIAMOND_CROSS,
            CursorType::Dot => ffi::GDK_DOT,
            CursorType::Dotbox => ffi::GDK_DOTBOX,
            CursorType::DoubleArrow => ffi::GDK_DOUBLE_ARROW,
            CursorType::DraftLarge => ffi::GDK_DRAFT_LARGE,
            CursorType::DraftSmall => ffi::GDK_DRAFT_SMALL,
            CursorType::DrapedBox => ffi::GDK_DRAPED_BOX,
            CursorType::Exchange => ffi::GDK_EXCHANGE,
            CursorType::Fleur => ffi::GDK_FLEUR,
            CursorType::Gobbler => ffi::GDK_GOBBLER,
            CursorType::Gumby => ffi::GDK_GUMBY,
            CursorType::Hand1 => ffi::GDK_HAND1,
            CursorType::Hand2 => ffi::GDK_HAND2,
            CursorType::Heart => ffi::GDK_HEART,
            CursorType::Icon => ffi::GDK_ICON,
            CursorType::IronCross => ffi::GDK_IRON_CROSS,
            CursorType::LeftPtr => ffi::GDK_LEFT_PTR,
            CursorType::LeftSide => ffi::GDK_LEFT_SIDE,
            CursorType::LeftTee => ffi::GDK_LEFT_TEE,
            CursorType::Leftbutton => ffi::GDK_LEFTBUTTON,
            CursorType::LlAngle => ffi::GDK_LL_ANGLE,
            CursorType::LrAngle => ffi::GDK_LR_ANGLE,
            CursorType::Man => ffi::GDK_MAN,
            CursorType::Middlebutton => ffi::GDK_MIDDLEBUTTON,
            CursorType::Mouse => ffi::GDK_MOUSE,
            CursorType::Pencil => ffi::GDK_PENCIL,
            CursorType::Pirate => ffi::GDK_PIRATE,
            CursorType::Plus => ffi::GDK_PLUS,
            CursorType::QuestionArrow => ffi::GDK_QUESTION_ARROW,
            CursorType::RightPtr => ffi::GDK_RIGHT_PTR,
            CursorType::RightSide => ffi::GDK_RIGHT_SIDE,
            CursorType::RightTee => ffi::GDK_RIGHT_TEE,
            CursorType::Rightbutton => ffi::GDK_RIGHTBUTTON,
            CursorType::RtlLogo => ffi::GDK_RTL_LOGO,
            CursorType::Sailboat => ffi::GDK_SAILBOAT,
            CursorType::SbDownArrow => ffi::GDK_SB_DOWN_ARROW,
            CursorType::SbHDoubleArrow => ffi::GDK_SB_H_DOUBLE_ARROW,
            CursorType::SbLeftArrow => ffi::GDK_SB_LEFT_ARROW,
            CursorType::SbRightArrow => ffi::GDK_SB_RIGHT_ARROW,
            CursorType::SbUpArrow => ffi::GDK_SB_UP_ARROW,
            CursorType::SbVDoubleArrow => ffi::GDK_SB_V_DOUBLE_ARROW,
            CursorType::Shuttle => ffi::GDK_SHUTTLE,
            CursorType::Sizing => ffi::GDK_SIZING,
            CursorType::Spider => ffi::GDK_SPIDER,
            CursorType::Spraycan => ffi::GDK_SPRAYCAN,
            CursorType::Star => ffi::GDK_STAR,
            CursorType::Target => ffi::GDK_TARGET,
            CursorType::Tcross => ffi::GDK_TCROSS,
            CursorType::TopLeftArrow => ffi::GDK_TOP_LEFT_ARROW,
            CursorType::TopLeftCorner => ffi::GDK_TOP_LEFT_CORNER,
            CursorType::TopRightCorner => ffi::GDK_TOP_RIGHT_CORNER,
            CursorType::TopSide => ffi::GDK_TOP_SIDE,
            CursorType::TopTee => ffi::GDK_TOP_TEE,
            CursorType::Trek => ffi::GDK_TREK,
            CursorType::UlAngle => ffi::GDK_UL_ANGLE,
            CursorType::Umbrella => ffi::GDK_UMBRELLA,
            CursorType::UrAngle => ffi::GDK_UR_ANGLE,
            CursorType::Watch => ffi::GDK_WATCH,
            CursorType::Xterm => ffi::GDK_XTERM,
            CursorType::LastCursor => ffi::GDK_LAST_CURSOR,
            CursorType::BlankCursor => ffi::GDK_BLANK_CURSOR,
            CursorType::CursorIsPixmap => ffi::GDK_CURSOR_IS_PIXMAP,
            CursorType::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkCursorType> for CursorType {
    fn from_glib(value: ffi::GdkCursorType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => CursorType::XCursor,
            2 => CursorType::Arrow,
            4 => CursorType::BasedArrowDown,
            6 => CursorType::BasedArrowUp,
            8 => CursorType::Boat,
            10 => CursorType::Bogosity,
            12 => CursorType::BottomLeftCorner,
            14 => CursorType::BottomRightCorner,
            16 => CursorType::BottomSide,
            18 => CursorType::BottomTee,
            20 => CursorType::BoxSpiral,
            22 => CursorType::CenterPtr,
            24 => CursorType::Circle,
            26 => CursorType::Clock,
            28 => CursorType::CoffeeMug,
            30 => CursorType::Cross,
            32 => CursorType::CrossReverse,
            34 => CursorType::Crosshair,
            36 => CursorType::DiamondCross,
            38 => CursorType::Dot,
            40 => CursorType::Dotbox,
            42 => CursorType::DoubleArrow,
            44 => CursorType::DraftLarge,
            46 => CursorType::DraftSmall,
            48 => CursorType::DrapedBox,
            50 => CursorType::Exchange,
            52 => CursorType::Fleur,
            54 => CursorType::Gobbler,
            56 => CursorType::Gumby,
            58 => CursorType::Hand1,
            60 => CursorType::Hand2,
            62 => CursorType::Heart,
            64 => CursorType::Icon,
            66 => CursorType::IronCross,
            68 => CursorType::LeftPtr,
            70 => CursorType::LeftSide,
            72 => CursorType::LeftTee,
            74 => CursorType::Leftbutton,
            76 => CursorType::LlAngle,
            78 => CursorType::LrAngle,
            80 => CursorType::Man,
            82 => CursorType::Middlebutton,
            84 => CursorType::Mouse,
            86 => CursorType::Pencil,
            88 => CursorType::Pirate,
            90 => CursorType::Plus,
            92 => CursorType::QuestionArrow,
            94 => CursorType::RightPtr,
            96 => CursorType::RightSide,
            98 => CursorType::RightTee,
            100 => CursorType::Rightbutton,
            102 => CursorType::RtlLogo,
            104 => CursorType::Sailboat,
            106 => CursorType::SbDownArrow,
            108 => CursorType::SbHDoubleArrow,
            110 => CursorType::SbLeftArrow,
            112 => CursorType::SbRightArrow,
            114 => CursorType::SbUpArrow,
            116 => CursorType::SbVDoubleArrow,
            118 => CursorType::Shuttle,
            120 => CursorType::Sizing,
            122 => CursorType::Spider,
            124 => CursorType::Spraycan,
            126 => CursorType::Star,
            128 => CursorType::Target,
            130 => CursorType::Tcross,
            132 => CursorType::TopLeftArrow,
            134 => CursorType::TopLeftCorner,
            136 => CursorType::TopRightCorner,
            138 => CursorType::TopSide,
            140 => CursorType::TopTee,
            142 => CursorType::Trek,
            144 => CursorType::UlAngle,
            146 => CursorType::Umbrella,
            148 => CursorType::UrAngle,
            150 => CursorType::Watch,
            152 => CursorType::Xterm,
            153 => CursorType::LastCursor,
            -2 => CursorType::BlankCursor,
            -1 => CursorType::CursorIsPixmap,
            value => CursorType::__Unknown(value),
        }
    }
}

impl StaticType for CursorType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_cursor_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for CursorType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for CursorType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for CursorType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum DevicePadFeature {
    Button,
    Ring,
    Strip,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for DevicePadFeature {
    type GlibType = ffi::GdkDevicePadFeature;

    fn to_glib(&self) -> ffi::GdkDevicePadFeature {
        match *self {
            DevicePadFeature::Button => ffi::GDK_DEVICE_PAD_FEATURE_BUTTON,
            DevicePadFeature::Ring => ffi::GDK_DEVICE_PAD_FEATURE_RING,
            DevicePadFeature::Strip => ffi::GDK_DEVICE_PAD_FEATURE_STRIP,
            DevicePadFeature::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkDevicePadFeature> for DevicePadFeature {
    fn from_glib(value: ffi::GdkDevicePadFeature) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DevicePadFeature::Button,
            1 => DevicePadFeature::Ring,
            2 => DevicePadFeature::Strip,
            value => DevicePadFeature::__Unknown(value),
        }
    }
}

impl StaticType for DevicePadFeature {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_device_pad_feature_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for DevicePadFeature {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for DevicePadFeature {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for DevicePadFeature {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum DeviceToolType {
    Unknown,
    Pen,
    Eraser,
    Brush,
    Pencil,
    Airbrush,
    Mouse,
    Lens,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for DeviceToolType {
    type GlibType = ffi::GdkDeviceToolType;

    fn to_glib(&self) -> ffi::GdkDeviceToolType {
        match *self {
            DeviceToolType::Unknown => ffi::GDK_DEVICE_TOOL_TYPE_UNKNOWN,
            DeviceToolType::Pen => ffi::GDK_DEVICE_TOOL_TYPE_PEN,
            DeviceToolType::Eraser => ffi::GDK_DEVICE_TOOL_TYPE_ERASER,
            DeviceToolType::Brush => ffi::GDK_DEVICE_TOOL_TYPE_BRUSH,
            DeviceToolType::Pencil => ffi::GDK_DEVICE_TOOL_TYPE_PENCIL,
            DeviceToolType::Airbrush => ffi::GDK_DEVICE_TOOL_TYPE_AIRBRUSH,
            DeviceToolType::Mouse => ffi::GDK_DEVICE_TOOL_TYPE_MOUSE,
            DeviceToolType::Lens => ffi::GDK_DEVICE_TOOL_TYPE_LENS,
            DeviceToolType::__Unknown(value) => value
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<ffi::GdkDeviceToolType> for DeviceToolType {
    fn from_glib(value: ffi::GdkDeviceToolType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DeviceToolType::Unknown,
            1 => DeviceToolType::Pen,
            2 => DeviceToolType::Eraser,
            3 => DeviceToolType::Brush,
            4 => DeviceToolType::Pencil,
            5 => DeviceToolType::Airbrush,
            6 => DeviceToolType::Mouse,
            7 => DeviceToolType::Lens,
            value => DeviceToolType::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl StaticType for DeviceToolType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_device_tool_type_get_type()) }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValueOptional<'a> for DeviceToolType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValue<'a> for DeviceToolType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl SetValue for DeviceToolType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum DeviceType {
    Master,
    Slave,
    Floating,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for DeviceType {
    type GlibType = ffi::GdkDeviceType;

    fn to_glib(&self) -> ffi::GdkDeviceType {
        match *self {
            DeviceType::Master => ffi::GDK_DEVICE_TYPE_MASTER,
            DeviceType::Slave => ffi::GDK_DEVICE_TYPE_SLAVE,
            DeviceType::Floating => ffi::GDK_DEVICE_TYPE_FLOATING,
            DeviceType::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkDeviceType> for DeviceType {
    fn from_glib(value: ffi::GdkDeviceType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DeviceType::Master,
            1 => DeviceType::Slave,
            2 => DeviceType::Floating,
            value => DeviceType::__Unknown(value),
        }
    }
}

impl StaticType for DeviceType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_device_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for DeviceType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for DeviceType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for DeviceType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum DragCancelReason {
    NoTarget,
    UserCancelled,
    Error,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for DragCancelReason {
    type GlibType = ffi::GdkDragCancelReason;

    fn to_glib(&self) -> ffi::GdkDragCancelReason {
        match *self {
            DragCancelReason::NoTarget => ffi::GDK_DRAG_CANCEL_NO_TARGET,
            DragCancelReason::UserCancelled => ffi::GDK_DRAG_CANCEL_USER_CANCELLED,
            DragCancelReason::Error => ffi::GDK_DRAG_CANCEL_ERROR,
            DragCancelReason::__Unknown(value) => value
        }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<ffi::GdkDragCancelReason> for DragCancelReason {
    fn from_glib(value: ffi::GdkDragCancelReason) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DragCancelReason::NoTarget,
            1 => DragCancelReason::UserCancelled,
            2 => DragCancelReason::Error,
            value => DragCancelReason::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
impl StaticType for DragCancelReason {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_drag_cancel_reason_get_type()) }
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
impl<'a> FromValueOptional<'a> for DragCancelReason {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
impl<'a> FromValue<'a> for DragCancelReason {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
impl SetValue for DragCancelReason {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum DragProtocol {
    None,
    Motif,
    Xdnd,
    Rootwin,
    Win32Dropfiles,
    Ole2,
    Local,
    Wayland,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for DragProtocol {
    type GlibType = ffi::GdkDragProtocol;

    fn to_glib(&self) -> ffi::GdkDragProtocol {
        match *self {
            DragProtocol::None => ffi::GDK_DRAG_PROTO_NONE,
            DragProtocol::Motif => ffi::GDK_DRAG_PROTO_MOTIF,
            DragProtocol::Xdnd => ffi::GDK_DRAG_PROTO_XDND,
            DragProtocol::Rootwin => ffi::GDK_DRAG_PROTO_ROOTWIN,
            DragProtocol::Win32Dropfiles => ffi::GDK_DRAG_PROTO_WIN32_DROPFILES,
            DragProtocol::Ole2 => ffi::GDK_DRAG_PROTO_OLE2,
            DragProtocol::Local => ffi::GDK_DRAG_PROTO_LOCAL,
            DragProtocol::Wayland => ffi::GDK_DRAG_PROTO_WAYLAND,
            DragProtocol::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkDragProtocol> for DragProtocol {
    fn from_glib(value: ffi::GdkDragProtocol) -> Self {
        skip_assert_initialized!();
        match value {
            0 => DragProtocol::None,
            1 => DragProtocol::Motif,
            2 => DragProtocol::Xdnd,
            3 => DragProtocol::Rootwin,
            4 => DragProtocol::Win32Dropfiles,
            5 => DragProtocol::Ole2,
            6 => DragProtocol::Local,
            7 => DragProtocol::Wayland,
            value => DragProtocol::__Unknown(value),
        }
    }
}

impl StaticType for DragProtocol {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_drag_protocol_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for DragProtocol {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for DragProtocol {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for DragProtocol {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum EventType {
    Nothing,
    Delete,
    Destroy,
    Expose,
    MotionNotify,
    ButtonPress,
    DoubleButtonPress,
    TripleButtonPress,
    ButtonRelease,
    KeyPress,
    KeyRelease,
    EnterNotify,
    LeaveNotify,
    FocusChange,
    Configure,
    Map,
    Unmap,
    PropertyNotify,
    SelectionClear,
    SelectionRequest,
    SelectionNotify,
    ProximityIn,
    ProximityOut,
    DragEnter,
    DragLeave,
    DragMotion,
    DragStatus,
    DropStart,
    DropFinished,
    ClientEvent,
    VisibilityNotify,
    Scroll,
    WindowState,
    Setting,
    OwnerChange,
    GrabBroken,
    Damage,
    TouchBegin,
    TouchUpdate,
    TouchEnd,
    TouchCancel,
    #[cfg(any(feature = "v3_18", feature = "dox"))]
    TouchpadSwipe,
    #[cfg(any(feature = "v3_18", feature = "dox"))]
    TouchpadPinch,
    PadButtonPress,
    PadButtonRelease,
    PadRing,
    PadStrip,
    PadGroupMode,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for EventType {
    type GlibType = ffi::GdkEventType;

    fn to_glib(&self) -> ffi::GdkEventType {
        match *self {
            EventType::Nothing => ffi::GDK_NOTHING,
            EventType::Delete => ffi::GDK_DELETE,
            EventType::Destroy => ffi::GDK_DESTROY,
            EventType::Expose => ffi::GDK_EXPOSE,
            EventType::MotionNotify => ffi::GDK_MOTION_NOTIFY,
            EventType::ButtonPress => ffi::GDK_BUTTON_PRESS,
            EventType::DoubleButtonPress => ffi::GDK_DOUBLE_BUTTON_PRESS,
            EventType::TripleButtonPress => ffi::GDK_TRIPLE_BUTTON_PRESS,
            EventType::ButtonRelease => ffi::GDK_BUTTON_RELEASE,
            EventType::KeyPress => ffi::GDK_KEY_PRESS,
            EventType::KeyRelease => ffi::GDK_KEY_RELEASE,
            EventType::EnterNotify => ffi::GDK_ENTER_NOTIFY,
            EventType::LeaveNotify => ffi::GDK_LEAVE_NOTIFY,
            EventType::FocusChange => ffi::GDK_FOCUS_CHANGE,
            EventType::Configure => ffi::GDK_CONFIGURE,
            EventType::Map => ffi::GDK_MAP,
            EventType::Unmap => ffi::GDK_UNMAP,
            EventType::PropertyNotify => ffi::GDK_PROPERTY_NOTIFY,
            EventType::SelectionClear => ffi::GDK_SELECTION_CLEAR,
            EventType::SelectionRequest => ffi::GDK_SELECTION_REQUEST,
            EventType::SelectionNotify => ffi::GDK_SELECTION_NOTIFY,
            EventType::ProximityIn => ffi::GDK_PROXIMITY_IN,
            EventType::ProximityOut => ffi::GDK_PROXIMITY_OUT,
            EventType::DragEnter => ffi::GDK_DRAG_ENTER,
            EventType::DragLeave => ffi::GDK_DRAG_LEAVE,
            EventType::DragMotion => ffi::GDK_DRAG_MOTION,
            EventType::DragStatus => ffi::GDK_DRAG_STATUS,
            EventType::DropStart => ffi::GDK_DROP_START,
            EventType::DropFinished => ffi::GDK_DROP_FINISHED,
            EventType::ClientEvent => ffi::GDK_CLIENT_EVENT,
            EventType::VisibilityNotify => ffi::GDK_VISIBILITY_NOTIFY,
            EventType::Scroll => ffi::GDK_SCROLL,
            EventType::WindowState => ffi::GDK_WINDOW_STATE,
            EventType::Setting => ffi::GDK_SETTING,
            EventType::OwnerChange => ffi::GDK_OWNER_CHANGE,
            EventType::GrabBroken => ffi::GDK_GRAB_BROKEN,
            EventType::Damage => ffi::GDK_DAMAGE,
            EventType::TouchBegin => ffi::GDK_TOUCH_BEGIN,
            EventType::TouchUpdate => ffi::GDK_TOUCH_UPDATE,
            EventType::TouchEnd => ffi::GDK_TOUCH_END,
            EventType::TouchCancel => ffi::GDK_TOUCH_CANCEL,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            EventType::TouchpadSwipe => ffi::GDK_TOUCHPAD_SWIPE,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            EventType::TouchpadPinch => ffi::GDK_TOUCHPAD_PINCH,
            EventType::PadButtonPress => ffi::GDK_PAD_BUTTON_PRESS,
            EventType::PadButtonRelease => ffi::GDK_PAD_BUTTON_RELEASE,
            EventType::PadRing => ffi::GDK_PAD_RING,
            EventType::PadStrip => ffi::GDK_PAD_STRIP,
            EventType::PadGroupMode => ffi::GDK_PAD_GROUP_MODE,
            EventType::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkEventType> for EventType {
    fn from_glib(value: ffi::GdkEventType) -> Self {
        skip_assert_initialized!();
        match value {
            -1 => EventType::Nothing,
            0 => EventType::Delete,
            1 => EventType::Destroy,
            2 => EventType::Expose,
            3 => EventType::MotionNotify,
            4 => EventType::ButtonPress,
            5 => EventType::DoubleButtonPress,
            6 => EventType::TripleButtonPress,
            7 => EventType::ButtonRelease,
            8 => EventType::KeyPress,
            9 => EventType::KeyRelease,
            10 => EventType::EnterNotify,
            11 => EventType::LeaveNotify,
            12 => EventType::FocusChange,
            13 => EventType::Configure,
            14 => EventType::Map,
            15 => EventType::Unmap,
            16 => EventType::PropertyNotify,
            17 => EventType::SelectionClear,
            18 => EventType::SelectionRequest,
            19 => EventType::SelectionNotify,
            20 => EventType::ProximityIn,
            21 => EventType::ProximityOut,
            22 => EventType::DragEnter,
            23 => EventType::DragLeave,
            24 => EventType::DragMotion,
            25 => EventType::DragStatus,
            26 => EventType::DropStart,
            27 => EventType::DropFinished,
            28 => EventType::ClientEvent,
            29 => EventType::VisibilityNotify,
            31 => EventType::Scroll,
            32 => EventType::WindowState,
            33 => EventType::Setting,
            34 => EventType::OwnerChange,
            35 => EventType::GrabBroken,
            36 => EventType::Damage,
            37 => EventType::TouchBegin,
            38 => EventType::TouchUpdate,
            39 => EventType::TouchEnd,
            40 => EventType::TouchCancel,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            41 => EventType::TouchpadSwipe,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            42 => EventType::TouchpadPinch,
            43 => EventType::PadButtonPress,
            44 => EventType::PadButtonRelease,
            45 => EventType::PadRing,
            46 => EventType::PadStrip,
            47 => EventType::PadGroupMode,
            value => EventType::__Unknown(value),
        }
    }
}

impl StaticType for EventType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_event_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for EventType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for EventType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for EventType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_8", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum FullscreenMode {
    CurrentMonitor,
    AllMonitors,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_8", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for FullscreenMode {
    type GlibType = ffi::GdkFullscreenMode;

    fn to_glib(&self) -> ffi::GdkFullscreenMode {
        match *self {
            FullscreenMode::CurrentMonitor => ffi::GDK_FULLSCREEN_ON_CURRENT_MONITOR,
            FullscreenMode::AllMonitors => ffi::GDK_FULLSCREEN_ON_ALL_MONITORS,
            FullscreenMode::__Unknown(value) => value
        }
    }
}

#[cfg(any(feature = "v3_8", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<ffi::GdkFullscreenMode> for FullscreenMode {
    fn from_glib(value: ffi::GdkFullscreenMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => FullscreenMode::CurrentMonitor,
            1 => FullscreenMode::AllMonitors,
            value => FullscreenMode::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_8", feature = "dox"))]
impl StaticType for FullscreenMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_fullscreen_mode_get_type()) }
    }
}

#[cfg(any(feature = "v3_8", feature = "dox"))]
impl<'a> FromValueOptional<'a> for FullscreenMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_8", feature = "dox"))]
impl<'a> FromValue<'a> for FullscreenMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_8", feature = "dox"))]
impl SetValue for FullscreenMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum GLError {
    NotAvailable,
    UnsupportedFormat,
    UnsupportedProfile,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for GLError {
    type GlibType = ffi::GdkGLError;

    fn to_glib(&self) -> ffi::GdkGLError {
        match *self {
            GLError::NotAvailable => ffi::GDK_GL_ERROR_NOT_AVAILABLE,
            GLError::UnsupportedFormat => ffi::GDK_GL_ERROR_UNSUPPORTED_FORMAT,
            GLError::UnsupportedProfile => ffi::GDK_GL_ERROR_UNSUPPORTED_PROFILE,
            GLError::__Unknown(value) => value
        }
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<ffi::GdkGLError> for GLError {
    fn from_glib(value: ffi::GdkGLError) -> Self {
        skip_assert_initialized!();
        match value {
            0 => GLError::NotAvailable,
            1 => GLError::UnsupportedFormat,
            2 => GLError::UnsupportedProfile,
            value => GLError::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl ErrorDomain for GLError {
    fn domain() -> Quark {
        skip_assert_initialized!();
        unsafe { from_glib(ffi::gdk_gl_error_quark()) }
    }

    fn code(self) -> i32 {
        self.to_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            0 => Some(GLError::NotAvailable),
            1 => Some(GLError::UnsupportedFormat),
            2 => Some(GLError::UnsupportedProfile),
            value => Some(GLError::__Unknown(value)),
        }
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl StaticType for GLError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_gl_error_get_type()) }
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl<'a> FromValueOptional<'a> for GLError {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl<'a> FromValue<'a> for GLError {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_16", feature = "dox"))]
impl SetValue for GLError {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum GrabOwnership {
    None,
    Window,
    Application,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for GrabOwnership {
    type GlibType = ffi::GdkGrabOwnership;

    fn to_glib(&self) -> ffi::GdkGrabOwnership {
        match *self {
            GrabOwnership::None => ffi::GDK_OWNERSHIP_NONE,
            GrabOwnership::Window => ffi::GDK_OWNERSHIP_WINDOW,
            GrabOwnership::Application => ffi::GDK_OWNERSHIP_APPLICATION,
            GrabOwnership::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkGrabOwnership> for GrabOwnership {
    fn from_glib(value: ffi::GdkGrabOwnership) -> Self {
        skip_assert_initialized!();
        match value {
            0 => GrabOwnership::None,
            1 => GrabOwnership::Window,
            2 => GrabOwnership::Application,
            value => GrabOwnership::__Unknown(value),
        }
    }
}

impl StaticType for GrabOwnership {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_grab_ownership_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for GrabOwnership {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for GrabOwnership {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for GrabOwnership {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum GrabStatus {
    Success,
    AlreadyGrabbed,
    InvalidTime,
    NotViewable,
    Frozen,
    Failed,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for GrabStatus {
    type GlibType = ffi::GdkGrabStatus;

    fn to_glib(&self) -> ffi::GdkGrabStatus {
        match *self {
            GrabStatus::Success => ffi::GDK_GRAB_SUCCESS,
            GrabStatus::AlreadyGrabbed => ffi::GDK_GRAB_ALREADY_GRABBED,
            GrabStatus::InvalidTime => ffi::GDK_GRAB_INVALID_TIME,
            GrabStatus::NotViewable => ffi::GDK_GRAB_NOT_VIEWABLE,
            GrabStatus::Frozen => ffi::GDK_GRAB_FROZEN,
            GrabStatus::Failed => ffi::GDK_GRAB_FAILED,
            GrabStatus::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkGrabStatus> for GrabStatus {
    fn from_glib(value: ffi::GdkGrabStatus) -> Self {
        skip_assert_initialized!();
        match value {
            0 => GrabStatus::Success,
            1 => GrabStatus::AlreadyGrabbed,
            2 => GrabStatus::InvalidTime,
            3 => GrabStatus::NotViewable,
            4 => GrabStatus::Frozen,
            5 => GrabStatus::Failed,
            value => GrabStatus::__Unknown(value),
        }
    }
}

impl StaticType for GrabStatus {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_grab_status_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for GrabStatus {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for GrabStatus {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for GrabStatus {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum Gravity {
    NorthWest,
    North,
    NorthEast,
    West,
    Center,
    East,
    SouthWest,
    South,
    SouthEast,
    Static,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for Gravity {
    type GlibType = ffi::GdkGravity;

    fn to_glib(&self) -> ffi::GdkGravity {
        match *self {
            Gravity::NorthWest => ffi::GDK_GRAVITY_NORTH_WEST,
            Gravity::North => ffi::GDK_GRAVITY_NORTH,
            Gravity::NorthEast => ffi::GDK_GRAVITY_NORTH_EAST,
            Gravity::West => ffi::GDK_GRAVITY_WEST,
            Gravity::Center => ffi::GDK_GRAVITY_CENTER,
            Gravity::East => ffi::GDK_GRAVITY_EAST,
            Gravity::SouthWest => ffi::GDK_GRAVITY_SOUTH_WEST,
            Gravity::South => ffi::GDK_GRAVITY_SOUTH,
            Gravity::SouthEast => ffi::GDK_GRAVITY_SOUTH_EAST,
            Gravity::Static => ffi::GDK_GRAVITY_STATIC,
            Gravity::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkGravity> for Gravity {
    fn from_glib(value: ffi::GdkGravity) -> Self {
        skip_assert_initialized!();
        match value {
            1 => Gravity::NorthWest,
            2 => Gravity::North,
            3 => Gravity::NorthEast,
            4 => Gravity::West,
            5 => Gravity::Center,
            6 => Gravity::East,
            7 => Gravity::SouthWest,
            8 => Gravity::South,
            9 => Gravity::SouthEast,
            10 => Gravity::Static,
            value => Gravity::__Unknown(value),
        }
    }
}

impl StaticType for Gravity {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_gravity_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Gravity {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Gravity {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Gravity {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum InputMode {
    Disabled,
    Screen,
    Window,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for InputMode {
    type GlibType = ffi::GdkInputMode;

    fn to_glib(&self) -> ffi::GdkInputMode {
        match *self {
            InputMode::Disabled => ffi::GDK_MODE_DISABLED,
            InputMode::Screen => ffi::GDK_MODE_SCREEN,
            InputMode::Window => ffi::GDK_MODE_WINDOW,
            InputMode::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkInputMode> for InputMode {
    fn from_glib(value: ffi::GdkInputMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => InputMode::Disabled,
            1 => InputMode::Screen,
            2 => InputMode::Window,
            value => InputMode::__Unknown(value),
        }
    }
}

impl StaticType for InputMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_input_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for InputMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for InputMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for InputMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum InputSource {
    Mouse,
    Pen,
    Eraser,
    Cursor,
    Keyboard,
    Touchscreen,
    Touchpad,
    Trackpoint,
    TabletPad,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for InputSource {
    type GlibType = ffi::GdkInputSource;

    fn to_glib(&self) -> ffi::GdkInputSource {
        match *self {
            InputSource::Mouse => ffi::GDK_SOURCE_MOUSE,
            InputSource::Pen => ffi::GDK_SOURCE_PEN,
            InputSource::Eraser => ffi::GDK_SOURCE_ERASER,
            InputSource::Cursor => ffi::GDK_SOURCE_CURSOR,
            InputSource::Keyboard => ffi::GDK_SOURCE_KEYBOARD,
            InputSource::Touchscreen => ffi::GDK_SOURCE_TOUCHSCREEN,
            InputSource::Touchpad => ffi::GDK_SOURCE_TOUCHPAD,
            InputSource::Trackpoint => ffi::GDK_SOURCE_TRACKPOINT,
            InputSource::TabletPad => ffi::GDK_SOURCE_TABLET_PAD,
            InputSource::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkInputSource> for InputSource {
    fn from_glib(value: ffi::GdkInputSource) -> Self {
        skip_assert_initialized!();
        match value {
            0 => InputSource::Mouse,
            1 => InputSource::Pen,
            2 => InputSource::Eraser,
            3 => InputSource::Cursor,
            4 => InputSource::Keyboard,
            5 => InputSource::Touchscreen,
            6 => InputSource::Touchpad,
            7 => InputSource::Trackpoint,
            8 => InputSource::TabletPad,
            value => InputSource::__Unknown(value),
        }
    }
}

impl StaticType for InputSource {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_input_source_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for InputSource {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for InputSource {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for InputSource {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum ModifierIntent {
    PrimaryAccelerator,
    ContextMenu,
    ExtendSelection,
    ModifySelection,
    NoTextInput,
    ShiftGroup,
    DefaultModMask,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for ModifierIntent {
    type GlibType = ffi::GdkModifierIntent;

    fn to_glib(&self) -> ffi::GdkModifierIntent {
        match *self {
            ModifierIntent::PrimaryAccelerator => ffi::GDK_MODIFIER_INTENT_PRIMARY_ACCELERATOR,
            ModifierIntent::ContextMenu => ffi::GDK_MODIFIER_INTENT_CONTEXT_MENU,
            ModifierIntent::ExtendSelection => ffi::GDK_MODIFIER_INTENT_EXTEND_SELECTION,
            ModifierIntent::ModifySelection => ffi::GDK_MODIFIER_INTENT_MODIFY_SELECTION,
            ModifierIntent::NoTextInput => ffi::GDK_MODIFIER_INTENT_NO_TEXT_INPUT,
            ModifierIntent::ShiftGroup => ffi::GDK_MODIFIER_INTENT_SHIFT_GROUP,
            ModifierIntent::DefaultModMask => ffi::GDK_MODIFIER_INTENT_DEFAULT_MOD_MASK,
            ModifierIntent::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkModifierIntent> for ModifierIntent {
    fn from_glib(value: ffi::GdkModifierIntent) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ModifierIntent::PrimaryAccelerator,
            1 => ModifierIntent::ContextMenu,
            2 => ModifierIntent::ExtendSelection,
            3 => ModifierIntent::ModifySelection,
            4 => ModifierIntent::NoTextInput,
            5 => ModifierIntent::ShiftGroup,
            6 => ModifierIntent::DefaultModMask,
            value => ModifierIntent::__Unknown(value),
        }
    }
}

impl StaticType for ModifierIntent {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_modifier_intent_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ModifierIntent {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ModifierIntent {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ModifierIntent {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum NotifyType {
    Ancestor,
    Virtual,
    Inferior,
    Nonlinear,
    NonlinearVirtual,
    Unknown,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for NotifyType {
    type GlibType = ffi::GdkNotifyType;

    fn to_glib(&self) -> ffi::GdkNotifyType {
        match *self {
            NotifyType::Ancestor => ffi::GDK_NOTIFY_ANCESTOR,
            NotifyType::Virtual => ffi::GDK_NOTIFY_VIRTUAL,
            NotifyType::Inferior => ffi::GDK_NOTIFY_INFERIOR,
            NotifyType::Nonlinear => ffi::GDK_NOTIFY_NONLINEAR,
            NotifyType::NonlinearVirtual => ffi::GDK_NOTIFY_NONLINEAR_VIRTUAL,
            NotifyType::Unknown => ffi::GDK_NOTIFY_UNKNOWN,
            NotifyType::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkNotifyType> for NotifyType {
    fn from_glib(value: ffi::GdkNotifyType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => NotifyType::Ancestor,
            1 => NotifyType::Virtual,
            2 => NotifyType::Inferior,
            3 => NotifyType::Nonlinear,
            4 => NotifyType::NonlinearVirtual,
            5 => NotifyType::Unknown,
            value => NotifyType::__Unknown(value),
        }
    }
}

impl StaticType for NotifyType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_notify_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for NotifyType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for NotifyType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for NotifyType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum OwnerChange {
    NewOwner,
    Destroy,
    Close,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for OwnerChange {
    type GlibType = ffi::GdkOwnerChange;

    fn to_glib(&self) -> ffi::GdkOwnerChange {
        match *self {
            OwnerChange::NewOwner => ffi::GDK_OWNER_CHANGE_NEW_OWNER,
            OwnerChange::Destroy => ffi::GDK_OWNER_CHANGE_DESTROY,
            OwnerChange::Close => ffi::GDK_OWNER_CHANGE_CLOSE,
            OwnerChange::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkOwnerChange> for OwnerChange {
    fn from_glib(value: ffi::GdkOwnerChange) -> Self {
        skip_assert_initialized!();
        match value {
            0 => OwnerChange::NewOwner,
            1 => OwnerChange::Destroy,
            2 => OwnerChange::Close,
            value => OwnerChange::__Unknown(value),
        }
    }
}

impl StaticType for OwnerChange {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_owner_change_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for OwnerChange {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for OwnerChange {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for OwnerChange {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum PropMode {
    Replace,
    Prepend,
    Append,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for PropMode {
    type GlibType = ffi::GdkPropMode;

    fn to_glib(&self) -> ffi::GdkPropMode {
        match *self {
            PropMode::Replace => ffi::GDK_PROP_MODE_REPLACE,
            PropMode::Prepend => ffi::GDK_PROP_MODE_PREPEND,
            PropMode::Append => ffi::GDK_PROP_MODE_APPEND,
            PropMode::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkPropMode> for PropMode {
    fn from_glib(value: ffi::GdkPropMode) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PropMode::Replace,
            1 => PropMode::Prepend,
            2 => PropMode::Append,
            value => PropMode::__Unknown(value),
        }
    }
}

impl StaticType for PropMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_prop_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PropMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PropMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PropMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum PropertyState {
    NewValue,
    Delete,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for PropertyState {
    type GlibType = ffi::GdkPropertyState;

    fn to_glib(&self) -> ffi::GdkPropertyState {
        match *self {
            PropertyState::NewValue => ffi::GDK_PROPERTY_NEW_VALUE,
            PropertyState::Delete => ffi::GDK_PROPERTY_DELETE,
            PropertyState::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkPropertyState> for PropertyState {
    fn from_glib(value: ffi::GdkPropertyState) -> Self {
        skip_assert_initialized!();
        match value {
            0 => PropertyState::NewValue,
            1 => PropertyState::Delete,
            value => PropertyState::__Unknown(value),
        }
    }
}

impl StaticType for PropertyState {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_property_state_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for PropertyState {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for PropertyState {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for PropertyState {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum ScrollDirection {
    Up,
    Down,
    Left,
    Right,
    Smooth,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for ScrollDirection {
    type GlibType = ffi::GdkScrollDirection;

    fn to_glib(&self) -> ffi::GdkScrollDirection {
        match *self {
            ScrollDirection::Up => ffi::GDK_SCROLL_UP,
            ScrollDirection::Down => ffi::GDK_SCROLL_DOWN,
            ScrollDirection::Left => ffi::GDK_SCROLL_LEFT,
            ScrollDirection::Right => ffi::GDK_SCROLL_RIGHT,
            ScrollDirection::Smooth => ffi::GDK_SCROLL_SMOOTH,
            ScrollDirection::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkScrollDirection> for ScrollDirection {
    fn from_glib(value: ffi::GdkScrollDirection) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ScrollDirection::Up,
            1 => ScrollDirection::Down,
            2 => ScrollDirection::Left,
            3 => ScrollDirection::Right,
            4 => ScrollDirection::Smooth,
            value => ScrollDirection::__Unknown(value),
        }
    }
}

impl StaticType for ScrollDirection {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_scroll_direction_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ScrollDirection {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ScrollDirection {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ScrollDirection {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum SettingAction {
    New,
    Changed,
    Deleted,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for SettingAction {
    type GlibType = ffi::GdkSettingAction;

    fn to_glib(&self) -> ffi::GdkSettingAction {
        match *self {
            SettingAction::New => ffi::GDK_SETTING_ACTION_NEW,
            SettingAction::Changed => ffi::GDK_SETTING_ACTION_CHANGED,
            SettingAction::Deleted => ffi::GDK_SETTING_ACTION_DELETED,
            SettingAction::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkSettingAction> for SettingAction {
    fn from_glib(value: ffi::GdkSettingAction) -> Self {
        skip_assert_initialized!();
        match value {
            0 => SettingAction::New,
            1 => SettingAction::Changed,
            2 => SettingAction::Deleted,
            value => SettingAction::__Unknown(value),
        }
    }
}

impl StaticType for SettingAction {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_setting_action_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for SettingAction {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for SettingAction {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for SettingAction {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum SubpixelLayout {
    Unknown,
    None,
    HorizontalRgb,
    HorizontalBgr,
    VerticalRgb,
    VerticalBgr,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for SubpixelLayout {
    type GlibType = ffi::GdkSubpixelLayout;

    fn to_glib(&self) -> ffi::GdkSubpixelLayout {
        match *self {
            SubpixelLayout::Unknown => ffi::GDK_SUBPIXEL_LAYOUT_UNKNOWN,
            SubpixelLayout::None => ffi::GDK_SUBPIXEL_LAYOUT_NONE,
            SubpixelLayout::HorizontalRgb => ffi::GDK_SUBPIXEL_LAYOUT_HORIZONTAL_RGB,
            SubpixelLayout::HorizontalBgr => ffi::GDK_SUBPIXEL_LAYOUT_HORIZONTAL_BGR,
            SubpixelLayout::VerticalRgb => ffi::GDK_SUBPIXEL_LAYOUT_VERTICAL_RGB,
            SubpixelLayout::VerticalBgr => ffi::GDK_SUBPIXEL_LAYOUT_VERTICAL_BGR,
            SubpixelLayout::__Unknown(value) => value
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<ffi::GdkSubpixelLayout> for SubpixelLayout {
    fn from_glib(value: ffi::GdkSubpixelLayout) -> Self {
        skip_assert_initialized!();
        match value {
            0 => SubpixelLayout::Unknown,
            1 => SubpixelLayout::None,
            2 => SubpixelLayout::HorizontalRgb,
            3 => SubpixelLayout::HorizontalBgr,
            4 => SubpixelLayout::VerticalRgb,
            5 => SubpixelLayout::VerticalBgr,
            value => SubpixelLayout::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl StaticType for SubpixelLayout {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_subpixel_layout_get_type()) }
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValueOptional<'a> for SubpixelLayout {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl<'a> FromValue<'a> for SubpixelLayout {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
impl SetValue for SubpixelLayout {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum VisibilityState {
    Unobscured,
    Partial,
    FullyObscured,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for VisibilityState {
    type GlibType = ffi::GdkVisibilityState;

    fn to_glib(&self) -> ffi::GdkVisibilityState {
        match *self {
            VisibilityState::Unobscured => ffi::GDK_VISIBILITY_UNOBSCURED,
            VisibilityState::Partial => ffi::GDK_VISIBILITY_PARTIAL,
            VisibilityState::FullyObscured => ffi::GDK_VISIBILITY_FULLY_OBSCURED,
            VisibilityState::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkVisibilityState> for VisibilityState {
    fn from_glib(value: ffi::GdkVisibilityState) -> Self {
        skip_assert_initialized!();
        match value {
            0 => VisibilityState::Unobscured,
            1 => VisibilityState::Partial,
            2 => VisibilityState::FullyObscured,
            value => VisibilityState::__Unknown(value),
        }
    }
}

impl StaticType for VisibilityState {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_visibility_state_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for VisibilityState {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for VisibilityState {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for VisibilityState {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum VisualType {
    StaticGray,
    Grayscale,
    StaticColor,
    PseudoColor,
    TrueColor,
    DirectColor,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for VisualType {
    type GlibType = ffi::GdkVisualType;

    fn to_glib(&self) -> ffi::GdkVisualType {
        match *self {
            VisualType::StaticGray => ffi::GDK_VISUAL_STATIC_GRAY,
            VisualType::Grayscale => ffi::GDK_VISUAL_GRAYSCALE,
            VisualType::StaticColor => ffi::GDK_VISUAL_STATIC_COLOR,
            VisualType::PseudoColor => ffi::GDK_VISUAL_PSEUDO_COLOR,
            VisualType::TrueColor => ffi::GDK_VISUAL_TRUE_COLOR,
            VisualType::DirectColor => ffi::GDK_VISUAL_DIRECT_COLOR,
            VisualType::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkVisualType> for VisualType {
    fn from_glib(value: ffi::GdkVisualType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => VisualType::StaticGray,
            1 => VisualType::Grayscale,
            2 => VisualType::StaticColor,
            3 => VisualType::PseudoColor,
            4 => VisualType::TrueColor,
            5 => VisualType::DirectColor,
            value => VisualType::__Unknown(value),
        }
    }
}

impl StaticType for VisualType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_visual_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for VisualType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for VisualType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for VisualType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum WindowEdge {
    NorthWest,
    North,
    NorthEast,
    West,
    East,
    SouthWest,
    South,
    SouthEast,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for WindowEdge {
    type GlibType = ffi::GdkWindowEdge;

    fn to_glib(&self) -> ffi::GdkWindowEdge {
        match *self {
            WindowEdge::NorthWest => ffi::GDK_WINDOW_EDGE_NORTH_WEST,
            WindowEdge::North => ffi::GDK_WINDOW_EDGE_NORTH,
            WindowEdge::NorthEast => ffi::GDK_WINDOW_EDGE_NORTH_EAST,
            WindowEdge::West => ffi::GDK_WINDOW_EDGE_WEST,
            WindowEdge::East => ffi::GDK_WINDOW_EDGE_EAST,
            WindowEdge::SouthWest => ffi::GDK_WINDOW_EDGE_SOUTH_WEST,
            WindowEdge::South => ffi::GDK_WINDOW_EDGE_SOUTH,
            WindowEdge::SouthEast => ffi::GDK_WINDOW_EDGE_SOUTH_EAST,
            WindowEdge::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkWindowEdge> for WindowEdge {
    fn from_glib(value: ffi::GdkWindowEdge) -> Self {
        skip_assert_initialized!();
        match value {
            0 => WindowEdge::NorthWest,
            1 => WindowEdge::North,
            2 => WindowEdge::NorthEast,
            3 => WindowEdge::West,
            4 => WindowEdge::East,
            5 => WindowEdge::SouthWest,
            6 => WindowEdge::South,
            7 => WindowEdge::SouthEast,
            value => WindowEdge::__Unknown(value),
        }
    }
}

impl StaticType for WindowEdge {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_window_edge_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for WindowEdge {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for WindowEdge {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for WindowEdge {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum WindowType {
    Root,
    Toplevel,
    Child,
    Temp,
    Foreign,
    Offscreen,
    Subsurface,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for WindowType {
    type GlibType = ffi::GdkWindowType;

    fn to_glib(&self) -> ffi::GdkWindowType {
        match *self {
            WindowType::Root => ffi::GDK_WINDOW_ROOT,
            WindowType::Toplevel => ffi::GDK_WINDOW_TOPLEVEL,
            WindowType::Child => ffi::GDK_WINDOW_CHILD,
            WindowType::Temp => ffi::GDK_WINDOW_TEMP,
            WindowType::Foreign => ffi::GDK_WINDOW_FOREIGN,
            WindowType::Offscreen => ffi::GDK_WINDOW_OFFSCREEN,
            WindowType::Subsurface => ffi::GDK_WINDOW_SUBSURFACE,
            WindowType::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkWindowType> for WindowType {
    fn from_glib(value: ffi::GdkWindowType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => WindowType::Root,
            1 => WindowType::Toplevel,
            2 => WindowType::Child,
            3 => WindowType::Temp,
            4 => WindowType::Foreign,
            5 => WindowType::Offscreen,
            6 => WindowType::Subsurface,
            value => WindowType::__Unknown(value),
        }
    }
}

impl StaticType for WindowType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_window_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for WindowType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for WindowType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for WindowType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum WindowTypeHint {
    Normal,
    Dialog,
    Menu,
    Toolbar,
    Splashscreen,
    Utility,
    Dock,
    Desktop,
    DropdownMenu,
    PopupMenu,
    Tooltip,
    Notification,
    Combo,
    Dnd,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for WindowTypeHint {
    type GlibType = ffi::GdkWindowTypeHint;

    fn to_glib(&self) -> ffi::GdkWindowTypeHint {
        match *self {
            WindowTypeHint::Normal => ffi::GDK_WINDOW_TYPE_HINT_NORMAL,
            WindowTypeHint::Dialog => ffi::GDK_WINDOW_TYPE_HINT_DIALOG,
            WindowTypeHint::Menu => ffi::GDK_WINDOW_TYPE_HINT_MENU,
            WindowTypeHint::Toolbar => ffi::GDK_WINDOW_TYPE_HINT_TOOLBAR,
            WindowTypeHint::Splashscreen => ffi::GDK_WINDOW_TYPE_HINT_SPLASHSCREEN,
            WindowTypeHint::Utility => ffi::GDK_WINDOW_TYPE_HINT_UTILITY,
            WindowTypeHint::Dock => ffi::GDK_WINDOW_TYPE_HINT_DOCK,
            WindowTypeHint::Desktop => ffi::GDK_WINDOW_TYPE_HINT_DESKTOP,
            WindowTypeHint::DropdownMenu => ffi::GDK_WINDOW_TYPE_HINT_DROPDOWN_MENU,
            WindowTypeHint::PopupMenu => ffi::GDK_WINDOW_TYPE_HINT_POPUP_MENU,
            WindowTypeHint::Tooltip => ffi::GDK_WINDOW_TYPE_HINT_TOOLTIP,
            WindowTypeHint::Notification => ffi::GDK_WINDOW_TYPE_HINT_NOTIFICATION,
            WindowTypeHint::Combo => ffi::GDK_WINDOW_TYPE_HINT_COMBO,
            WindowTypeHint::Dnd => ffi::GDK_WINDOW_TYPE_HINT_DND,
            WindowTypeHint::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkWindowTypeHint> for WindowTypeHint {
    fn from_glib(value: ffi::GdkWindowTypeHint) -> Self {
        skip_assert_initialized!();
        match value {
            0 => WindowTypeHint::Normal,
            1 => WindowTypeHint::Dialog,
            2 => WindowTypeHint::Menu,
            3 => WindowTypeHint::Toolbar,
            4 => WindowTypeHint::Splashscreen,
            5 => WindowTypeHint::Utility,
            6 => WindowTypeHint::Dock,
            7 => WindowTypeHint::Desktop,
            8 => WindowTypeHint::DropdownMenu,
            9 => WindowTypeHint::PopupMenu,
            10 => WindowTypeHint::Tooltip,
            11 => WindowTypeHint::Notification,
            12 => WindowTypeHint::Combo,
            13 => WindowTypeHint::Dnd,
            value => WindowTypeHint::__Unknown(value),
        }
    }
}

impl StaticType for WindowTypeHint {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_window_type_hint_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for WindowTypeHint {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for WindowTypeHint {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for WindowTypeHint {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
pub enum WindowWindowClass {
    InputOutput,
    InputOnly,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl ToGlib for WindowWindowClass {
    type GlibType = ffi::GdkWindowWindowClass;

    fn to_glib(&self) -> ffi::GdkWindowWindowClass {
        match *self {
            WindowWindowClass::InputOutput => ffi::GDK_INPUT_OUTPUT,
            WindowWindowClass::InputOnly => ffi::GDK_INPUT_ONLY,
            WindowWindowClass::__Unknown(value) => value
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GdkWindowWindowClass> for WindowWindowClass {
    fn from_glib(value: ffi::GdkWindowWindowClass) -> Self {
        skip_assert_initialized!();
        match value {
            0 => WindowWindowClass::InputOutput,
            1 => WindowWindowClass::InputOnly,
            value => WindowWindowClass::__Unknown(value),
        }
    }
}

impl StaticType for WindowWindowClass {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::gdk_window_window_class_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for WindowWindowClass {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for WindowWindowClass {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for WindowWindowClass {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

