% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival-survdiff-tidiers.R
\name{tidy.survdiff}
\alias{tidy.survdiff}
\alias{survdiff_tidiers}
\title{Tidy a(n) survdiff object}
\usage{
\method{tidy}{survdiff}(x, ...)
}
\arguments{
\item{x}{An \code{survdiff} object returned from \code{\link[survival:survdiff]{survival::survdiff()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row for each time point and columns:

\item{...}{The initial columns correspond to the grouping factors
on the right hand side of the model formula.}
\item{obs}{weighted observed number of events in each group}
\item{exp}{weighted expected number of events in each group}
\item{N}{number of subjects in each group}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

library(survival)

s <- survdiff(
  Surv(time, status) ~ pat.karno + strata(inst),
  data = lung
)

tidy(s)
glance(s)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[survival:survdiff]{survival::survdiff()}}

Other survdiff tidiers: \code{\link{glance.survdiff}}

Other survival tidiers: \code{\link{augment.coxph}},
  \code{\link{augment.survreg}},
  \code{\link{glance.aareg}}, \code{\link{glance.cch}},
  \code{\link{glance.coxph}}, \code{\link{glance.pyears}},
  \code{\link{glance.survdiff}},
  \code{\link{glance.survexp}},
  \code{\link{glance.survfit}},
  \code{\link{glance.survreg}}, \code{\link{tidy.aareg}},
  \code{\link{tidy.cch}}, \code{\link{tidy.coxph}},
  \code{\link{tidy.pyears}}, \code{\link{tidy.survexp}},
  \code{\link{tidy.survfit}}, \code{\link{tidy.survreg}}
}
\concept{survdiff tidiers}
\concept{survival tidiers}
