# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GetBackupByStorageQueryDescription(Model):
    """Describes additional filters to be applied, while listing backups, and
    backup storage details from where to fetch the backups.

    All required parameters must be populated in order to send to Azure.

    :param start_date_time_filter: Specifies the start date time in ISO8601
     from which to enumerate backups. If not specified, backups are enumerated
     from the beginning.
    :type start_date_time_filter: datetime
    :param end_date_time_filter: Specifies the end date time in ISO8601 till
     which to enumerate backups. If not specified, backups are enumerated till
     the end.
    :type end_date_time_filter: datetime
    :param latest: If specified as true, gets the most recent backup (within
     the specified time range) for every partition under the specified backup
     entity. Default value: False .
    :type latest: bool
    :param storage: Required. Describes the parameters for the backup storage
     from where to enumerate backups. This is optional and by default backups
     are enumerated from the backup storage where this backup entity is
     currently being backed up (as specified in backup policy). This parameter
     is useful to be able to enumerate backups from another cluster where you
     may intend to restore.
    :type storage: ~azure.servicefabric.models.BackupStorageDescription
    :param backup_entity: Required. Indicates the entity for which to
     enumerate backups.
    :type backup_entity: ~azure.servicefabric.models.BackupEntity
    """

    _validation = {
        'storage': {'required': True},
        'backup_entity': {'required': True},
    }

    _attribute_map = {
        'start_date_time_filter': {'key': 'StartDateTimeFilter', 'type': 'iso-8601'},
        'end_date_time_filter': {'key': 'EndDateTimeFilter', 'type': 'iso-8601'},
        'latest': {'key': 'Latest', 'type': 'bool'},
        'storage': {'key': 'Storage', 'type': 'BackupStorageDescription'},
        'backup_entity': {'key': 'BackupEntity', 'type': 'BackupEntity'},
    }

    def __init__(self, *, storage, backup_entity, start_date_time_filter=None, end_date_time_filter=None, latest: bool=False, **kwargs) -> None:
        super(GetBackupByStorageQueryDescription, self).__init__(**kwargs)
        self.start_date_time_filter = start_date_time_filter
        self.end_date_time_filter = end_date_time_filter
        self.latest = latest
        self.storage = storage
        self.backup_entity = backup_entity
