# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource_py3 import ProxyResource


class TransparentDataEncryptionActivity(ProxyResource):
    """Represents a database transparent data encryption Scan.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar status: The status of the database. Possible values include:
     'Encrypting', 'Decrypting'
    :vartype status: str or
     ~azure.mgmt.sql.models.TransparentDataEncryptionActivityStatus
    :ivar percent_complete: The percent complete of the transparent data
     encryption scan for a database.
    :vartype percent_complete: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'status': {'readonly': True},
        'percent_complete': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'float'},
    }

    def __init__(self, **kwargs) -> None:
        super(TransparentDataEncryptionActivity, self).__init__(**kwargs)
        self.location = None
        self.status = None
        self.percent_complete = None
