# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .content_key_policy_restriction_token_key_py3 import ContentKeyPolicyRestrictionTokenKey


class ContentKeyPolicyX509CertificateTokenKey(ContentKeyPolicyRestrictionTokenKey):
    """Specifies a certificate for token validation.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param raw_body: Required. The raw data field of a certificate in PKCS 12
     format (X509Certificate2 in .NET)
    :type raw_body: bytearray
    """

    _validation = {
        'odatatype': {'required': True},
        'raw_body': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'raw_body': {'key': 'rawBody', 'type': 'bytearray'},
    }

    def __init__(self, *, raw_body: bytearray, **kwargs) -> None:
        super(ContentKeyPolicyX509CertificateTokenKey, self).__init__(**kwargs)
        self.raw_body = raw_body
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'
