# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NetworkProfile(Model):
    """Specifies the network settings for the HANA instance disks.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param network_interfaces: Specifies the network interfaces for the HANA
     instance.
    :type network_interfaces: list[~azure.mgmt.hanaonazure.models.IpAddress]
    :ivar circuit_id: Specifies the circuit id for connecting to express
     route.
    :vartype circuit_id: str
    """

    _validation = {
        'circuit_id': {'readonly': True},
    }

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[IpAddress]'},
        'circuit_id': {'key': 'circuitId', 'type': 'str'},
    }

    def __init__(self, *, network_interfaces=None, **kwargs) -> None:
        super(NetworkProfile, self).__init__(**kwargs)
        self.network_interfaces = network_interfaces
        self.circuit_id = None
