# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class VirtualMachineScaleSetExtension(SubResource):
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource Id
    :type id: str
    :param name: The name of the extension.
    :type name: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: The type of the extension handler.
    :type type: str
    :param type_handler_version: The type version of the extension handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Whether the extension handler should be
     automatically upgraded across minor versions.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: Json formatted protected settings for the
     extension.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetExtension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.publisher = kwargs.get('publisher', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
