# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StoredImagePrediction(Model):
    """result of an image classification request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar image_uri:
    :vartype image_uri: str
    :ivar thumbnail_uri:
    :vartype thumbnail_uri: str
    :ivar domain:
    :vartype domain: str
    :ivar id:
    :vartype id: str
    :ivar project:
    :vartype project: str
    :ivar iteration:
    :vartype iteration: str
    :ivar created:
    :vartype created: datetime
    :ivar predictions:
    :vartype predictions:
     list[~azure.cognitiveservices.vision.customvision.training.models.Prediction]
    """

    _validation = {
        'image_uri': {'readonly': True},
        'thumbnail_uri': {'readonly': True},
        'domain': {'readonly': True},
        'id': {'readonly': True},
        'project': {'readonly': True},
        'iteration': {'readonly': True},
        'created': {'readonly': True},
        'predictions': {'readonly': True},
    }

    _attribute_map = {
        'image_uri': {'key': 'imageUri', 'type': 'str'},
        'thumbnail_uri': {'key': 'thumbnailUri', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'project': {'key': 'project', 'type': 'str'},
        'iteration': {'key': 'iteration', 'type': 'str'},
        'created': {'key': 'created', 'type': 'iso-8601'},
        'predictions': {'key': 'predictions', 'type': '[Prediction]'},
    }

    def __init__(self, **kwargs) -> None:
        super(StoredImagePrediction, self).__init__(**kwargs)
        self.image_uri = None
        self.thumbnail_uri = None
        self.domain = None
        self.id = None
        self.project = None
        self.iteration = None
        self.created = None
        self.predictions = None
