/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Exceptions thrown by some libSBML constructors.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * In some situations, constructors for SBML objects may need to indicate
 * to callers that the creation of the object failed.  The failure may be
 * for different reasons, such as an attempt to use invalid parameters or a
 * system condition such as a memory error.  To communicate this to
 * callers, those classes will throw an {@link XMLConstructorException}.  
 <p>
 * In languages that don't have an exception mechanism (e.g., C), the
 * constructors generally try to return an error code instead of throwing
 * an exception.
 <p>
 * @see SBMLConstructorException
 */

public class XMLConstructorException extends java.lang.IllegalArgumentException {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected XMLConstructorException(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(XMLConstructorException obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (XMLConstructorException obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_XMLConstructorException(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /*
   * To pass the message from an exception to the parent exception class,
   * we have to create our own variant of the constructor that takes an
   * extra string argument.
   */
  protected XMLConstructorException(long cPtr, boolean cMemoryOwn, String v)
  {
    super(v);
    swigCMemOwn = cMemoryOwn;
    swigCPtr    = cPtr;
  }

  /*
   * Next, we define the public constructor to take a string (like all basic
   * Java exception class constructors), and invoke our internal special
   * constructor with the extra argument.
   */
  public XMLConstructorException(String v)
  {
    this(libsbmlJNI.new_XMLConstructorException(), true, v);
  }

  
/** * @internal */ public
 XMLConstructorException() {
    this(libsbmlJNI.new_XMLConstructorException(), true);
  }

}
