/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class Util {
    public static final Gson GSON = new GsonBuilder().create();
    private static final long FORCE_GC_TIMEOUT_SECS = 2L;

    private Util() {
    }

    public static Class<?> lenientClassForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            String newName = className.replaceFirst("\\.([^.]+)$", "\\$$1");
            return Class.forName(newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableMap<String, String> loadProperties(InputSupplier<? extends InputStream> is) throws IOException {
        Properties props = new Properties();
        InputStream in = (InputStream)is.getInput();
        try {
            props.load(in);
        }
        finally {
            Closeables.closeQuietly((Closeable)in);
        }
        return Maps.fromProperties((Properties)props);
    }

    public static InputSupplier<InputStream> resourceSupplier(final Class<?> c, final String name) {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() {
                return c.getResourceAsStream(name);
            }
        };
    }

    public static <T> ImmutableMap<String, T> prefixedSubmap(Map<String, T> props, String prefix) {
        ImmutableMap.Builder submapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, T> entry : props.entrySet()) {
            String name = entry.getKey();
            if (!name.startsWith(prefix)) continue;
            submapBuilder.put((Object)name.substring(prefix.length()), entry.getValue());
        }
        return submapBuilder.build();
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static void forceGc() {
        System.gc();
        System.runFinalization();
        final CountDownLatch latch = new CountDownLatch(1);
        new Object(){

            protected void finalize() {
                latch.countDown();
            }
        };
        System.gc();
        System.runFinalization();
        try {
            latch.await(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

