/* Built-in files */

/*
	LC_ALL=C grep -ve $'^[\t ]' -e '^-syntax' jupprc | sed \
	    -e '/^:cua/,$d' -e '/^:Pastecua/,/^$/d' -e 1d \
	    -e 's/@(#) jupprc/@(#) blt_in/' | cat -s | while IFS= read -r x; do
		x=${x//\\/\\\\}; print -r -- $'\t\t'\""${x//\"/\\\"}\n"\";
	done | perl -pe 's/[^\ca-~]/sprintf "\\x%02X", unpack("U", $&)/eg'
 */

#include "config.h"
#include "types.h"

__RCSID("$MirOS: contrib/code/jupp/builtins.c,v 1.32 2018/10/20 16:25:47 tg Exp $");

#ifndef JUPPRC_BUILTIN_NAME
#define JUPPRC_BUILTIN_NAME "jupprc"
#endif

const unsigned char * const builtins[] = {
	UC JUPPRC_BUILTIN_NAME, UC
		"-assume_color\n"
		"-dopadding\n"
		"--force\n"
		"-keepup\n"
		"-mid\n"
		"-nobackups\n"
		"-noxon\n"
		"-notite\n"
		"-pastetite\n"
		"-pg 2\n"
		"-lmsg \\i%k%T%*\\b%n\\b%R\n"
		"-rmsg  R%r<%l C%c\\u%o|%O\\i\\b%a|%A\\b\\i\\u %u\n"
		"-hmsg \\i\\f\\b^J = Help\\b\\f\n"
		"-guess_crlf\n"
		"-french\n"
		"-indentc 9\n"
		"-istep 1\n"
		"--guess_indent\n"
		"--autoindent\n"
		"-purify\n"
		"-highlight\n"
		"--linums\n"
		"-lmargin 1\n"
		"-rmargin 73\n"
		"--smarthome\n"
		"--indentfirst\n"
		"-smartbacks\n"
		"-tab 8\n"
		"--wordwrap\n"
		"\n"
		"*.bin\n"
		"--crlf\n"
		"--guess_crlf\n"
		"-encoding ascii\n"
		"-hex\n"
		"\n"
		"*.py\n"
		"-encoding utf8\n"
		"-tab 4\n"
		"-indentc 32\n"
		"-istep 4\n"
		"-spaces\n"
		"\n"
		"*\n"
		"+#!\\+\\[	 ]\\+\\[/a-z0-9._-]/python\n"
		"-encoding utf8\n"
		"-tab 4\n"
		"-indentc 32\n"
		"-istep 4\n"
		"-spaces\n"
		"\n"
		"*\n"
		"+#!\\+\\[	 ]\\+\\[/a-z0-9._-]/env\\[	 ]\\+\\[	 ]python\n"
		"-encoding utf8\n"
		"-tab 4\n"
		"-indentc 32\n"
		"-istep 4\n"
		"-spaces\n"
		"\n"
		"{General\n"
		"\\i   Help Screen    turn off with ^J     more help with Esc+. (^[.)              \\i\n"
		"\\i \\i \\u\\bEXIT\\b\\u       \\u\\bBLOCK DEF\\b\\u  \\u\\bBLOCK OP\\b\\u  \\u\\bSEARCH\\b\\u         \\u\\bDELETE:\\b\\u \\b^H\\b  <char  \\b^Y\\b  line  \\i \\i\n"
		"\\i \\i \\b^KX\\b save   \\b^KB\\b begin  \\b^KV\\b move  \\b^QF\\b find first         \\b^G\\b  >char  \\b^QT\\b <line \\i \\i\n"
		"\\i \\i \\b^KQ\\b abort  \\b^KK\\b end    \\b^KC\\b copy  \\b^L\\b  find next          \\b^[o\\b <word  \\b^QY\\b >line \\i \\i\n"
		"\\i \\i \\u\\bMISC\\b\\u       \\b^KL\\b line   \\b^KY\\b kill  \\b^QA\\b find and replace   \\b^T\\b  >word  \\b^[Y\\b yank  \\i \\i\n"
		"\\i \\i \\b^QM\\b math   \\b^KH\\b hide   \\b^K/\\b pipe  \\b^QG\\b char backwards  \\u\\bSHELL\\b\\u        \\u\\bFILE\\b\\u       \\i \\i\n"
		"\\i \\i \\b^O\\b  options   \\u\\bQUOTE\\b\\u    \\u\\bBUFFER\\b\\u   \\b^QF\\b char forwards   \\b^KZ\\b suspend  \\b^KS\\b save\\das\\d \\i \\i\n"
		"\\i \\i \\b^[P\\b pastemode  \\b`\\b Ctrl  \\b^U\\b undo  \\b^[R\\b incremental b.  \\b^K'\\b window   \\b^KR\\b import \\i \\i\n"
		"\\i \\i \\b^[-\\b cmdprompt \\b^P\\b Meta  \\b^^\\b redo  \\b^[T\\b incr. forwards  \\b^['\\b command  \\b^KW\\b export \\i \\i\n"
		"}\n"
		"\n"
		"{Movement\n"
		"\\i   Help Screen    turn off with ^J     prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i \\u\\bMovement in jupp:\\b\\u                   screen(top)                             \\i \\i\n"
		"\\i \\i                        upslide         \\b^QE\\b      page(top)   file(beginning) \\i \\i\n"
		"\\i \\i                             \\b^W\\b    (char)up        \\b^R\\b               \\b^QR\\b      \\i \\i\n"
		"\\i \\i  (beginning)line   (prev)word      left \\b^E\\b  right    (next)word   line(end) \\i \\i\n"
		"\\i \\i              \\b^QS\\b           \\b^A\\b      \\b^S\\b   \\d<+>\\d    \\b^D\\b            \\b^F\\b    \\b^QD\\b      \\i \\i\n"
		"\\i \\i                      downslide   (char)down     page(bottom)      file(end) \\i \\i\n"
		"\\i \\i                             \\b^Z\\b          \\b^X\\b        \\b^C\\b               \\b^QC\\b      \\i \\i\n"
		"\\i \\uWordStar diamond\\u \\i                       \\b^QX\\b \\d<-\\d screen(bottom)                \\i \\i\n"
		"}\n"
		"\n"
		"{Windows\n"
		"\\i   Help Screen    turn off with ^J     prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i \\b^KG\\b make current window bigger     \\b^KI\\b show all windows / show one window   \\i \\i\n"
		"\\i \\i \\b^KT\\b make current window smaller    \\b^KO\\b split the current window in half     \\i \\i\n"
		"\\i \\i \\b^KP\\b go to the window above         \\b^K-\\b edit scratch buffer in new window    \\i \\i\n"
		"\\i \\i \\b^KN\\b go to the window below         \\b^KQ\\b eliminate the current window         \\i \\i\n"
		"\\i \\i \\b^KE\\b load file into new window      \\b^K;\\b run a ctags search                   \\i \\i\n"
		"\\i \\i Note: some commands (\\b^KE\\b \\b^K;\\b \\b^K-\\b) hide the current window; use \\b^KI\\b/\\b^KN\\b then \\i \\i\n"
		"\\i \\i   \\u\\bSpecial help for XON/XOFF aware terminals:\\b\\u                                \\i \\i\n"
		"\\i \\i You can type \\b^[q\\b instead of \\b^Q\\b and \\b^[s\\b instead of \\b^S\\b for all commands.      \\i \\i\n"
		"}\n"
		"\n"
		"{Orientation\n"
		"\\i   Help Screen    turn off with ^J     prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i \\u\\bGOTO\\b\\u                        \\u\\bMISC\\b\\u                     \\u\\bINSERT MATH OR CURRENT\\b\\u \\i \\i\n"
		"\\i \\i \\b^Q=\\b merge conflict marker   \\b^K\\b \\u0-9\\u define bookmark   \\b^[#\\b equation  \\b^[@\\b date \\i \\i\n"
		"\\i \\i \\b^QV\\b start of last search    \\b^V\\b overtype mode         \\b^[=\\b result    \\b^[!\\b time \\i \\i\n"
		"\\i \\i \\b^Q]\\b next matching brace  \\u\\bGOTO\\b\\u                 \\u\\bREFORMAT\\b\\u        \\u\\bINDENT LINE\\b\\u   \\i \\i\n"
		"\\i \\i \\b^Q[\\b previous   \"    \"    \\b^Q-\\b column number    \\b^B\\b  line        \\b^K.\\b more      \\i \\i\n"
		"\\i \\i \\b^QP\\b previous place       \\b^QI\\b line number      \\b^KD\\b block       \\b^K,\\b less      \\i \\i\n"
		"\\i \\i \\b^K=\\b next place           \\b^QO\\b byte offset      \\b^]\\b  split line  \\b^KA\\b centre    \\i \\i\n"
		"\\i \\i \\b^QB\\b to ^KB  \\b^QK\\b to ^KK  \\b^Q\\b \\u0-9\\u bookmark #0-9  \\b^K]\\b fix whitespace at EOL/EOF \\i \\i\n"
		"}\n"
		"\n"
		"{Advanced\n"
		"\\i   Help Screen    turn off with ^J     prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i \\u\\bCOMPILING\\b\\u                                \\u\\bMISC\\b\\u                               \\i \\i\n"
		"\\i \\i \\b^[C\\b compile \\uand\\u  \\b^[E\\b parse errors        \\b^Q.\\b scroll right                   \\i \\i\n"
		"\\i \\i \\b^[M\\b goto next... \\b^[N\\b previous error      \\b^Q,\\b scroll left                    \\i \\i\n"
		"\\i \\i \\b^KF\\b save, compile & upload to NXT brick  \\b^QL\\b refresh                        \\i \\i\n"
		"\\i \\i \\u\\bMACROS\\b\\u                                   \\b^QQ\\b repeat                         \\i \\i\n"
		"\\i \\i \\b^[(\\b record  \\b^[/\\b query  \\b^[?\\b list defined  \\b^Q?\\b status                         \\i \\i\n"
		"\\i \\i \\b^[)\\b stop   \\b^N\\b play #0  \\b^[\\b \\u0-9\\u play #0-9  \\b^[H\\b message                        \\i \\i\n"
		"\\i \\i \\u\\bMATH\\b\\u (hex or double float) variables: \\ubyte\\u \\ucol\\u \\uheight\\u \\uline\\u \\ulines\\u \\utop\\u \\uwidth\\u  \\i \\i\n"
		"}\n"
		"\n"
		"{Search\n"
		"\\i   Help Screen    turn off with ^J     prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i \\u\\bSpecial search sequences:\\b\\u                                                   \\i \\i\n"
		"\\i \\i  \\b\\\\^\\b  \\b\\\\$\\b  matches beg./end of line         \\b\\\\?\\b     match any single char      \\i \\i\n"
		"\\i \\i  \\b\\\\<\\b  \\b\\\\>\\b  matches beg./end of word         \\b\\\\*\\b     match 0 or more chars      \\i \\i\n"
		"\\i \\i  \\b\\\\c\\b      matches balanced C expression    \\b\\\\\\\\\\b     matches a backslash (\\\\)    \\i \\i\n"
		"\\i \\i  \\b\\\\[a-z]\\b  matches one of a set, ^ inverts  \\b\\\\n\\b     matches a newline          \\i \\i\n"
		"\\i \\i  \\b\\\\+\\b      matches 0 or more of the character which follows the \\\\+            \\i \\i\n"
		"\\i \\i \\u\\bSpecial replace sequences:\\b\\u                                                  \\i \\i\n"
		"\\i \\i  \\b\\\\\\\\\\b      replaced with a backslash (\\\\)    \\b\\\\n\\b     replaced with a newline    \\i \\i\n"
		"\\i \\i  \\b\\\\&\\b      replaced with the text which matched the search string             \\i \\i\n"
		"\\i \\i  \\b\\\\\\b\\u0\\u - \\u9\\u  replaced with text which matched \\uN+1\\uth \\\\?, \\\\*, \\\\c, \\\\[a-z] or \\\\+    \\i \\i\n"
		"}\n"
		"\n"
		"{Names\n"
		"\\i   Help Screen    turn off with ^J     prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i At file name prompts use the cursor up/down keys to access a history of     \\i \\i\n"
		"\\i \\i recently used files or the tab key to complete them.  \\u\\bSpecial file names:\\b\\u   \\i \\i\n"
		"\\i \\i      \\b!\\b\\ucommand\\u                 Pipe in/out of a shell command                \\i \\i\n"
		"\\i \\i      \\b>>\\b\\ufilename\\u               Append to a file                              \\i \\i\n"
		"\\i \\i      \\b-\\b                        Read/Write to/from standard I/O               \\i \\i\n"
		"\\i \\i      \\ufilename\\u\\b,\\b\\uSTART\\u\\b,\\b\\uSIZE\\u      Read/Write a part of a file/device            \\i \\i\n"
		"\\i \\i          Give START/SIZE in decimal (255), octal (0377) or hex (0xFF)       \\i \\i\n"
		"\\i \\i \\u\\bPresentation mode:\\b\\u \\bF6\\b=fullscreen; \\bF7\\b=previous, \\bF8\\b=next win; \\bF9\\b=filter/again \\i \\i\n"
		"}\n"
		"\n"
		"{Joe\n"
		"\\i   Help Screen    turn off with ^J     prev. screen ^[,    next screen ^[.     \\i\n"
		"\\i \\i \\bJUPP\\b is based upon JOE (Joe's Own Editor) 2.8/3.x \\d(GPL v1)\\d by Joe H. Allen; \\i \\i\n"
		"\\i \\i go to \\uhttp://sf.net/projects/joe-editor/\\u for upstream bug reports. JUPP 2.8 \\i \\i\n"
		"\\i \\i for DOS compiled by A. Totlis, packed with LHarc 2.13; JUPP 3.x for UNIX\\d(R)\\d \\i \\i\n"
		"\\i \\i at \\uhttp://mirbsd.de/jupp\\u and by \\bThorsten \"\\dmirabilos\\d\" Glaser <\\utg@mirbsd.org\\u>\\b \\i \\i\n"
		"\\i \\i @(#) blt_in 2018-10-20; 3.1; autoCR-LF; UTF-8 via locale; per-file encoding \\i \\i\n"
		"}\n"
		"\n"
		"{CharTable\n"
		"\\i   Help Screen    turn off with ^J     prev. screen ^[,    \\uCharacter Map\\u       \\i\n"
		"\\i \\i Dec Hex  \\u 0123 4567  89AB CDEF    0123 4567  89AB CDEF \\u  Hex Dec            \\i \\i\n"
		"\\i \\i         |                                              |                    \\i \\i\n"
		"\\i \\i   0  00 | \\u@ABC\\u \\uDEFG\\u  \\uHIJK\\u \\uLMNO\\u    \x80\x81\x82\x83 \x84\x85\x86\x87  \x88\x89\x8A\x8B \x8C\x8D\x8E\x8F | 80  128            \\i \\i\n"
		"\\i \\i  16  10 | \\uPQRS\\u \\uTUVW\\u  \\uXYZ[\\u \\u\\\\]^_\\u    \x90\x91\x92\x93 \x94\x95\x96\x97  \x98\x99\x9A\x9B \x9C\x9D\x9E\x9F | 90  144            \\i \\i\n"
		"\\i \\i  32  20 |  !\"# $%&'  ()*+ ,-./    \xA0\xA1\xA2\xA3 \xA4\xA5\xA6\xA7  \xA8\xA9\xAA\xAB \xAC\xAD\xAE\xAF | A0  160            \\i \\i\n"
		"\\i \\i  48  30 | 0123 4567  89:; <=>?    \xB0\xB1\xB2\xB3 \xB4\xB5\xB6\xB7  \xB8\xB9\xBA\xBB \xBC\xBD\xBE\xBF | B0  176            \\i \\i\n"
		"\\i \\i  64  40 | @ABC DEFG  HIJK LMNO    \xC0\xC1\xC2\xC3 \xC4\xC5\xC6\xC7  \xC8\xC9\xCA\xCB \xCC\xCD\xCE\xCF | C0  192            \\i \\i\n"
		"\\i \\i  80  50 | PQRS TUVW  XYZ[ \\\\]^_    \xD0\xD1\xD2\xD3 \xD4\xD5\xD6\xD7  \xD8\xD9\xDA\xDB \xDC\xDD\xDE\xDF | D0  208            \\i \\i\n"
		"\\i \\i  96  60 | `abc defg  hijk lmno    \xE0\xE1\xE2\xE3 \xE4\xE5\xE6\xE7  \xE8\xE9\xEA\xEB \xEC\xED\xEE\xEF | E0  224            \\i \\i\n"
		"\\i \\i 112  70 | pqrs tuvw  xyz{ |}~\x7F    \xF0\xF1\xF2\xF3 \xF4\xF5\xF6\xF7  \xF8\xF9\xFA\xFB \xFC\xFD\xFE\xFF | F0  240            \\i \\i\n"
		"}\n"
		"\n"
		"{Paste\n"
		"\\i                                                                               \\i\n"
		"\\i \\i \\u\\bPaste Mode\\b\\u     turn off with \\b^D\\b or \\b^[[201~\\b                                  \\i \\i\n"
		"}\n"
		"\n"
		":windows\n"
		"type		^@ TO \xFF\n"
		"abort		^K Q\n"
		"abort		^K ^Q\n"
		"abort		^K q\n"
		"arg		^Q Q\n"
		"arg		^Q ^Q\n"
		"arg		^Q q\n"
		"arg		^[ q q\n"
		"explode		.k6\n"
		"explode		^K I\n"
		"explode		^K ^I\n"
		"explode		^K i\n"
		"explode		^[ [ 1 7 ~\n"
		"help		.k1\n"
		"help		^J\n"
		"help		^[ [ 1 1 ~\n"
		"hnext		^[ .\n"
		"hprev		^[ ,\n"
		"math		^Q M\n"
		"math		^Q ^M\n"
		"math		^Q m\n"
		"math		^[ q m\n"
		"mathins		^[ #\n"
		"mathres		^[ =\n"
		"msg		^[ H\n"
		"msg		^[ h\n"
		"nextw		.k8\n"
		"nextw		^K N\n"
		"nextw		^K ^N\n"
		"nextw		^K n\n"
		"nextw		^[ [ 1 9 ~\n"
		"play		^[ 0 TO 9\n"
		"prevw		.k7\n"
		"prevw		^K P\n"
		"prevw		^K ^P\n"
		"prevw		^K p\n"
		"prevw		^[ [ 1 8 ~\n"
		"query		^[ /\n"
		"quote		`\n"
		"quote8		^P\n"
		"record		^[ (\n"
		"retype		^Q L\n"
		"retype		^Q ^L\n"
		"retype		^Q l\n"
		"retype		^[ q l\n"
		"rtn		^M\n"
		"shell		^K Z\n"
		"shell		^K ^Z\n"
		"shell		^K z\n"
		"stop		^[ )\n"
		"\n"
		":Paste\n"
		"type					^@ TO \xFF\n"
		"rtn					^M\n"
		"msg,\"Entered bracketed paste mode\",rtn	^[ [ 2 0 0 ~\n"
		"helpcard,rtn,keymap,\"main\",rtn,msg,rtn	^[ [ 2 0 1 ~\n"
		"helpcard,rtn,keymap,\"main\",rtn		^D\n"
		"\n"
		":Pasteprompt\n"
		"type					^@ TO \xFF\n"
		"nop					^L\n"
		"keymap,\"prompt\",rtn,msg,rtn,rtn		^M\n"
		"msg,\"Entered bracketed paste mode\",rtn	^[ [ 2 0 0 ~\n"
		"keymap,\"prompt\",rtn,msg,rtn		^[ [ 2 0 1 ~\n"
		"keymap,\"prompt\",rtn			^D\n"
		"\n"
		":main\n"
		":inherit windows\n"
		":def dosrch setmark,\":\",ffirst\n"
		":def dorepl setmark,\":\",qrepl\n"
		":def pastemain helpcard,\"Paste\",rtn,keymap,\"Paste\",rtn\n"
		":def conflictmarker dosrch,\"\\\\^\\\\[<>=]\\\\[<>=]\\\\[<>=]\\\\[<>=]\\\\[<>=]\\\\[<>=]\\\\[<>=]\\\\[ \\\\n]\",rtn,rtn,ltarw\n"
		":def fixwhitespace psh,setmark,\":\",eof,\" \",bof,\"a\",qrepl,\"\\\\[\",quote,\"i\",quote,\"k\",quote,\"l\",quote,\"m ]\\\\+\\\\[\",quote,\"i\",quote,\"k\",quote,\"l\",quote,\"m ]\\\\$\",rtn,rtn,rtn,\"r\",eof,rtn,ffirst,\"\\\\^\\\\[^\\\\n]\",rtn,\"b\",rtn,eol,markb,bof,delch,eof,markk,blkdel,ffirst,\"\\\\?\",rtn,\"b\",rtn,eol,rtn,gomark,\":\",eof\n"
		":def freedroidz psh,splitw,prevw,scratch,\"nbc-Output\",rtn,nextw,save,markk,bol,markb,prevw,prevw,blkcpy,nextw,nextw,rtn,prevw,eol,\"'\",bol,qrepl,\"'\",rtn,rtn,\"'\\\\\\\\''\",rtn,\"r\",backs,backs,backs,bol,\"LC_ALL=C; export LC_ALL; fn='\",eol,\"; p=--posix; sed $p -e q </dev/null >/dev/null 2>&1 || p=; r=$(sed $p -e 's[^^][&]g; s\\\\^\\\\\\\\^g' <<EOF\",rtn,\"$fn\",rtn,\"EOF\",rtn,\"); (case $fn in *.nxc) ;; *) echo '==> Error: filename not *.nxc'; exit ;; esac; echo \\\"Compiling $fn\\\"; nbc -sm- -d \\\"$fn\\\" 2>&1; x=$?; if test $x = 0; then echo '==> OK'; else echo '==> Error code:' $x; fi) | tr '\\\\n' '' | sed $p -e 's!# *\\\\([^]*\\\\)File \\\"[^\\\"]*/\\\\('\\\"$r\\\"'\\\\)\\\" ; line \\\\([0-9]*\\\\)!\\\\2:\\\\3: \\\\1!g' -e 's!#\\\\([^]*\\\\)File \\\"\\\\([^\\\"]*\\\\)\\\" ; line \\\\([0-9]*\\\\)!\\\\2:\\\\3: \\\\1!g' | tr '' '\\\\n'\",rtn,nmark,filt,\"sh\",rtn,rtn,\"Press ^KQ to close this window!\",rtn,parserr\n"
		":def docompile edit,rtn,filt,query,parserr\n"
		":def filtall nmark,filt,uparw\n"
		":def pvsrch prevpos,gomark,\":\"\n"
		":def inscurdate insf,\"!date '+%Y-%m-%d'\",rtn,eol,delch\n"
		":def inscurtime insf,\"!date '+%H:%M:%S'\",rtn,eol,delch\n"
		"setmark,\":\",uparw,gomark,\":\",begin_marking,uparw,toggle_marking	^[ [ 1 ; 2 A\n"
		"setmark,\":\",dnarw,gomark,\":\",begin_marking,dnarw,toggle_marking	^[ [ 1 ; 2 B\n"
		"setmark,\":\",rtarw,gomark,\":\",begin_marking,rtarw,toggle_marking	^[ [ 1 ; 2 C\n"
		"setmark,\":\",ltarw,gomark,\":\",begin_marking,ltarw,toggle_marking	^[ [ 1 ; 2 D\n"
		"setmark,\":\",bol,gomark,\":\",begin_marking,bol,toggle_marking	^[ [ 1 ; 2 H\n"
		"setmark,\":\",eol,gomark,\":\",begin_marking,eol,toggle_marking	^[ [ 1 ; 2 F\n"
		"setmark,\":\",bof,gomark,\":\",begin_marking,bof,toggle_marking	^[ [ 1 ; 6 H\n"
		"setmark,\":\",eof,gomark,\":\",begin_marking,eof,toggle_marking	^[ [ 1 ; 6 F\n"
		"pastemain	^[ P\n"
		"pastemain	^[ p\n"
		"pastemain	^[ [ 2 0 0 ~\n"
		"nop		^[ [ 2 0 1 ~\n"
		"backs		^?\n"
		"backs		^H\n"
		"backw		^[ o\n"
		"bknd		^K '\n"
		"bkwdc		^Q G ^@ TO \xFF\n"
		"bkwdc		^Q ^G ^@ TO \xFF\n"
		"bkwdc		^Q g ^@ TO \xFF\n"
		"bkwdc		^[ q g ^@ TO \xFF\n"
		"blkcpy		^K C\n"
		"blkcpy		^K ^C\n"
		"blkcpy		^K c\n"
		"blkdel		^K Y\n"
		"blkdel		^K ^Y\n"
		"blkdel		^K y\n"
		"blkmove		^K V\n"
		"blkmove		^K ^V\n"
		"blkmove		^K v\n"
		"blksave		^K W\n"
		"blksave		^K ^W\n"
		"blksave		^K w\n"
		"bof		^Q R\n"
		"bof		^Q ^R\n"
		"bof		^Q r\n"
		"bof		^[ [ 1 ; 5 H\n"
		"bof		^[ q r\n"
		"home		.kh\n"
		"home		^Q S\n"
		"home		^Q ^S\n"
		"home		^Q s\n"
		"home		^[ [ 1 ~\n"
		"home		^[ [ 7 ~\n"
		"home		^[ [ H\n"
		"home		^[ q s\n"
		"bos		^Q X\n"
		"bos		^Q ^X\n"
		"bos		^Q x\n"
		"bos		^[ q x\n"
		"byte		^Q O\n"
		"byte		^Q ^O\n"
		"byte		^Q o\n"
		"byte		^[ q o\n"
		"center		^K A\n"
		"center		^K ^A\n"
		"center		^K a\n"
		"col		^Q -\n"
		"col		^[ q -\n"
		"conflictmarker	^Q =\n"
		"conflictmarker	^[ q =\n"
		"crawll		^Q ,\n"
		"crawll		^[ q ,\n"
		"crawlr		^Q .\n"
		"crawlr		^[ q .\n"
		"delbol		^Q T\n"
		"delbol		^Q ^?\n"
		"delbol		^Q ^T\n"
		"delbol		^Q t\n"
		"delbol		^[ q ^?\n"
		"delbol		^[ q t\n"
		"delch		.kD\n"
		"delch		^G\n"
		"delch		^[ [ 3 ~\n"
		"deleol		^Q Y\n"
		"deleol		^Q ^Y\n"
		"deleol		^Q y\n"
		"deleol		^[ q y\n"
		"dellin		^Y\n"
		"delw		^T\n"
		"dnarw		.kd\n"
		"dnarw		^X\n"
		"dnarw		^[ O B\n"
		"dnarw		^[ [ B\n"
		"dnslide		^Z\n"
		"edit		^K E\n"
		"edit		^K ^E\n"
		"edit		^K e\n"
		"eof		^Q C\n"
		"eof		^Q ^C\n"
		"eof		^Q c\n"
		"eof		^[ [ 1 ; 5 F\n"
		"eof		^[ q c\n"
		"eol		.@7\n"
		"eol		.kH\n"
		"eol		^Q D\n"
		"eol		^Q ^D\n"
		"eol		^Q d\n"
		"eol		^[ [ 4 ~\n"
		"eol		^[ [ 8 ~\n"
		"eol		^[ [ F\n"
		"eol		^[ q d\n"
		"execmd		^[ -\n"
		"exsave		^K X\n"
		"exsave		^K ^X\n"
		"exsave		^K x\n"
		"dosrch		^Q F\n"
		"dosrch		^Q ^F\n"
		"dosrch		^Q f\n"
		"dosrch		^[ q f\n"
		"filt		^K /\n"
		"filtall		.k9\n"
		"filtall		^[ [ 2 0 ~\n"
		"fixwhitespace	^K ]\n"
		"fmtblk		^K D\n"
		"fmtblk		^K ^D\n"
		"fmtblk		^K d\n"
		"format		^B\n"
		"fnext		.k3\n"
		"fnext		^L\n"
		"fnext		^[ [ 1 3 ~\n"
		"freedroidz	^K F\n"
		"freedroidz	^K ^F\n"
		"freedroidz	^K f\n"
		"fwrdc		^Q H ^@ TO \xFF\n"
		"fwrdc		^Q ^H ^@ TO \xFF\n"
		"fwrdc		^Q h ^@ TO \xFF\n"
		"fwrdc		^[ q h ^@ TO \xFF\n"
		"gomark		^Q 0 TO 9\n"
		"gomark		^[ q 0 TO 9\n"
		"groww		^K G\n"
		"groww		^K ^G\n"
		"groww		^K g\n"
		"inscurdate	^[ @\n"
		"inscurtime	^[ !\n"
		"insf		^K R\n"
		"insf		^K ^R\n"
		"insf		^K r\n"
		"isrch		^[ T\n"
		"isrch		^[ t\n"
		"lindent		^K ,\n"
		"line		^Q I\n"
		"line		^Q ^I\n"
		"line		^Q i\n"
		"line		^[ q i\n"
		"ltarw		.kl\n"
		"ltarw		^S\n"
		"ltarw		^[ O D\n"
		"ltarw		^[ [ D\n"
		"ltarw		^[ s\n"
		"macros		^[ ?\n"
		"markb		^K B\n"
		"markb		^K ^B\n"
		"markb		^K b\n"
		"markk		^K K\n"
		"markk		^K ^K\n"
		"markk		^K k\n"
		"markl		^K L\n"
		"markl		^K ^L\n"
		"markl		^K l\n"
		"mode		^O\n"
		"mode,\"T\"	.kI\n"
		"mode,\"T\"	^V\n"
		"mode,\"T\"	^[ [ 2 ~\n"
		"mode,\"T\"	^[ [ L\n"
		"nextpos		^K =\n"
		"nextword	^F\n"
		"nextword	^[ [ 1 ; 5 C\n"
		"nmark		^K H\n"
		"nmark		^K ^H\n"
		"nmark		^K h\n"
		"nxterr		^[ M\n"
		"nxterr		^[ m\n"
		"open		^]\n"
		"docompile	^[ C\n"
		"docompile	^[ c\n"
		"parserr		^[ E\n"
		"parserr		^[ e\n"
		"pgdn		.kN\n"
		"pgdn		^C\n"
		"pgdn		^[ [ 6 ~\n"
		"pgdn		^[ [ G\n"
		"pgup		.kP\n"
		"pgup		^R\n"
		"pgup		^[ [ 5 ~\n"
		"pgup		^[ [ I\n"
		"play,\"0\"	^N\n"
		"prevpos		^Q P\n"
		"prevpos		^Q ^P\n"
		"prevpos		^Q p\n"
		"prevpos		^[ q p\n"
		"prevword	^A\n"
		"prevword	^[ [ 1 ; 5 D\n"
		"prverr		^[ N\n"
		"prverr		^[ n\n"
		"pvsrch		^Q V\n"
		"pvsrch		^Q ^V\n"
		"pvsrch		^Q v\n"
		"pvsrch		^[ q v\n"
		"dorepl		^Q A\n"
		"dorepl		^Q ^A\n"
		"dorepl		^Q a\n"
		"dorepl		^[ q a\n"
		"redo		^^\n"
		"rindent		^K .\n"
		"rsrch		^[ R\n"
		"rsrch		^[ r\n"
		"rtarw		.kr\n"
		"rtarw		^D\n"
		"rtarw		^[ O C\n"
		"rtarw		^[ [ C\n"
		"run		^[ '\n"
		"save		^K S\n"
		"save		^K ^S\n"
		"save		^K s\n"
		"scratch,\"(S) \"	^K -\n"
		"setmark		^K 0 TO 9\n"
		"shrinkw		^K T\n"
		"shrinkw		^K ^T\n"
		"shrinkw		^K t\n"
		"splitw		^K O\n"
		"splitw		^K ^O\n"
		"splitw		^K o\n"
		"stat		^Q ?\n"
		"stat		^[ q ?\n"
		"tag		^K ;\n"
		"tomarkb		^Q B\n"
		"tomarkb		^Q ^B\n"
		"tomarkb		^Q b\n"
		"tomarkb		^[ q b\n"
		"tomarkk		^Q K\n"
		"tomarkk		^Q ^K\n"
		"tomarkk		^Q k\n"
		"tomarkk		^[ q k\n"
		"rvmatch		^Q [\n"
		"tomatch		^Q ]\n"
		"rvmatch		^Q ^[\n"
		"tomatch		^Q ^]\n"
		"rvmatch		^[ q [\n"
		"tomatch		^[ q ]\n"
		"tos		^Q E\n"
		"tos		^Q ^E\n"
		"tos		^Q e\n"
		"tos		^[ q e\n"
		"undo		^U\n"
		"undo		^_\n"
		"uparw		.ku\n"
		"uparw		^E\n"
		"uparw		^[ O A\n"
		"uparw		^[ [ A\n"
		"upslide		^W\n"
		"yankpop		^[ Y\n"
		"yankpop		^[ y\n"
		"\n"
		":prompt\n"
		":inherit main\n"
		":def pasteprompt keymap,\"Pasteprompt\",rtn,msg,\"Entered bracketed paste mode\",rtn\n"
		"abort		^C\n"
		"abort		^U\n"
		"complete	^I\n"
		"nop		^L\n"
		"pasteprompt	^[ P\n"
		"pasteprompt	^[ p\n"
		"pasteprompt	^[ [ 2 0 0 ~\n"
		"\n"
		":menu\n"
		":inherit windows\n"
		"abort		^U\n"
		"abort		^[ ^[\n"
		"backsmenu	^?\n"
		"backsmenu	^H\n"
		"bofmenu		^Q R\n"
		"bofmenu		^Q ^R\n"
		"bofmenu		^Q r\n"
		"bofmenu		^[ [ 1 ; 5 H\n"
		"bofmenu		^[ q r\n"
		"bolmenu		.kh\n"
		"bolmenu		^Q S\n"
		"bolmenu		^Q ^S\n"
		"bolmenu		^Q s\n"
		"bolmenu		^[ [ 1 ~\n"
		"bolmenu		^[ [ 7 ~\n"
		"bolmenu		^[ [ H\n"
		"bolmenu		^[ q s\n"
		"dnarwmenu	.kd\n"
		"dnarwmenu	^X\n"
		"dnarwmenu	^[ O B\n"
		"dnarwmenu	^[ [ B\n"
		"eofmenu		^Q C\n"
		"eofmenu		^Q ^C\n"
		"eofmenu		^Q c\n"
		"eofmenu		^[ [ 1 ; 5 F\n"
		"eofmenu		^[ q c\n"
		"eolmenu		.@7\n"
		"eolmenu		.kH\n"
		"eolmenu		^Q D\n"
		"eolmenu		^Q ^D\n"
		"eolmenu		^Q d\n"
		"eolmenu		^[ [ 4 ~\n"
		"eolmenu		^[ [ 8 ~\n"
		"eolmenu		^[ [ F\n"
		"eolmenu		^[ q d\n"
		"ltarwmenu	.kl\n"
		"ltarwmenu	^S\n"
		"ltarwmenu	^[ O D\n"
		"ltarwmenu	^[ [ D\n"
		"ltarwmenu	^[ s\n"
		"pgdnmenu	.kN\n"
		"pgdnmenu	^C\n"
		"pgdnmenu	^[ [ 6 ~\n"
		"pgdnmenu	^[ [ G\n"
		"pgupmenu	.kP\n"
		"pgupmenu	^R\n"
		"pgupmenu	^[ [ 5 ~\n"
		"pgupmenu	^[ [ I\n"
		"rtarwmenu	.kr\n"
		"rtarwmenu	^D\n"
		"rtarwmenu	^[ O C\n"
		"rtarwmenu	^[ [ C\n"
		"rtn		SP\n"
		"rtn		^J\n"
		"tabmenu		^I\n"
		"uparwmenu	.ku\n"
		"uparwmenu	^E\n"
		"uparwmenu	^[ O A\n"
		"uparwmenu	^[ [ A\n"
		"\n"
		":query\n"
		":inherit windows\n"
		"\n"
		":querya\n"
		"type		^@ TO \xFF\n"
		"\n"
		":querysr\n"
		"type		^@ TO \xFF\n"
,	NULL
};
