/*
 *      fhist - file history and comparison tools
 *      Copyright (C) 2000-2002, 2008 Peter Miller
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see
 *      <http://www.gnu.org/licenses/>.
 */

#include <ac/string.h>

#include <error.h> /* for assert */
#include <mem.h>
#include <output/private.h>


output_ty *
output_new(output_vtbl_ty *vptr)
{
    output_ty       *this;

    assert(vptr->size > sizeof(output_ty));
    this = mem_alloc(vptr->size);
    this->vptr = vptr;
    return this;
}


void
output_generic_fputs(output_ty *fp, const char *s)
{
    fp->vptr->write(fp, s, strlen(s));
}


void
output_generic_write(output_ty *fp, const void *data, size_t len)
{
    const unsigned char *p;

    p = data;
    while (len > 0)
    {
        fp->vptr->fputc(fp, *p++);
        --len;
    }
}


void
output_generic_flush(output_ty *fp)
{
}
