/* $Id$ 
 * Driver: one driver associated to a signal name.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __DRIVER_HPP_INCLUDED
#define __DRIVER_HPP_INCLUDED

#include "frontend/ast/SignalDeclaration.hpp"

namespace ast {

//! represents one VHDL driver relative to a complete type.
/** This can represent one driver of a VHDL signal. It will always reflect
 *  the complete type, i.e. a driver of a composite type is a driver, that
 *  has drivers to each elements embedded.
 */
class Driver {
public:
	//! c'tor
	/** @param d corresponding SignalDeclaration.
	 *  @param counter unique driver counter.
	 *  @param n SimpleName referencing the declaration
	 */
	Driver(
		const SignalDeclaration &d,
		unsigned int counter,
		SimpleName *reference);

	//! d'tor.
	~Driver();
	
	//! find out the storage name of the driver
	/** @return storage name of the driver 
	 *  FIXME this changes the ABI because it has the number embedded.
	 *        (the name of a procedure call's driver would change hence).
	 */
	std::string getICName(void) const {
		return this->signal.getICName() + "__driver__" 
			+ util::MiscUtil::toString(this->cnt);
	}

	//! find out the foreign name of the driver
	/** @return foreign name of the driver.
	 */
	std::string getForeignName(void) const {
		return (*this->signal.name) + "__driver__";
	}

	//! corresponding SignalDeclaration
	const SignalDeclaration &signal;

	/** SimpleName referring to the declaration */
	SimpleName *n;
private:
	/** counter to guarantee that two drivers to the same signal result in
	 *  a unique name.
	 */
	unsigned int cnt;
};

}; /* namespace ast */

#endif /*  __DRIVER_HPP_INCLUDED */
