!{\src2tex{textfont=tt}}
!!****m* etsf_geometry/etsf_io_geometry_put
!! NAME
!!  etsf_io_geometry_put
!!
!! FUNCTION
!!    Write data related to the given group in an opened ETSF file (it must be in
!!    write mode, use etsf_io_low_set_write_mode() to change it).
!!    Only associated pointers of argument @folder will be accessed. If any errors
!!    occurs it returns with @lstat = .false..
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * folder <type(etsf_geometry)> = 
!!     an allocated structure with pointers on allocated areas in memory.
!!     These areas will be read or written if the pointer is associated, if
!!     not, the variable will be ignored. It is possible to access to specific
!!     dimensions of a variable using the <short_var_name>__kpoint_access or
!!     <short_var_name>__spin_access of this @folder structure. The 
!!     <short_var_name>__number_of_<something> can also been set if only a subpart
!!     in one dimension should be accessed (this is possible when the specifications
!!     have been declared with a max_number_of_<something>.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_geometry_put(ncid, folder, lstat, error_data)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_geometry), intent(in) :: folder
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_geometry_put'
  integer,allocatable :: varid(:)
  integer,allocatable :: start(:)
  integer,allocatable :: count(:)
  integer :: len
  character(etsf_charlen) :: flag


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_geometry_put : enter'
!ENDDEBUG

  
  allocate(varid(11))
  ! Begin by putting the file in write mode.
  call etsf_io_low_set_write_mode(ncid, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  if (associated(folder%space_group)) then
    call etsf_io_low_write_var(ncid, "space_group", &
                            & folder%space_group, &
                            & lstat, ncvarid = varid(1), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%primitive_vectors)) then
    call etsf_io_low_write_var(ncid, "primitive_vectors", &
                            & folder%primitive_vectors, &
                            & lstat, ncvarid = varid(2), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%reduced_symmetry_matrices)) then
    call etsf_io_low_write_var(ncid, "reduced_symmetry_matrices", &
                            & folder%reduced_symmetry_matrices, &
                            & lstat, ncvarid = varid(3), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%reduced_symmetry_translations)) then
    call etsf_io_low_write_var(ncid, "reduced_symmetry_translations", &
                            & folder%reduced_symmetry_translations, &
                            & lstat, ncvarid = varid(4), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%atom_species)) then
    call etsf_io_low_write_var(ncid, "atom_species", &
                            & folder%atom_species, &
                            & lstat, ncvarid = varid(5), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%reduced_atom_positions)) then
    call etsf_io_low_write_var(ncid, "reduced_atom_positions", &
                            & folder%reduced_atom_positions, &
                            & lstat, ncvarid = varid(6), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%valence_charges)) then
    call etsf_io_low_write_var(ncid, "valence_charges", &
                            & folder%valence_charges, &
                            & lstat, ncvarid = varid(7), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%atomic_numbers)) then
    call etsf_io_low_write_var(ncid, "atomic_numbers", &
                            & folder%atomic_numbers, &
                            & lstat, ncvarid = varid(8), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%atom_species_names)) then
    call etsf_io_low_write_var(ncid, "atom_species_names", &
                            & folder%atom_species_names, etsf_charlen, &
                            & lstat, ncvarid = varid(9), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%chemical_symbols)) then
    call etsf_io_low_write_var(ncid, "chemical_symbols", &
                            & folder%chemical_symbols, etsf_chemlen, &
                            & lstat, ncvarid = varid(10), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%pseudopotential_types)) then
    call etsf_io_low_write_var(ncid, "pseudopotential_types", &
                            & folder%pseudopotential_types, etsf_charlen, &
                            & lstat, ncvarid = varid(11), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  ! Handle all attributes for the group.
  call etsf_io_low_set_define_mode(ncid, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  if (associated(folder%reduced_symmetry_translations)) then
    ! Handle the symmorphic attribute.
    ! We test if translations are not nul
    flag = "yes"
    do len = 1, size(folder%reduced_symmetry_translations, 2), 1
      if (folder%reduced_symmetry_translations(1, len) /= 0.d0 .or. &
        & folder%reduced_symmetry_translations(2, len) /= 0.d0 .or. &
        & folder%reduced_symmetry_translations(3, len) /= 0.d0) then
      flag = "no"
      end if
    end do
    call etsf_io_low_write_att(ncid, varid(3), &
                            & "symmorphic", &
                            & trim(flag), &
                            & lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  
  deallocate(varid)

!DEBUG
!write (*,*) 'etsf_io_geometry_put : exit'
!ENDDEBUG

end subroutine etsf_io_geometry_put
!!***
