.\" dpkg manual page - deb-symbols(5)
.\"
.\" Copyright © 2007-2012 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011, 2013-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH deb\-symbols 5 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
deb\-symbols \- Fichier d'information sur les bibliothèques partagées Debian
.
.SH SYNOPSIS
symboles
.
.SH DESCRIPTION
Les fichiers de symboles sont fournis dans les paquets binaires de Debian et
leur format est un sous\-ensemble des fichiers modèles de symboles utilisés
par \fBdpkg\-gensymbols\fP(1) dans les paquets source Debian.
.P
Le format pour une entrée d'information sur les dépendances étendues avec
bibliothèques partagées dans ces fichiers est le suivant\ :
.PP
\fIsoname\-de\-bibliothèque modèle\-principal\-de\-dépendance\fP
.br
[| \fImodèle\-alternatif\-de\-dépendance\fP]
.br
[...]
.br
[* \fInom\-du\-champ\fP: \fIvaleur\-du\-champ\fP]
.br
[...]
 \fIsymbole\fP \fIversion\-minimale\fP[\fIid\-du\-modèle\-de\-dépendance\fP]
.P
La variable \fIsoname\-de\-bibliothèque\fP est exactement la valeur du champ
SONAME telle qu'exportée par \fBobjdump\fP(1). Un \fImodèle\-de\-dépendance\fP est
une dépendance où \fI#MINVER#\fP est dynamiquement remplacé soit par une
version comme «\ (>= \fIversion\-minimale\fP)\ » soit par rien (si une
dépendance quelle que soit sa version est reconnue suffisante).
.P
Chaque \fIsymbole\fP exporté (noté \fInom\fP@\fIversion\fP, avec \fIversion\fP réglé à
«\ Base\ » si la bibliothèque n'a pas de version) est associé à une
\fIversion\-minimale\fP dans son modèle de dépendance (le modèle principal de
dépendance est toujours utilisé et se termine combiné avec le modèle de
dépendance référencé par l'\fIid\-du\-modèle\-de\-dépendance\fP est présent). La
première alternative au modèle de dépendance est numérotée\ 1, la
seconde\ 2,\ etc.
.P
Chaque entrée pour une bibliothèque peut aussi avoir des champs de
méta\-information. Ces champs sont enregistrés dans des lignes qui débutent
par un astérisque («\ *\ »). Actuellement, le seul champ valable est\ :
.TP 
\fBBuild\-Depends\-Package\fP
Il indique le nom du paquet «\ \-dev\ » associé à la bibliothèque et est
utilisé par \fBdpkg\-shlibdeps\fP pour s'assurer que la dépendance produite est
au moins aussi stricte que la dépendance de construction correspondante
(depuis dpkg\ 1.14.13).
.TP 
\fBIgnore\-Blacklist\-Groups\fP
Il indique que les groupes blacklistés seront ignorés, sous forme de liste
séparée par des espaces, afin que les symboles contenus dans ces groupes
soient inclus dans le fichier de sortie (depuis dpkg\ 1.17.6). Cela sera
seulement nécessaire pour les paquets de chaîne d'outils qui fournissent ces
symboles blacklistés. Les groupes disponibles dépendent des systèmes et,
pour les systèmes basés sur ELF et GNU, ce sont \fBaeabi\fP et \fBgomp\fP.
.SH EXEMPLES
.SS "Simple fichier de symboles"
.PP
libftp.so.3 libftp3 #MINVER#
 DefaultNetbuf@Base 3.1\-1\-6
 FtpAccess@Base 3.1\-1\-6
 [...]
.SS "Fichier avancé de symboles"
.PP
libGL.so.1 libgl1
.br
| libgl1\-mesa\-glx #MINVER#
.br
* Build\-Depends\-Package: libgl1\-mesa\-dev
 publicGlSymbol@Base 6.3\-1
 [...]
 implementationSpecificSymbol@Base 6.5.2\-7 1
 [...]
.SH "VOIR AUSSI"
\fBhttps://wiki.debian.org/Projects/ImprovedDpkgShlibdeps\fP
.br
\fBdpkg\-shlibdeps\fP(1), \fBdpkg\-gensymbols\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
