#!/bin/sh

set -e

# Find the available Python 2.x and 3.x versions.

interpreters=''
if [ -n "$(command -v pyversions 2>/dev/null)" ]; then
	for ver in $(pyversions -i -v); do
		interpreters="$interpreters python$ver"
	done
fi
if [ -n "$(command -v py3versions 2>/dev/null)" ]; then
	for ver in $(py3versions -i -v); do
		interpreters="$interpreters python$ver"
	done
fi

# Add PyPy into the mix.

if [ -n "$(command -v pypy 2>/dev/null)" ]; then
	interpreters="$interpreters pypy"
fi

# Finally run the tests.

for python in $interpreters; do
	printf -- '\n\n============ Testing %s\n\n' "$python"
	env CONFGET="$python -m confget" prove t
done

printf -- '\n\n============ The TAP tests passed for all Python versions\n\n'
