package org.aspectj.tools.ajdoc;

import junit.framework.Test;
import junit.textui.TestRunner;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.util.Locale;

import com.sun.javadoc.Doc;


/**
 */
public class SeeTagImplTest  extends TestCase {
	/**
	 * Run this class as a JUnit test case in the textui
	 */
	public static void main(String[] args) {		
		TestRunner.main(new String[]{"org.aspectj.tools.ajdoc.SeeTagImplTest"});
	}

    /** set to true to trigger assertion failures 
     * on any output to error printer.
     */
	static boolean FAIL_ON_PRINTERR = false;

    public static Test suite() { 
        TestSuite result = new TestSuite();
        result.addTestSuite(SeeTagImplTest.class);
        return result;
    }
	// argh - our only dependency on the compiler module is here XXX
	static ErrPrinter ERRPRINTER = new ErrPrinter("SeeTagImplTest") {
        public void printError(String error) {
            super.printError(error);
            if (FAIL_ON_PRINTERR)
                assertTrue(error, false);
        }
    };


    public SeeTagImplTest(String name) { super(name); }

	protected void setUp() {
	    try {
   		    System.setProperty("seetag.debug","on");
	    } catch (SecurityException e) {} // ignore - ok if property off
	}		
				
	static class SeeTestCase {
		final String input;
		final String type;
		final String member;
		final String parms;
		final String label;
		SeeTagImpl result;

		public SeeTestCase(String input, String type, String member, 
							String parms, String label) {
			this.input = input;
			this.type = type;
			this.member = member;
			this.parms = parms;
			this.label = label;
		}

		/** 
		 * Run test.
		 * This implementation creates a SeeTagImpl to test 
		 * (only) SeeTagImpl.resolve().
		 */
		public void run() {
		    result = make(input);
		   	verify("label", label, result.getLabel());
		    verify("type", type, renderType(result.getPackageName(), result.getClassName()));
		   	verify("memberName", renderMember(member, parms), result.getMemberName());
		}

		/** factory for SeeTag based on input normally passed to constructor */
    	SeeTagImpl make(String text) {
    	    Doc doc = null;
    	    String name = "@link";
    	    Locale locale = Locale.getDefault();
    		return new SeeTagImpl(doc, name,text,locale,ERRPRINTER);
    	}

		/** render for comment on error */
		String renderSeeTagImpl(SeeTagImpl input) {
			if (null == input) return "(SeeTagImpl) null";
			String label = render(input.getLabel());
			return renderType(input.getPackageName(), input.getClassName())
				+ "#" + input.getMemberName()
				+ (0 == label.length()? "" : " " + label);
		}
		
		String renderType(String pack, String cl) {
		    cl = render(cl);
		    pack = render(pack);
		   	return (0 == pack.length() ? "": pack + ".") + cl;
		}
		
		String renderMember(String name, String parms) {
		    name = render(name);
		    parms = render(parms);
		   	return (0 == parms.length() ? name : name + parms);
		}

		/** render a null string as "" instead of "null" */
		String render(String str) {
		    return (null == str ? "" : str);
		}

		/** treat empty String as null String */
		String normalize(String str) {
		    if ((null == str) || (str.length() == 0)) {
		        return null;
		    } else {
		        return str+"";
		    }
		}
				
		/** 
		 * assert actual with expected,
		 * including label and entire input in message asserted.
		 */
		void verify(String label, String expected, String actual) {
			expected = normalize(expected);
			actual = normalize(actual);
			String output = renderSeeTagImpl(result);
		    String message = "\""+expected+"\".equals(\"" + actual + "\")" 
		    	+ " // " + label
		    	+ " (\"" + input + "\" -> \"" + output + "\")";
		    if (null == expected) {
		        assertTrue(message, null==actual);
		    } else {
		        assertTrue(message, expected.equals(actual));
		    }
		}
		
	}
	// example of generated
//	static SeeTestCase[] CASES = new SeeTestCase[] 
//		{ new SeeTestCase("Foo#bar() bash", "Foo", "bar", "()", "bash")
//		};
//	public void test1() { CASES[1].run(); }

	// test cases generated by genSeeTestCases.sh
    static final SeeTestCase[] CASES = new SeeTestCase[] { null // first is null
        , new SeeTestCase("#memberName ",  "", "memberName", "", "")  // 0
        , new SeeTestCase(" #memberName   ",  "", "memberName", "", "")
        , new SeeTestCase("#memberName label",  "", "memberName", "", "label")  // 2
        , new SeeTestCase(" #memberName  label ",  "", "memberName", "", "label")
        , new SeeTestCase("#memberName a label",  "", "memberName", "", "a label")  // 4
        , new SeeTestCase(" #memberName  a label ",  "", "memberName", "", "a label")
        , new SeeTestCase("#memberName() ",  "", "memberName", "()", "")  // 6
        , new SeeTestCase(" #memberName ()  ",  "", "memberName", "()", "")
        , new SeeTestCase("#memberName() label",  "", "memberName", "()", "label")  // 8
        , new SeeTestCase(" #memberName () label ",  "", "memberName", "()", "label")
        , new SeeTestCase("#memberName() a label",  "", "memberName", "()", "a label")  // 10
        , new SeeTestCase(" #memberName () a label ",  "", "memberName", "()", "a label")
        , new SeeTestCase("#memberName(int) ",  "", "memberName", "(int)", "")  // 12
        , new SeeTestCase(" #memberName (int)  ",  "", "memberName", "(int)", "")
        , new SeeTestCase("#memberName(int) label",  "", "memberName", "(int)", "label")  // 14
        , new SeeTestCase(" #memberName (int) label ",  "", "memberName", "(int)", "label")
        , new SeeTestCase("#memberName(int) a label",  "", "memberName", "(int)", "a label")  // 16
        , new SeeTestCase(" #memberName (int) a label ",  "", "memberName", "(int)", "a label")
        , new SeeTestCase("#memberName(int,String) ",  "", "memberName", "(int,String)", "")  // 18
        , new SeeTestCase(" #memberName (int,String)  ",  "", "memberName", "(int,String)", "")
        , new SeeTestCase("#memberName(int,String) label",  "", "memberName", "(int,String)", "label")  // 20
        , new SeeTestCase(" #memberName (int,String) label ",  "", "memberName", "(int,String)", "label")
        , new SeeTestCase("#memberName(int,String) a label",  "", "memberName", "(int,String)", "a label")  // 22
        , new SeeTestCase(" #memberName (int,String) a label ",  "", "memberName", "(int,String)", "a label")
        , new SeeTestCase("#memberName( int , String[ ][ ] ) ",  "", "memberName", "( int , String[ ][ ] )", "")  // 24
        , new SeeTestCase(" #memberName ( int , String[ ][ ] )  ",  "", "memberName", "( int , String[ ][ ] )", "")
        , new SeeTestCase("#memberName( int , String[ ][ ] ) label",  "", "memberName", "( int , String[ ][ ] )", "label")  // 26
        , new SeeTestCase(" #memberName ( int , String[ ][ ] ) label ",  "", "memberName", "( int , String[ ][ ] )", "label")
        , new SeeTestCase("#memberName( int , String[ ][ ] ) a label",  "", "memberName", "( int , String[ ][ ] )", "a label")  // 28
        , new SeeTestCase(" #memberName ( int , String[ ][ ] ) a label ",  "", "memberName", "( int , String[ ][ ] )", "a label")
        , new SeeTestCase("#memberName( foo.Bar , com.sun.X ) ",  "", "memberName", "( foo.Bar , com.sun.X )", "")  // 30
        , new SeeTestCase(" #memberName ( foo.Bar , com.sun.X )  ",  "", "memberName", "( foo.Bar , com.sun.X )", "")
        , new SeeTestCase("#memberName( foo.Bar , com.sun.X ) label",  "", "memberName", "( foo.Bar , com.sun.X )", "label")  // 32
        , new SeeTestCase(" #memberName ( foo.Bar , com.sun.X ) label ",  "", "memberName", "( foo.Bar , com.sun.X )", "label")
        , new SeeTestCase("#memberName( foo.Bar , com.sun.X ) a label",  "", "memberName", "( foo.Bar , com.sun.X )", "a label")  // 34
        , new SeeTestCase(" #memberName ( foo.Bar , com.sun.X ) a label ",  "", "memberName", "( foo.Bar , com.sun.X )", "a label")
        , new SeeTestCase("#memberName(foo.Bar) ",  "", "memberName", "(foo.Bar)", "")  // 36
        , new SeeTestCase(" #memberName (foo.Bar)  ",  "", "memberName", "(foo.Bar)", "")
        , new SeeTestCase("#memberName(foo.Bar) label",  "", "memberName", "(foo.Bar)", "label")  // 38
        , new SeeTestCase(" #memberName (foo.Bar) label ",  "", "memberName", "(foo.Bar)", "label")
        , new SeeTestCase("#memberName(foo.Bar) a label",  "", "memberName", "(foo.Bar)", "a label")  // 40
        , new SeeTestCase(" #memberName (foo.Bar) a label ",  "", "memberName", "(foo.Bar)", "a label")
        , new SeeTestCase("Type#memberName ",  "Type", "memberName", "", "")  // 42
        , new SeeTestCase(" Type#memberName   ",  "Type", "memberName", "", "")
        , new SeeTestCase("Type#memberName label",  "Type", "memberName", "", "label")  // 44
        , new SeeTestCase(" Type#memberName  label ",  "Type", "memberName", "", "label")
        , new SeeTestCase("Type#memberName a label",  "Type", "memberName", "", "a label")  // 46
        , new SeeTestCase(" Type#memberName  a label ",  "Type", "memberName", "", "a label")
        , new SeeTestCase("Type#memberName() ",  "Type", "memberName", "()", "")  // 48
        , new SeeTestCase(" Type#memberName ()  ",  "Type", "memberName", "()", "")
        , new SeeTestCase("Type#memberName() label",  "Type", "memberName", "()", "label")  // 50
        , new SeeTestCase(" Type#memberName () label ",  "Type", "memberName", "()", "label")
        , new SeeTestCase("Type#memberName() a label",  "Type", "memberName", "()", "a label")  // 52
        , new SeeTestCase(" Type#memberName () a label ",  "Type", "memberName", "()", "a label")
        , new SeeTestCase("Type#memberName(int) ",  "Type", "memberName", "(int)", "")  // 54
        , new SeeTestCase(" Type#memberName (int)  ",  "Type", "memberName", "(int)", "")
        , new SeeTestCase("Type#memberName(int) label",  "Type", "memberName", "(int)", "label")  // 56
        , new SeeTestCase(" Type#memberName (int) label ",  "Type", "memberName", "(int)", "label")
        , new SeeTestCase("Type#memberName(int) a label",  "Type", "memberName", "(int)", "a label")  // 58
        , new SeeTestCase(" Type#memberName (int) a label ",  "Type", "memberName", "(int)", "a label")
        , new SeeTestCase("Type#memberName(int,String) ",  "Type", "memberName", "(int,String)", "")  // 60
        , new SeeTestCase(" Type#memberName (int,String)  ",  "Type", "memberName", "(int,String)", "")
        , new SeeTestCase("Type#memberName(int,String) label",  "Type", "memberName", "(int,String)", "label")  // 62
        , new SeeTestCase(" Type#memberName (int,String) label ",  "Type", "memberName", "(int,String)", "label")
        , new SeeTestCase("Type#memberName(int,String) a label",  "Type", "memberName", "(int,String)", "a label")  // 64
        , new SeeTestCase(" Type#memberName (int,String) a label ",  "Type", "memberName", "(int,String)", "a label")
        , new SeeTestCase("Type#memberName( int , String[ ][ ] ) ",  "Type", "memberName", "( int , String[ ][ ] )", "")  // 66
        , new SeeTestCase(" Type#memberName ( int , String[ ][ ] )  ",  "Type", "memberName", "( int , String[ ][ ] )", "")
        , new SeeTestCase("Type#memberName( int , String[ ][ ] ) label",  "Type", "memberName", "( int , String[ ][ ] )", "label")  // 68
        , new SeeTestCase(" Type#memberName ( int , String[ ][ ] ) label ",  "Type", "memberName", "( int , String[ ][ ] )", "label")
        , new SeeTestCase("Type#memberName( int , String[ ][ ] ) a label",  "Type", "memberName", "( int , String[ ][ ] )", "a label")  // 70
        , new SeeTestCase(" Type#memberName ( int , String[ ][ ] ) a label ",  "Type", "memberName", "( int , String[ ][ ] )", "a label")
        , new SeeTestCase("Type#memberName( foo.Bar , com.sun.X ) ",  "Type", "memberName", "( foo.Bar , com.sun.X )", "")  // 72
        , new SeeTestCase(" Type#memberName ( foo.Bar , com.sun.X )  ",  "Type", "memberName", "( foo.Bar , com.sun.X )", "")
        , new SeeTestCase("Type#memberName( foo.Bar , com.sun.X ) label",  "Type", "memberName", "( foo.Bar , com.sun.X )", "label")  // 74
        , new SeeTestCase(" Type#memberName ( foo.Bar , com.sun.X ) label ",  "Type", "memberName", "( foo.Bar , com.sun.X )", "label")
        , new SeeTestCase("Type#memberName( foo.Bar , com.sun.X ) a label",  "Type", "memberName", "( foo.Bar , com.sun.X )", "a label")  // 76
        , new SeeTestCase(" Type#memberName ( foo.Bar , com.sun.X ) a label ",  "Type", "memberName", "( foo.Bar , com.sun.X )", "a label")
        , new SeeTestCase("Type#memberName(foo.Bar) ",  "Type", "memberName", "(foo.Bar)", "")  // 78
        , new SeeTestCase(" Type#memberName (foo.Bar)  ",  "Type", "memberName", "(foo.Bar)", "")
        , new SeeTestCase("Type#memberName(foo.Bar) label",  "Type", "memberName", "(foo.Bar)", "label")  // 80
        , new SeeTestCase(" Type#memberName (foo.Bar) label ",  "Type", "memberName", "(foo.Bar)", "label")
        , new SeeTestCase("Type#memberName(foo.Bar) a label",  "Type", "memberName", "(foo.Bar)", "a label")  // 82
        , new SeeTestCase(" Type#memberName (foo.Bar) a label ",  "Type", "memberName", "(foo.Bar)", "a label")
        , new SeeTestCase("junit.Type#memberName ",  "junit.Type", "memberName", "", "")  // 84
        , new SeeTestCase(" junit.Type#memberName   ",  "junit.Type", "memberName", "", "")
        , new SeeTestCase("junit.Type#memberName label",  "junit.Type", "memberName", "", "label")  // 86
        , new SeeTestCase(" junit.Type#memberName  label ",  "junit.Type", "memberName", "", "label")
        , new SeeTestCase("junit.Type#memberName a label",  "junit.Type", "memberName", "", "a label")  // 88
        , new SeeTestCase(" junit.Type#memberName  a label ",  "junit.Type", "memberName", "", "a label")
        , new SeeTestCase("junit.Type#memberName() ",  "junit.Type", "memberName", "()", "")  // 90
        , new SeeTestCase(" junit.Type#memberName ()  ",  "junit.Type", "memberName", "()", "")
        , new SeeTestCase("junit.Type#memberName() label",  "junit.Type", "memberName", "()", "label")  // 92
        , new SeeTestCase(" junit.Type#memberName () label ",  "junit.Type", "memberName", "()", "label")
        , new SeeTestCase("junit.Type#memberName() a label",  "junit.Type", "memberName", "()", "a label")  // 94
        , new SeeTestCase(" junit.Type#memberName () a label ",  "junit.Type", "memberName", "()", "a label")
        , new SeeTestCase("junit.Type#memberName(int) ",  "junit.Type", "memberName", "(int)", "")  // 96
        , new SeeTestCase(" junit.Type#memberName (int)  ",  "junit.Type", "memberName", "(int)", "")
        , new SeeTestCase("junit.Type#memberName(int) label",  "junit.Type", "memberName", "(int)", "label")  // 98
        , new SeeTestCase(" junit.Type#memberName (int) label ",  "junit.Type", "memberName", "(int)", "label")
        , new SeeTestCase("junit.Type#memberName(int) a label",  "junit.Type", "memberName", "(int)", "a label")  // 100
        , new SeeTestCase(" junit.Type#memberName (int) a label ",  "junit.Type", "memberName", "(int)", "a label")
        , new SeeTestCase("junit.Type#memberName(int,String) ",  "junit.Type", "memberName", "(int,String)", "")  // 102
        , new SeeTestCase(" junit.Type#memberName (int,String)  ",  "junit.Type", "memberName", "(int,String)", "")
        , new SeeTestCase("junit.Type#memberName(int,String) label",  "junit.Type", "memberName", "(int,String)", "label")  // 104
        , new SeeTestCase(" junit.Type#memberName (int,String) label ",  "junit.Type", "memberName", "(int,String)", "label")
        , new SeeTestCase("junit.Type#memberName(int,String) a label",  "junit.Type", "memberName", "(int,String)", "a label")  // 106
        , new SeeTestCase(" junit.Type#memberName (int,String) a label ",  "junit.Type", "memberName", "(int,String)", "a label")
        , new SeeTestCase("junit.Type#memberName( int , String[ ][ ] ) ",  "junit.Type", "memberName", "( int , String[ ][ ] )", "")  // 108
        , new SeeTestCase(" junit.Type#memberName ( int , String[ ][ ] )  ",  "junit.Type", "memberName", "( int , String[ ][ ] )", "")
        , new SeeTestCase("junit.Type#memberName( int , String[ ][ ] ) label",  "junit.Type", "memberName", "( int , String[ ][ ] )", "label")  // 110
        , new SeeTestCase(" junit.Type#memberName ( int , String[ ][ ] ) label ",  "junit.Type", "memberName", "( int , String[ ][ ] )", "label")
        , new SeeTestCase("junit.Type#memberName( int , String[ ][ ] ) a label",  "junit.Type", "memberName", "( int , String[ ][ ] )", "a label")  // 112
        , new SeeTestCase(" junit.Type#memberName ( int , String[ ][ ] ) a label ",  "junit.Type", "memberName", "( int , String[ ][ ] )", "a label")
        , new SeeTestCase("junit.Type#memberName( foo.Bar , com.sun.X ) ",  "junit.Type", "memberName", "( foo.Bar , com.sun.X )", "")  // 114
        , new SeeTestCase(" junit.Type#memberName ( foo.Bar , com.sun.X )  ",  "junit.Type", "memberName", "( foo.Bar , com.sun.X )", "")
        , new SeeTestCase("junit.Type#memberName( foo.Bar , com.sun.X ) label",  "junit.Type", "memberName", "( foo.Bar , com.sun.X )", "label")  // 116
        , new SeeTestCase(" junit.Type#memberName ( foo.Bar , com.sun.X ) label ",  "junit.Type", "memberName", "( foo.Bar , com.sun.X )", "label")
        , new SeeTestCase("junit.Type#memberName( foo.Bar , com.sun.X ) a label",  "junit.Type", "memberName", "( foo.Bar , com.sun.X )", "a label")  // 118
        , new SeeTestCase(" junit.Type#memberName ( foo.Bar , com.sun.X ) a label ",  "junit.Type", "memberName", "( foo.Bar , com.sun.X )", "a label")
        , new SeeTestCase("junit.Type#memberName(foo.Bar) ",  "junit.Type", "memberName", "(foo.Bar)", "")  // 120
        , new SeeTestCase(" junit.Type#memberName (foo.Bar)  ",  "junit.Type", "memberName", "(foo.Bar)", "")
        , new SeeTestCase("junit.Type#memberName(foo.Bar) label",  "junit.Type", "memberName", "(foo.Bar)", "label")  // 122
        , new SeeTestCase(" junit.Type#memberName (foo.Bar) label ",  "junit.Type", "memberName", "(foo.Bar)", "label")
        , new SeeTestCase("junit.Type#memberName(foo.Bar) a label",  "junit.Type", "memberName", "(foo.Bar)", "a label")  // 124
        , new SeeTestCase(" junit.Type#memberName (foo.Bar) a label ",  "junit.Type", "memberName", "(foo.Bar)", "a label")
        , new SeeTestCase("org.aspectj.Type#memberName ",  "org.aspectj.Type", "memberName", "", "")  // 126
        , new SeeTestCase(" org.aspectj.Type#memberName   ",  "org.aspectj.Type", "memberName", "", "")
        , new SeeTestCase("org.aspectj.Type#memberName label",  "org.aspectj.Type", "memberName", "", "label")  // 128
        , new SeeTestCase(" org.aspectj.Type#memberName  label ",  "org.aspectj.Type", "memberName", "", "label")
        , new SeeTestCase("org.aspectj.Type#memberName a label",  "org.aspectj.Type", "memberName", "", "a label")  // 130
        , new SeeTestCase(" org.aspectj.Type#memberName  a label ",  "org.aspectj.Type", "memberName", "", "a label")
        , new SeeTestCase("org.aspectj.Type#memberName() ",  "org.aspectj.Type", "memberName", "()", "")  // 132
        , new SeeTestCase(" org.aspectj.Type#memberName ()  ",  "org.aspectj.Type", "memberName", "()", "")
        , new SeeTestCase("org.aspectj.Type#memberName() label",  "org.aspectj.Type", "memberName", "()", "label")  // 134
        , new SeeTestCase(" org.aspectj.Type#memberName () label ",  "org.aspectj.Type", "memberName", "()", "label")
        , new SeeTestCase("org.aspectj.Type#memberName() a label",  "org.aspectj.Type", "memberName", "()", "a label")  // 136
        , new SeeTestCase(" org.aspectj.Type#memberName () a label ",  "org.aspectj.Type", "memberName", "()", "a label")
        , new SeeTestCase("org.aspectj.Type#memberName(int) ",  "org.aspectj.Type", "memberName", "(int)", "")  // 138
        , new SeeTestCase(" org.aspectj.Type#memberName (int)  ",  "org.aspectj.Type", "memberName", "(int)", "")
        , new SeeTestCase("org.aspectj.Type#memberName(int) label",  "org.aspectj.Type", "memberName", "(int)", "label")  // 140
        , new SeeTestCase(" org.aspectj.Type#memberName (int) label ",  "org.aspectj.Type", "memberName", "(int)", "label")
        , new SeeTestCase("org.aspectj.Type#memberName(int) a label",  "org.aspectj.Type", "memberName", "(int)", "a label")  // 142
        , new SeeTestCase(" org.aspectj.Type#memberName (int) a label ",  "org.aspectj.Type", "memberName", "(int)", "a label")
        , new SeeTestCase("org.aspectj.Type#memberName(int,String) ",  "org.aspectj.Type", "memberName", "(int,String)", "")  // 144
        , new SeeTestCase(" org.aspectj.Type#memberName (int,String)  ",  "org.aspectj.Type", "memberName", "(int,String)", "")
        , new SeeTestCase("org.aspectj.Type#memberName(int,String) label",  "org.aspectj.Type", "memberName", "(int,String)", "label")  // 146
        , new SeeTestCase(" org.aspectj.Type#memberName (int,String) label ",  "org.aspectj.Type", "memberName", "(int,String)", "label")
        , new SeeTestCase("org.aspectj.Type#memberName(int,String) a label",  "org.aspectj.Type", "memberName", "(int,String)", "a label")  // 148
        , new SeeTestCase(" org.aspectj.Type#memberName (int,String) a label ",  "org.aspectj.Type", "memberName", "(int,String)", "a label")
        , new SeeTestCase("org.aspectj.Type#memberName( int , String[ ][ ] ) ",  "org.aspectj.Type", "memberName", "( int , String[ ][ ] )", "")  // 150
        , new SeeTestCase(" org.aspectj.Type#memberName ( int , String[ ][ ] )  ",  "org.aspectj.Type", "memberName", "( int , String[ ][ ] )", "")
        , new SeeTestCase("org.aspectj.Type#memberName( int , String[ ][ ] ) label",  "org.aspectj.Type", "memberName", "( int , String[ ][ ] )", "label")  // 152
        , new SeeTestCase(" org.aspectj.Type#memberName ( int , String[ ][ ] ) label ",  "org.aspectj.Type", "memberName", "( int , String[ ][ ] )", "label")
        , new SeeTestCase("org.aspectj.Type#memberName( int , String[ ][ ] ) a label",  "org.aspectj.Type", "memberName", "( int , String[ ][ ] )", "a label")  // 154
        , new SeeTestCase(" org.aspectj.Type#memberName ( int , String[ ][ ] ) a label ",  "org.aspectj.Type", "memberName", "( int , String[ ][ ] )", "a label")
        , new SeeTestCase("org.aspectj.Type#memberName( foo.Bar , com.sun.X ) ",  "org.aspectj.Type", "memberName", "( foo.Bar , com.sun.X )", "")  // 156
        , new SeeTestCase(" org.aspectj.Type#memberName ( foo.Bar , com.sun.X )  ",  "org.aspectj.Type", "memberName", "( foo.Bar , com.sun.X )", "")
        , new SeeTestCase("org.aspectj.Type#memberName( foo.Bar , com.sun.X ) label",  "org.aspectj.Type", "memberName", "( foo.Bar , com.sun.X )", "label")  // 158
        , new SeeTestCase(" org.aspectj.Type#memberName ( foo.Bar , com.sun.X ) label ",  "org.aspectj.Type", "memberName", "( foo.Bar , com.sun.X )", "label")
        , new SeeTestCase("org.aspectj.Type#memberName( foo.Bar , com.sun.X ) a label",  "org.aspectj.Type", "memberName", "( foo.Bar , com.sun.X )", "a label")  // 160
        , new SeeTestCase(" org.aspectj.Type#memberName ( foo.Bar , com.sun.X ) a label ",  "org.aspectj.Type", "memberName", "( foo.Bar , com.sun.X )", "a label")
        , new SeeTestCase("org.aspectj.Type#memberName(foo.Bar) ",  "org.aspectj.Type", "memberName", "(foo.Bar)", "")  // 162
        , new SeeTestCase(" org.aspectj.Type#memberName (foo.Bar)  ",  "org.aspectj.Type", "memberName", "(foo.Bar)", "")
        , new SeeTestCase("org.aspectj.Type#memberName(foo.Bar) label",  "org.aspectj.Type", "memberName", "(foo.Bar)", "label")  // 164
        , new SeeTestCase(" org.aspectj.Type#memberName (foo.Bar) label ",  "org.aspectj.Type", "memberName", "(foo.Bar)", "label")
        , new SeeTestCase("org.aspectj.Type#memberName(foo.Bar) a label",  "org.aspectj.Type", "memberName", "(foo.Bar)", "a label")  // 166
        , new SeeTestCase(" org.aspectj.Type#memberName (foo.Bar) a label ",  "org.aspectj.Type", "memberName", "(foo.Bar)", "a label")
        };
    public void testLink1() { CASES[1].run(); }
    public void testLink2() { CASES[2].run(); }
    public void testLink3() { CASES[3].run(); }
    public void testLink4() { CASES[4].run(); }
    public void testLink5() { CASES[5].run(); }
    public void testLink6() { CASES[6].run(); }
    public void testLink7() { CASES[7].run(); }
    public void testLink8() { CASES[8].run(); }
    public void testLink9() { CASES[9].run(); }
    public void testLink10() { CASES[10].run(); }
    public void testLink11() { CASES[11].run(); }
    public void testLink12() { CASES[12].run(); }
    public void testLink13() { CASES[13].run(); }
    public void testLink14() { CASES[14].run(); }
    public void testLink15() { CASES[15].run(); }
    public void testLink16() { CASES[16].run(); }
    public void testLink17() { CASES[17].run(); }
    public void testLink18() { CASES[18].run(); }
    public void testLink19() { CASES[19].run(); }
    public void testLink20() { CASES[20].run(); }
    public void testLink21() { CASES[21].run(); }
    public void testLink22() { CASES[22].run(); }
    public void testLink23() { CASES[23].run(); }
    public void testLink24() { CASES[24].run(); }
    public void testLink25() { CASES[25].run(); }
    public void testLink26() { CASES[26].run(); }
    public void testLink27() { CASES[27].run(); }
    public void testLink28() { CASES[28].run(); }
    public void testLink29() { CASES[29].run(); }
    public void testLink30() { CASES[30].run(); }
    public void testLink31() { CASES[31].run(); }
    public void testLink32() { CASES[32].run(); }
    public void testLink33() { CASES[33].run(); }
    public void testLink34() { CASES[34].run(); }
    public void testLink35() { CASES[35].run(); }
    public void testLink36() { CASES[36].run(); }
    public void testLink37() { CASES[37].run(); }
    public void testLink38() { CASES[38].run(); }
    public void testLink39() { CASES[39].run(); }
    public void testLink40() { CASES[40].run(); }
    public void testLink41() { CASES[41].run(); }
    public void testLink42() { CASES[42].run(); }
    public void testLink43() { CASES[43].run(); }
    public void testLink44() { CASES[44].run(); }
    public void testLink45() { CASES[45].run(); }
    public void testLink46() { CASES[46].run(); }
    public void testLink47() { CASES[47].run(); }
    public void testLink48() { CASES[48].run(); }
    public void testLink49() { CASES[49].run(); }
    public void testLink50() { CASES[50].run(); }
    public void testLink51() { CASES[51].run(); }
    public void testLink52() { CASES[52].run(); }
    public void testLink53() { CASES[53].run(); }
    public void testLink54() { CASES[54].run(); }
    public void testLink55() { CASES[55].run(); }
    public void testLink56() { CASES[56].run(); }
    public void testLink57() { CASES[57].run(); }
    public void testLink58() { CASES[58].run(); }
    public void testLink59() { CASES[59].run(); }
    public void testLink60() { CASES[60].run(); }
    public void testLink61() { CASES[61].run(); }
    public void testLink62() { CASES[62].run(); }
    public void testLink63() { CASES[63].run(); }
    public void testLink64() { CASES[64].run(); }
    public void testLink65() { CASES[65].run(); }
    public void testLink66() { CASES[66].run(); }
    public void testLink67() { CASES[67].run(); }
    public void testLink68() { CASES[68].run(); }
    public void testLink69() { CASES[69].run(); }
    public void testLink70() { CASES[70].run(); }
    public void testLink71() { CASES[71].run(); }
    public void testLink72() { CASES[72].run(); }
    public void testLink73() { CASES[73].run(); }
    public void testLink74() { CASES[74].run(); }
    public void testLink75() { CASES[75].run(); }
    public void testLink76() { CASES[76].run(); }
    public void testLink77() { CASES[77].run(); }
    public void testLink78() { CASES[78].run(); }
    public void testLink79() { CASES[79].run(); }
    public void testLink80() { CASES[80].run(); }
    public void testLink81() { CASES[81].run(); }
    public void testLink82() { CASES[82].run(); }
    public void testLink83() { CASES[83].run(); }
    public void testLink84() { CASES[84].run(); }
    public void testLink85() { CASES[85].run(); }
    public void testLink86() { CASES[86].run(); }
    public void testLink87() { CASES[87].run(); }
    public void testLink88() { CASES[88].run(); }
    public void testLink89() { CASES[89].run(); }
    public void testLink90() { CASES[90].run(); }
    public void testLink91() { CASES[91].run(); }
    public void testLink92() { CASES[92].run(); }
    public void testLink93() { CASES[93].run(); }
    public void testLink94() { CASES[94].run(); }
    public void testLink95() { CASES[95].run(); }
    public void testLink96() { CASES[96].run(); }
    public void testLink97() { CASES[97].run(); }
    public void testLink98() { CASES[98].run(); }
    public void testLink99() { CASES[99].run(); }
    public void testLink100() { CASES[100].run(); }
    public void testLink101() { CASES[101].run(); }
    public void testLink102() { CASES[102].run(); }
    public void testLink103() { CASES[103].run(); }
    public void testLink104() { CASES[104].run(); }
    public void testLink105() { CASES[105].run(); }
    public void testLink106() { CASES[106].run(); }
    public void testLink107() { CASES[107].run(); }
    public void testLink108() { CASES[108].run(); }
    public void testLink109() { CASES[109].run(); }
    public void testLink110() { CASES[110].run(); }
    public void testLink111() { CASES[111].run(); }
    public void testLink112() { CASES[112].run(); }
    public void testLink113() { CASES[113].run(); }
    public void testLink114() { CASES[114].run(); }
    public void testLink115() { CASES[115].run(); }
    public void testLink116() { CASES[116].run(); }
    public void testLink117() { CASES[117].run(); }
    public void testLink118() { CASES[118].run(); }
    public void testLink119() { CASES[119].run(); }
    public void testLink120() { CASES[120].run(); }
    public void testLink121() { CASES[121].run(); }
    public void testLink122() { CASES[122].run(); }
    public void testLink123() { CASES[123].run(); }
    public void testLink124() { CASES[124].run(); }
    public void testLink125() { CASES[125].run(); }
    public void testLink126() { CASES[126].run(); }
    public void testLink127() { CASES[127].run(); }
    public void testLink128() { CASES[128].run(); }
    public void testLink129() { CASES[129].run(); }
    public void testLink130() { CASES[130].run(); }
    public void testLink131() { CASES[131].run(); }
    public void testLink132() { CASES[132].run(); }
    public void testLink133() { CASES[133].run(); }
    public void testLink134() { CASES[134].run(); }
    public void testLink135() { CASES[135].run(); }
    public void testLink136() { CASES[136].run(); }
    public void testLink137() { CASES[137].run(); }
    public void testLink138() { CASES[138].run(); }
    public void testLink139() { CASES[139].run(); }
    public void testLink140() { CASES[140].run(); }
    public void testLink141() { CASES[141].run(); }
    public void testLink142() { CASES[142].run(); }
    public void testLink143() { CASES[143].run(); }
    public void testLink144() { CASES[144].run(); }
    public void testLink145() { CASES[145].run(); }
    public void testLink146() { CASES[146].run(); }
    public void testLink147() { CASES[147].run(); }
    public void testLink148() { CASES[148].run(); }
    public void testLink149() { CASES[149].run(); }
    public void testLink150() { CASES[150].run(); }
    public void testLink151() { CASES[151].run(); }
    public void testLink152() { CASES[152].run(); }
    public void testLink153() { CASES[153].run(); }
    public void testLink154() { CASES[154].run(); }
    public void testLink155() { CASES[155].run(); }
    public void testLink156() { CASES[156].run(); }
    public void testLink157() { CASES[157].run(); }
    public void testLink158() { CASES[158].run(); }
    public void testLink159() { CASES[159].run(); }
    public void testLink160() { CASES[160].run(); }
    public void testLink161() { CASES[161].run(); }
    public void testLink162() { CASES[162].run(); }
    public void testLink163() { CASES[163].run(); }
    public void testLink164() { CASES[164].run(); }
    public void testLink165() { CASES[165].run(); }
    public void testLink166() { CASES[166].run(); }
    public void testLink167() { CASES[167].run(); }
    public void testLink168() { CASES[168].run(); }

	// end of test cases generated
	
}



