/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:05:51 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.CumulativeATSkewAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class CumulativeATSkewAlgorithm_ESTest extends CumulativeATSkewAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("htsjdk.variant.vcf.VCFCompoundHeaderLine");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      emblStreamSequence0.copy();
      bases0.getComplementPosition(1337);
      cumulativeATSkewAlgorithm0.getDefaultStepSize(1);
      Bases bases1 = cumulativeATSkewAlgorithm0.getBases();
      Strand strand1 = bases1.getReverseStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm1 = new CumulativeATSkewAlgorithm(strand1);
      bases0.getAverageGCPercent();
      cumulativeATSkewAlgorithm1.getDefaultStepSize((-573));
      cumulativeATSkewAlgorithm1.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm1.getMinimumInternal();
      cumulativeATSkewAlgorithm1.getDefaultMinWindowSize();
      float[] floatArray0 = new float[25];
      floatArray0[0] = (float) 584;
      floatArray0[1] = (float) 0;
      floatArray0[2] = (float) 1;
      emblStreamSequence0.charAt(2);
      floatArray0[3] = (float) 5;
      floatArray0[4] = (float) 5;
      floatArray0[5] = (float) 0;
      cumulativeATSkewAlgorithm1.getValues(584, 1092, floatArray0);
      cumulativeATSkewAlgorithm0.getMinimumInternal();
      cumulativeATSkewAlgorithm1.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm0.getValueCount();
      cumulativeATSkewAlgorithm1.getAverage();
      cumulativeATSkewAlgorithm0.getDefaultStepSize(5);
      cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm0.getAverage();
      cumulativeATSkewAlgorithm1.getDefaultStepSize(2);
      cumulativeATSkewAlgorithm0.getMaximumInternal();
      // Undeclared exception!
      cumulativeATSkewAlgorithm0.getValues((-1048576), 10, floatArray0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      // Undeclared exception!
      try { 
        cumulativeATSkewAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("1'b%k4\"&JS<YT8.");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Range range0 = new Range(5);
      range0.toString();
      strand0.getSpacedTranslation(range0, false);
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      Strand strand1 = marker0.getStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand1);
      cumulativeATSkewAlgorithm0.getDefaultStepSize(1821);
      cumulativeATSkewAlgorithm0.setScalingFlag(false);
      cumulativeATSkewAlgorithm0.getDefaultStepSize(0);
      cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      float[] floatArray0 = new float[8];
      floatArray0[0] = (-570.015F);
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) 5;
      floatArray0[3] = (float) 2;
      floatArray0[4] = (float) 5;
      floatArray0[5] = (float) 0;
      floatArray0[6] = 6.0F;
      floatArray0[7] = (float) 0;
      // Undeclared exception!
      try { 
        cumulativeATSkewAlgorithm0.getValues(25, 3, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 0 > end: -22
         //
         verifyException("uk.ac.sanger.artemis.plot.CumulativeATSkewAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("N<yha0");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      strand0.getRawPosition(2004);
      bases0.getTCount();
      bases0.getLength();
      cumulativeATSkewAlgorithm0.getAverage();
      cumulativeATSkewAlgorithm0.getDefaultStepSize(3034);
      cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      cumulativeATSkewAlgorithm0.getAverage();
      emblStreamSequence0.copy();
      cumulativeATSkewAlgorithm0.getMinimum();
      cumulativeATSkewAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("w");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      int[] intArray0 = new int[9];
      intArray0[0] = 1;
      intArray0[1] = (-5);
      intArray0[2] = (-5);
      intArray0[3] = 1;
      intArray0[4] = (-5);
      intArray0[5] = 0;
      intArray0[6] = 1;
      intArray0[7] = 2;
      intArray0[8] = 0;
      rawStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      cumulativeATSkewAlgorithm0.setRevCompDisplay(false);
      Bases.complement("w");
      rawStreamSequence0.setFromChar(bases0.letter_index);
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        cumulativeATSkewAlgorithm0.getValues((-2404), 1660, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("FT3d[DbMb");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(rawStreamSequence0);
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Bases.reverseComplement("FT3d[DbMb");
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      cumulativeATSkewAlgorithm0.getValueCount();
      cumulativeATSkewAlgorithm0.getAverage();
      cumulativeATSkewAlgorithm0.getDefaultMaxWindowSize();
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("htsjdk.variant.vcf.VCFCompoundHeaderLine");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      emblStreamSequence0.copy();
      bases0.getComplementPosition(1337);
      cumulativeATSkewAlgorithm0.getDefaultStepSize(1);
      Bases bases1 = cumulativeATSkewAlgorithm0.getBases();
      Strand strand1 = bases1.getReverseStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm1 = new CumulativeATSkewAlgorithm(strand1);
      bases0.getAverageGCPercent();
      Integer integer0 = cumulativeATSkewAlgorithm1.getDefaultStepSize((-570));
      assertNull(integer0);
      
      cumulativeATSkewAlgorithm1.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm1.getMinimumInternal();
      cumulativeATSkewAlgorithm1.getDefaultMinWindowSize();
      strand1.getACount();
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 584;
      floatArray0[1] = (float) 0;
      floatArray0[2] = (float) 1;
      emblStreamSequence0.charAt(2);
      floatArray0[3] = (float) 5;
      floatArray0[4] = (float) 5;
      floatArray0[5] = (float) 0;
      cumulativeATSkewAlgorithm1.getValues(584, 1092, floatArray0);
      assertArrayEquals(new float[] {0.0F, 0.0F, 1.0F, 5.0F, 5.0F, 0.0F}, floatArray0, 0.01F);
      
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals((-1.0F), (float)float0, 0.01F);
      
      cumulativeATSkewAlgorithm1.getDefaultMinWindowSize();
      int int0 = cumulativeATSkewAlgorithm0.getValueCount();
      assertEquals(1, int0);
      
      cumulativeATSkewAlgorithm1.getAverage();
      cumulativeATSkewAlgorithm0.getDefaultStepSize(5);
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      assertEquals(10, (int)integer1);
      
      Float float1 = cumulativeATSkewAlgorithm0.getAverage();
      assertEquals(0.2F, (float)float1, 0.01F);
      
      Integer integer2 = cumulativeATSkewAlgorithm1.getDefaultStepSize(2);
      assertTrue(cumulativeATSkewAlgorithm1.scalingFlag());
      assertNull(integer2);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("8_`QpX,MB\"oo_`)K");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(rawStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.elementAt((-2232));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "`wA}\"/gu[$");
      // Undeclared exception!
      try { 
        filteredEntryGroup0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      Bases bases1 = strand0.getBases();
      bases1.getReverseStrand();
      Clipboard clipboard0 = new Clipboard(">gDS/g;\"kk6");
      Selection selection0 = new Selection(clipboard0);
      selection0.getSelectionRange();
      // Undeclared exception!
      try { 
        bases1.truncate((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand0);
      cumulativeATSkewAlgorithm0.getDefaultStepSize(1);
      int[] intArray0 = new int[0];
      int[] intArray1 = new int[3];
      intArray1[0] = 1;
      intArray1[1] = 2;
      intArray1[2] = 0;
      fastaStreamSequence0.setFastaHeaderPosition(intArray0, intArray1);
      cumulativeATSkewAlgorithm0.getMaximumInternal();
      Float float0 = cumulativeATSkewAlgorithm0.getMinimumInternal();
      assertEquals((-1.0F), (float)float0, 0.01F);
      
      Integer integer0 = cumulativeATSkewAlgorithm0.getDefaultStepSize(1);
      assertNull(integer0);
      
      float[] floatArray0 = new float[7];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 0;
      floatArray0[2] = (float) 1;
      floatArray0[3] = (float) 2;
      floatArray0[4] = (float) 1;
      floatArray0[5] = (float) 0;
      floatArray0[6] = (float) 1;
      cumulativeATSkewAlgorithm0.getValues(0, 0, floatArray0);
      assertArrayEquals(new float[] {0.0F, 0.0F, 1.0F, 2.0F, 1.0F, 0.0F, 1.0F}, floatArray0, 0.01F);
      
      cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      Float float1 = cumulativeATSkewAlgorithm0.getMaximumInternal();
      assertEquals(1.0F, (float)float1, 0.01F);
      
      Integer integer1 = cumulativeATSkewAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer1);
      assertEquals(60, (int)integer1);
      
      Float float2 = cumulativeATSkewAlgorithm0.getAverage();
      assertEquals(0.0F, (float)float2, 0.01F);
      
      Integer integer2 = cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      assertTrue(cumulativeATSkewAlgorithm0.scalingFlag());
      assertNotNull(integer2);
      assertEquals(10, (int)integer2);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = null;
      try {
        cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("1'b%k4\"&JS<YT8.");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      Range range0 = new Range(5);
      range0.toString();
      strand0.getSpacedTranslation(range0, false);
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      Strand strand1 = marker0.getStrand();
      CumulativeATSkewAlgorithm cumulativeATSkewAlgorithm0 = new CumulativeATSkewAlgorithm(strand1);
      cumulativeATSkewAlgorithm0.getDefaultStepSize(1821);
      cumulativeATSkewAlgorithm0.setScalingFlag(false);
      cumulativeATSkewAlgorithm0.getDefaultStepSize(0);
      cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm0.getDefaultMinWindowSize();
      cumulativeATSkewAlgorithm0.getDefaultStepSize((-3263));
  }
}
