/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:48:09 GMT 2018
 */

package uk.ac.sanger.artemis.editor;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.MockitoExtension.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandler;
import javax.swing.JDesktopPane;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.editor.Annotation;
import uk.ac.sanger.artemis.editor.DataCollectionPane;
import uk.ac.sanger.artemis.editor.DataViewInternalFrame;
import uk.ac.sanger.artemis.editor.FastaTextPane;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class DataCollectionPane_ESTest extends DataCollectionPane_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL0 = MockURL.URL("", (String) null, 10, "<title>", uRLStreamHandler0);
      JDesktopPane jDesktopPane0 = new JDesktopPane();
      // Undeclared exception!
      try { 
        DataCollectionPane.setUpSRSFrame(uRL0, "", jDesktopPane0);
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // java.lang.reflect.InvocationTargetException
         //
         verifyException("javax.swing.JEditorPane", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      // Undeclared exception!
      try { 
        DataCollectionPane.setUpSRSFrame((URL) null, "", (JDesktopPane) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.editor.DataCollectionPane", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      URL uRL0 = MockURL.URL("http://www.bioinformatics.nl/srsbin/cgi-bin/");
      JDesktopPane jDesktopPane0 = new JDesktopPane();
      try { 
        DataCollectionPane.setUpSRSFrame(uRL0, "http://www.bioinformatics.nl/srsbin/cgi-bin/", jDesktopPane0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Could not find: www.bioinformatics.nl
         //
         verifyException("org.evosuite.runtime.mock.java.net.EvoHttpURLConnection", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      String string0 = DataCollectionPane.getSrsSite();
      assertEquals("http://www.bioinformatics.nl/srsbin/cgi-bin/", string0);
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      Annotation annotation0 = new Annotation((JDesktopPane) null);
      DataCollectionPane dataCollectionPane0 = null;
      try {
        dataCollectionPane0 = new DataCollectionPane((FastaTextPane) null, annotation0, (JDesktopPane) null, (DataViewInternalFrame) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.editor.DataCollectionPane", e);
      }
  }
}
