## About
*Antimony* is a computer-aided design (CAD) tool from a parallel universe
in which CAD software evolved from Lisp machines rather than drafting tables

This work is a spiritual successor to [kokopelli](https://github.com/mkeeter/kokopelli)
by way of [fabserver](http://kokompe.cba.mit.edu).

For more details and screenshots, look at [this writeup](http://mattkeeter.com/projects/antimony).

## Try it
*Antimony* is under active development.  It's at a beta level of stability:
solid, but not recommended for mission-critical use.

To get started, there are two suggested options:
- Download a [pre-built application](https://github.com/mkeeter/antimony/releases) (Mac only)
- [Build from source](https://github.com/mkeeter/antimony/blob/develop/BUILDING.md) (Mac and Linux)

There is also a community-supported package for [Fedora 22 or later](https://admin.fedoraproject.org/pkgdb/package/antimony/):
```
dnf install antimony
```
(or `dnf install antimony --enablerepo=updates-testing` to get testing builds)

## Support

If you have a general question, [send it along to the Google Group](https://groups.google.com/forum/#!forum/antimony-dev).

If you have a specific issue, [check the issues](https://github.com/mkeeter/antimony/issues) to see if someone else has had the same problem.

## License
Antimony is released under the MIT License:

Copyright (c) 2013-2015 Matthew Keeter and other contributors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

Antimony includes code from [kokopelli](https://github.com/mkeeter/kokopelli), which is  
© 2012-2013 Massachusetts Institute of Technology  
© 2013 Matthew Keeter
