% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{hash_animal}
\alias{hash_animal}
\title{Adjective-animal hash}
\usage{
hash_animal(x, n_adj = 2)
}
\arguments{
\item{x}{Character vector. \code{NA} entries will have an \code{NA} hash.}

\item{n_adj}{Number of adjectives to use. It must be between 0 and 3.}
}
\value{
A data frame with columns
\itemize{
\item \code{hash}: the hash value, a string.
\item \code{words}: list column with the adjectives and the animal name in a
character vector.
}
}
\description{
Adjective-animal hash
}
\details{
It uses the first 13 hexadecimal characters (out of the 32) of the MD5
hash of the input, and converts them into an adjective-animal form to
create a human readable hash.
\subsection{Number of possible hash values}{

\code{hash_animals()} uses 1748 animal names and
8946 different adjectives. The number of
different hashes you can get for different values of \code{n_adj}:\tabular{rr}{
   \code{n_adj} \tab size of the hash table space \cr
   0 \tab 1,748 \cr
   1 \tab 15,637,608 \cr
   2 \tab 139,894,041,168 \cr
   3 \tab 1,251,492,092,288,928 \cr
}

}

\subsection{Source}{

The list of adjectives and animals comes from the ids package,
and in turn from
\url{https://github.com/a-type/adjective-adjective-animal}, and
from \url{https://gfycat.com}.
}
}
\examples{
hash_animal(c("foo", "bar"))

# if you increase `n_adj`, the shorter hash is a suffix of the longer:
hash_animal("cli package", 0)$hash
hash_animal("cli package", 1)$hash
hash_animal("cli package", 2)$hash
hash_animal("cli package", 3)$hash
}
\seealso{
the ids package for generating random adjective-animal ids

Other hash functions: 
\code{\link{hash_emoji}()},
\code{\link{hash_md5}()}
}
\concept{hash functions}
